<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use App\Mail\EnviarCorreoTramiteDocumentario;
use Illuminate\Support\Facades\Mail;

class TdRegistrarController extends Controller
{
    // public function index()
    // {
    //     return view('tramite_documentario.index');
    // }

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                // si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('tramite_documentario.registrar.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                // docente
                $tipoacceso = 2;
                return view('tramite_documentario.registrar.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "3") {
                // alumno
                $tipoacceso = 3;
                return view('tramite_documentario.registrar.index')->with('datatipoacceso', $tipoacceso);
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function registrar(Request $request)
    {

        $item = new Td();

        $ultimoNumero = $item::max('numero');
        $numeroNuevo = $ultimoNumero ? $ultimoNumero + 1 : 1;
        $numeroNuevo = str_pad($numeroNuevo, 8, '0', STR_PAD_LEFT); // '00000001'

        $item->serie = 'NT001';
        $item->numero = $numeroNuevo;

        $item->info_asunto = $request->input('txt_asunto');
        $item->info_documentos = $request->input('txt_documentos');
        $item->info_folios = $request->input('txt_folios');
        $item->fecha = Carbon::now();
        $item->is_eliminado = 0;

        $item->area_id = $request->input('txt_area');
        $item->td_tipo_id = $request->input('txt_td_tipo');
        $item->td_estado_id = 1; // 1 -> recibido // 2 -> respondido

        $user = Auth::user();
        $item->user_id = $user->id;

        if ($request->hasFile('documento')) {
            // validar documento
            $validator = Validator::make($request->all(), [
                'documento' => 'required|file|mimes:pdf|max:2000', // Valida PDF y tamaño máximo de 2MB
            ], [
                'documento.file' => 'El archivo PDF es requerido.',
                'documento.mimes' => 'El archivo debe ser un PDF.',
                'documento.max' => 'El tamaño del archivo no debe superar los 2 MB.',
            ]);
            // documento inválido
            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => $validator->errors()->first(),
                ]);
            }
            // documento válido
            else {
                $tdPath = "tramites_documentarios/recibidos";

                $yearMonth = Carbon::now()->format('Ym');  // '202411'
                $dateTime = now()->format('YmdHis');  // '20241106095930'
                $fileName = "{$user->nroidenti}_{$dateTime}.pdf"; // 73223649_20241106095930.pdf

                $folderName = "{$tdPath}/{$yearMonth}";
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('documento');   // obtenemos el archivo
                $archivo->storeAs("{$folderName}", $fileName);  // guardado (ruta,nombre del archivo)

                $filePath = "{$folderName}/{$fileName}";  // ruta del archivo
                $item->pdf_recibido = $filePath;
                // guardar
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Trámite Documentario registrado correctamente', "nt" => "{$item->serie}-{$item->numero}"]);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no registrado']);
                }
            }
        }
    }


    public function index_libre()
    {
        return view('tramite_documentario.registrar_libre.index');
    }

    public function registrar_libre(Request $request)
    {

        $item = new Td();

        $ultimoNumero = $item::max('numero');
        $numeroNuevo = $ultimoNumero ? $ultimoNumero + 1 : 1;
        $numeroNuevo = str_pad($numeroNuevo, 8, '0', STR_PAD_LEFT); // '00000001'

        $item->serie = 'NT001';
        $item->numero = $numeroNuevo;

        $item->info_asunto = $request->input('txt_asunto');
        $item->info_documentos = $request->input('txt_documentos');
        $item->info_folios = $request->input('txt_folios');
        $item->fecha = Carbon::now();
        $item->is_eliminado = 0;

        $item->area_id = $request->input('txt_area');
        $item->td_tipo_id = $request->input('txt_td_tipo');
        $item->td_estado_id = 1; // 1 -> recibido // 2 -> respondido

        // LIBRE
        $item->tipo_solicitante_id = $request->input('txt_td_tipo_solicitante');
        $item->tipo_identificacion_id = $request->input('txt_identification_type');
        $item->programa_id = $request->input('txt_programa');
        $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
        $item->ubigeo_id = $idubigeo;

        $item->apellido_pa = strtoupper($request->input('txt_apellido_pa'));
        $item->apellido_ma = strtoupper($request->input('txt_apellido_ma'));
        $item->nombres = strtoupper($request->input('txt_nombres'));
        $item->celular = $request->input('txt_celular');
        // $item->telefono = $request->input('txt_telefono');
        $item->correo = $request->input('txt_correo');
        $item->direccion = strtoupper($request->input('txt_direccion'));
        $item->numero_documento = $request->input('txt_numero_documento');
        // LIBRE

        if (Auth::user()) {
            $user = Auth::user();
            $item->user_id = $user->id;
        }

        if ($request->hasFile('documento')) {
            // validar documento
            $validator = Validator::make($request->all(), [
                'documento' => 'required|file|mimes:pdf|max:2000', // Valida PDF y tamaño máximo de 2MB
            ], [
                'documento.file' => 'El archivo PDF es requerido.',
                'documento.mimes' => 'El archivo debe ser un PDF.',
                'documento.max' => 'El tamaño del archivo no debe superar los 2 MB.',
            ]);
            // documento inválido
            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => $validator->errors()->first(),
                ]);
            }
            // documento válido
            else {
                $tdPath = "tramites_documentarios/recibidos";

                $yearMonth = Carbon::now()->format('Ym');  // '202411'
                $dateTime = now()->format('YmdHis');  // '20241106095930'
                $fileName = "{$item->numero_documento}_{$dateTime}.pdf"; // 73223649_20241106095930.pdf

                $folderName = "{$tdPath}/{$yearMonth}";
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('documento');   // obtenemos el archivo
                $archivo->storeAs("{$folderName}", $fileName);  // guardado (ruta,nombre del archivo)

                $filePath = "{$folderName}/{$fileName}";  // ruta del archivo
                $item->pdf_recibido = $filePath;
                // guardar
                if ($item->save()) {

                    // CORREO
                    $email_destino = $item->correo;
                    // $area = $item->area->nombre;
                    $asunto = $item->info_asunto;
                    $solicitante = "{$item->apellido_pa} {$item->apellido_ma}, {$item->nombres}";
                    $codigo_nt = "{$item->serie}-{$item->numero}";
                    Mail::to($email_destino)->send(new EnviarCorreoTramiteDocumentario($asunto, $solicitante,  $codigo_nt));
                    // CORREO

                    return response()->json(["status" => true, "mensaje" => 'Trámite Documentario registrado correctamente', "nt" => "{$item->serie}-{$item->numero}"]);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no registrado']);
                }
            }
        }
    }
}
