<?php

namespace App\Http\Controllers\reportes;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Support\Facades\DB;
use \Illuminate\Support\Facades\Auth;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Str;
use App\Models\User;
use App\Models\Student;
use App\Models\Subject;
use App\Models\Course;
use App\Models\Period;
use App\Models\Plan;

use Illuminate\Support\Facades\URL;

use App\Providers\AppServiceProvider;
use App\Services\QrGeneratorService;

class ReportesController extends Controller
{

    public function index1(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            $idusertype = Auth::User()->usertype_id;
            
            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.notas.gestionar_notas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index2(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            $idusertype = Auth::User()->usertype_id;
            
            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.notas.reporte_notas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        $idsemester = $request->input('idsemester');
        $idperiod = $request->input('idperiod');
        
        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('semestres as se', 'su.semester_id', '=', 'se.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->leftJoin('docentes as te', 'su.teacher_id', '=', 'te.id')
                ->leftJoin('usuarios as us', 'te.user_id', '=', 'us.id')
                ->select(
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.tipo as condicion',
                    'su.nota_minima',
                    'su.teacher_id',
                    'co.codcurso',
                    'co.nombre as nomcurso',
                    'co.creditos',
                    'co.horas',
                    'co.tipo',
                    'se.id as idsemester',
                    'co.id as idcourse',
                    'pe.id as idperiod',
                    'us.apellido_pa',
                    'us.apellido_ma'
                )
                ->where('se.id', $idsemester)
                ->where('pe.id', $idperiod)
                ->orderBy('co.tipo', 'desc')
                ->orderBy('co.nombre', 'asc')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function nota_asignatura($idsemester, $idsubject)
    {
        $infos = DB::table('asignaturas')
            ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
            ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
            ->join('planes', 'planes.id', '=', 'periodos.plan_id')
            ->join('programas', 'programas.id', '=', 'planes.program_id')
            ->crossJoin('semestres')
            ->select(
                'asignaturas.id as idsubject',
                'cursos.codcurso as codcurso',
                'cursos.nombre as curso',
                'cursos.tipo as tipo',
                'asignaturas.tipo as condicion',
                'periodos.numero as periodo',
                DB::raw("CONCAT('Plan ', planes.nombre, ' (', planes.tipo, ')') as plan"),
                'programas.nombre as programa',
                'programas.nivel_formativo',
                DB::raw("CONCAT(semestres.anho, '-', semestres.numero) as semestre")
            )
            ->where('asignaturas.id', $idsubject)
            ->where('semestres.id', $idsemester)
        ->get();

        $usuarios = DB::table('asignaturas')
        ->join('matriculas_asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
        ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
        ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
        ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
        ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
        ->join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
        ->select(
            'cursos.nombre as curso',
            'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
            'usuarios.nroidenti',
            DB::raw('CONCAT(usuarios.nombres, " ", usuarios.apellido_pa, " ", usuarios.apellido_ma) as estudiante'),
            'matriculas_asignaturas.nota'
        )
        ->where('asignaturas.id', $idsubject)
        ->get();

        $pdf = PDF::loadView('reportes.nota_asignatura', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'usuarios' => $usuarios
        ]);
        // $pdf->setPaper('a4', 'landscape');
        // return $pdf->download('reporte_'.$cadenaAleatoria.'.pdf');
        return $pdf->stream();
    }

    public function nota_periodo($idsemester, $idperiod)
    {
        $infos = DB::table('periodos')
            ->join('planes', 'planes.id', '=', 'periodos.plan_id')
            ->join('programas', 'programas.id', '=', 'planes.program_id')
            ->crossJoin('semestres')
            ->select(
                'periodos.numero as periodo',
                DB::raw("CONCAT('Plan ', planes.nombre, ' (', planes.tipo, ')') as plan"),
                'programas.nombre as programa',
                'programas.nivel_formativo',
                DB::raw("CONCAT(semestres.anho, '-', semestres.numero) as semestre")
            )
            ->where('periodos.id', '=', $idperiod)
            ->where('semestres.id', '=', $idsemester)
            ->get();

        // Obtener la lista de cursos
        $querycursos = DB::table('asignaturas')
        ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
        ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
        ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
        ->select(
                'cursos.nombre',
                'cursos.tipo as tipo',
                'asignaturas.tipo as condicion'
                )
        ->where('semestres.id', '=', $idsemester)
        ->where('periodos.id', '=', $idperiod);


        // Construir la consulta dinámica
        $query = DB::table('asignaturas')
            ->join('matriculas_asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
            ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
            ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
            ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
            ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
            ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
            ->select(
                'usuarios.nroidenti',
                DB::raw('CONCAT(usuarios.nombres, " ", usuarios.apellido_pa, " ", usuarios.apellido_ma) AS estudiante')
            );

        $cursos = $querycursos->pluck('nombre');
        foreach ($cursos as $curso) {
            $nombre_columna = str_replace(' ', '_', $curso);
            $nombre_columna = str_replace('-', ' ', $nombre_columna); // Reemplazar guiones bajos por espacios
            $query->addSelect(DB::raw('MAX(CASE WHEN cursos.nombre = "' . $curso . '" THEN COALESCE(asignaturas.nota_minima, "NM") END) AS ' . $nombre_columna));
        }

        $query->where('periodos.id', '=', $idperiod)
            ->where('semestres.id', '=', $idsemester)
            ->groupBy('usuarios.nroidenti', 'estudiante');

        // Ejecutar la consulta
        $usuarios = $query->get();
        $nomcursos = $querycursos->orderBy('tipo', 'desc')->get();


        $pdf = PDF::loadView('reportes.nota_periodo', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'usuarios' => $usuarios,
            'nomcursos' => $nomcursos
        ]);

        return $pdf->stream();
    }


    public function curso_semestre_alumno($idsemester, $idstudent)
    {
        $cursos = DB::table('matriculas_asignaturas')
        ->join('asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
        ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
        ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
        ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
        ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
        ->select(
            'cursos.codcurso',
            'cursos.nombre AS curso',
            'cursos.tipo',
            'cursos.creditos',
            'periodos.numero AS periodo',
            DB::raw('CONCAT(semestres.anho, "-", semestres.numero) AS semestre'),
            DB::raw('COALESCE(matriculas_asignaturas.nota, "NM") AS nota'),
        )
        ->where('matriculas_asignaturas.student_id', $idstudent)
        ->where('semestres.id', $idsemester)
        ->orderByDesc('semestre')
        ->orderBy('periodo')
        ->orderBy('curso')
        ->get();

        $estudiantes = DB::table('estudiantes')
        ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
        ->join('planes', 'planes.id', '=', 'estudiantes.plan_id')
        ->join('programas', 'programas.id', '=', 'planes.program_id')
        ->crossJoin('semestres')
        ->select(
            'usuarios.nroidenti',
            DB::raw('CONCAT(usuarios.apellido_pa, " ", usuarios.apellido_ma, ", ", usuarios.nombres) AS estudiante'),
            'programas.nombre AS programa',
            'programas.nivel_formativo',
            DB::raw('CONCAT("Plan ", planes.nombre, " (", planes.tipo, ")") AS plan'),
            DB::raw('CONCAT(semestres.anho, "-", semestres.numero) AS semestre')
        )
        ->where('estudiantes.id', $idstudent)
        ->where('semestres.id', $idsemester)
        ->get();


        $pdf = PDF::loadView('reportes.curso_semestre_alumno', [
            'institutions' => AppServiceProvider::$institutions,
            'estudiantes' => $estudiantes,
            'cursos' => $cursos
        ]);
        // $pdf->setPaper('a4', 'landscape');
        // return $pdf->download('reporte_'.$cadenaAleatoria.'.pdf');
        return $pdf->stream();
    }


    public function curso_total_alumno($idsemester, $idstudent)
    {
        $cursos = DB::table('matriculas_asignaturas')
        ->join('asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
        ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
        ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
        ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
        ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
        ->select(
            'cursos.codcurso',
            'cursos.nombre AS curso',
            'cursos.tipo',
            'cursos.creditos',
            'periodos.numero AS periodo',
            DB::raw('CONCAT(semestres.anho, "-", semestres.numero) AS semestre'),
            DB::raw('COALESCE(matriculas_asignaturas.nota, "NM") AS nota'),
        )
        ->where('matriculas_asignaturas.student_id', $idstudent)
        ->orderByDesc('semestre')
        ->orderBy('curso')
        ->get();

        $estudiantes = DB::table('estudiantes')
        ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
        ->join('planes', 'planes.id', '=', 'estudiantes.plan_id')
        ->join('programas', 'programas.id', '=', 'planes.program_id')
        ->crossJoin('semestres')
        ->select(
            'usuarios.nroidenti',
            DB::raw('CONCAT(usuarios.apellido_pa, " ", usuarios.apellido_ma, ", ", usuarios.nombres) AS estudiante'),
            'programas.nombre AS programa',
            'programas.nivel_formativo',
            DB::raw('CONCAT("Plan ", planes.nombre, " (", planes.tipo, ")") AS plan'),
            DB::raw('CONCAT(semestres.anho, "-", semestres.numero) AS semestre')
        )
        ->where('estudiantes.id', $idstudent)
        ->where('semestres.id', $idsemester)
        ->get();

        $pdf = PDF::loadView('reportes.curso_total_alumno', [
            'institutions' => AppServiceProvider::$institutions,
            'estudiantes' => $estudiantes,
            'cursos' => $cursos
        ]);

        return $pdf->stream();
    }


    public function acta_oficial_notas($idsubject)
    {
        $infos = DB::table('asignaturas as a')
            ->select([
                DB::raw('CONCAT(se.anho, "-", se.numero) as semestre'),
                'pr.codprograma',
                'pr.nombre as programa',
                'pr.nivel_formativo as nivel_formativo',
                'pl.nombre as plan',
                'c.codcurso',
                'c.nombre as curso',
                DB::raw('CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) as creditos_horas'),
                'pe.numero as periodo',
                'a.tipo as condicion',
                'a.seccion',
                'a.turno'
            ])
            ->join('cursos as c', 'c.id', '=', 'a.course_id')
            ->join('periodos as pe', 'pe.id', '=', 'c.period_id')
            ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
            ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
            ->join('semestres as se', 'se.id', '=', 'a.semester_id')
            ->where('a.id', '=', $idsubject)
            ->orderBy('c.nombre')
        ->get();

        $indicadores2 = DB::table('indicadores as i')
            ->join('asignaturas as a', 'a.id', '=', 'i.subject_id')
            ->where('a.id', $idsubject)
            ->pluck('i.nombre')
        ->toArray();

        // Obteniendo los indicadores
        $indicadores = DB::table('indicadores as i')
            ->join('asignaturas as a', 'a.id', '=', 'i.subject_id')
            ->where('a.id', $idsubject)
            ->pluck('i.id')
            ->toArray();

        $numIndicadores = count($indicadores);

        // Subconsulta gradesQuery
        $gradesQuery = DB::table('estudiantes as e')
            ->join('usuarios as u', 'e.user_id', '=', 'u.id')
            ->join('tipos_identificaciones as ti', 'u.identificationtype_id', '=', 'ti.id')
            ->join('matriculas_asignaturas as ma', 'e.id', '=', 'ma.student_id')
            ->join('asignaturas as a', 'ma.subject_id', '=', 'a.id')
            ->leftJoin('indicadores as i', 'i.subject_id', '=', 'a.id')
            ->leftJoin('actividades as ac', 'ac.indicator_id', '=', 'i.id')
            ->leftJoin('notas as n', 'n.activity_id', '=', 'ac.id')
            ->leftJoin('notas_estudiantes as ne', function ($join) {
                $join->on('ne.grade_id', '=', 'n.id')
                    ->on('ne.subjectenrollment_id', '=', 'ma.id');
            })
            ->where('a.id', $idsubject)
            ->groupBy([
                'a.id', 'e.id', 'ti.tipo', 'u.nroidenti', 'u.apellido_pa', 'u.apellido_ma', 'u.nombres',
                'i.id', 'ac.id', 'n.id', 'ne.id', 'n.nombre', 'n.porcentaje'
            ])
            ->selectRaw('
                a.id AS idsubject,
                e.id AS idstudent,
                CONCAT(u.nroidenti) AS identificacion,
                CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante,
                i.id AS idindicator,
                ac.id AS idactivity,
                COALESCE(n.id, 0) AS idgrade,
                COALESCE(n.nombre, "-") AS tipo_nota,
                COALESCE(n.porcentaje, 0) AS porcentaje,
                COALESCE(ne.id, 0) AS idstudentgrade,
                COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 2), 0) AS nota
            ');

        // Subconsulta activityQuery
        $activityQuery = DB::table(DB::raw("({$gradesQuery->toSql()}) as gradesQuery"))
            ->mergeBindings($gradesQuery)
            ->groupBy([
                'idsubject', 'idstudent', 'identificacion', 'estudiante', 'idindicator', 'idactivity'
            ])
            ->selectRaw('
                idsubject,
                idstudent,
                identificacion,
                estudiante,
                idindicator,
                idactivity,
                COALESCE(ROUND(SUM(nota * porcentaje), 2), 0) AS promedio_actividades
            ');

        // Subconsulta indicatorQuery
        $indicatorQuery = DB::table(DB::raw("({$activityQuery->toSql()}) as activityQuery"))
            ->mergeBindings($activityQuery)
            ->groupBy([
                'idsubject', 'idstudent', 'identificacion', 'estudiante', 'idindicator'
            ])
            ->selectRaw('
                idsubject,
                idstudent,
                identificacion,
                estudiante,
                idindicator,
                COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 2), 0) AS promedio_indicadores
            ');

        // Construyendo la parte dinámica de la consulta final
        $selectPromedios = [];
        foreach ($indicadores as $id) {
            $selectPromedios[] = "ROUND(MAX(CASE WHEN idindicator = $id THEN promedio_indicadores ELSE NULL END), 2) AS promedio_indicador_$id";
        }

        $selectPromedios = implode(', ', $selectPromedios);

        // Consulta final
        $estudiantes = DB::table(DB::raw("({$indicatorQuery->toSql()}) as indicatorQuery"))
            ->mergeBindings($indicatorQuery)
            ->groupBy(['idsubject', 'idstudent', 'identificacion', 'estudiante'])
            ->selectRaw("
                idsubject,
                idstudent,
                identificacion,
                estudiante,
                $selectPromedios,
                ROUND(
                    (
                        " . implode(' + ', array_map(function($id) {
                            return "COALESCE(MAX(CASE WHEN idindicator = $id THEN ROUND(promedio_indicadores, 2) ELSE NULL END), 0)";
                        }, $indicadores)) . "
                    ) / $numIndicadores
                , 2) AS promedio_final
            ")
        ->get();

        $currentUrl = URL::current();
        $link = $currentUrl;
        $qrCode = (new QrGeneratorService())->get_qr_by_link($link);

        $pdf = PDF::loadView('reportes.acta_oficial_notas', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'indicadores' => $indicadores,
            'indicadores2' => $indicadores2,
            'estudiantes' => $estudiantes,
            'qrCode' => $qrCode
        ]);

        return $pdf->stream();
    }


    public function acta_auxiliar_notas($idsubject)
    {
        $infos = DB::table('asignaturas as a')
            ->select([
                DB::raw('CONCAT(se.anho, "-", se.numero) as semestre'),
                'pr.codprograma',
                'pr.nombre as programa',
                'pr.nivel_formativo as nivel_formativo',
                'pl.nombre as plan',
                'c.codcurso',
                'c.nombre as curso',
                DB::raw('CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) as creditos_horas'),
                'pe.numero as periodo',
                'a.tipo as condicion',
                'a.seccion',
                'a.turno'
            ])
            ->join('cursos as c', 'c.id', '=', 'a.course_id')
            ->join('periodos as pe', 'pe.id', '=', 'c.period_id')
            ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
            ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
            ->join('semestres as se', 'se.id', '=', 'a.semester_id')
            ->where('a.id', '=', $idsubject)
            ->orderBy('c.nombre')
        ->get();

        $notas = DB::table('notas as n')
            ->join('actividades as a', 'a.id', '=', 'n.activity_id')
            ->join('indicadores as i', 'i.id', '=', 'a.indicator_id')
            ->where('i.subject_id', $idsubject)
            ->select(
                'i.id as indicador_id',
                'i.nombre as indicador',
                'a.id as actividad_id',
                'a.nombre as actividad',
                'n.nombre as tiponota',
                DB::raw('CONCAT(ROUND(n.porcentaje*100,0), "%") as porcentaje'),
                'n.id as nota_id',
                'n.nombre as nota'
            )
            ->groupBy('i.id', 'a.id', 'n.id', 'i.nombre', 'a.nombre', 'n.nombre', 'n.porcentaje', 'n.nombre')
            ->orderBy('i.id')
            ->orderBy('a.nombre', 'asc')
        ->get();

        $queryNotas = '
            WITH ranked_data AS (
                SELECT
                    i.id AS idindicator,
                    i.nombre AS indicador,
                    a.id AS idactivity,
                    a.nombre AS actividad,
                    COUNT(n.id) AS contador,
                    ROW_NUMBER() OVER (PARTITION BY i.id ORDER BY a.id DESC) AS rn
                FROM notas AS n
                JOIN actividades AS a ON a.id = n.activity_id
                JOIN indicadores AS i ON i.id = a.indicator_id
                WHERE i.subject_id = :subjectId
                GROUP BY i.id, a.nombre, a.id, i.nombre
            )

            SELECT
                idindicator,
                indicador,
                idactivity,
                actividad,
                contador,
                CASE
                    WHEN rn = 1 THEN 1
                    ELSE 0
                END AS estado
            FROM ranked_data
            ORDER BY idindicator, actividad ASC;
            ';

        $actividad_notas = DB::select($queryNotas, ['subjectId' => $idsubject]);


        $query = '
            WITH NotasPorTipo AS (
                SELECT
                    e.id AS idstudent,
                    CONCAT(u.nroidenti) AS identificacion,
                    CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante,
                    i.id AS indicador_id,
                    ac.id AS actividad_id,
                    i.nombre AS indicador,
                    ac.nombre AS actividad,
                    n.nombre AS nota,
                    n.porcentaje AS porcentaje,
                    n.id AS nota_id,
                    n.nombre AS nombre_nota,
                    COALESCE(ROUND(ne.nota, 1), 0) AS nota_estudiante
                FROM estudiantes AS e
                INNER JOIN usuarios AS u ON u.id = e.user_id
                INNER JOIN matriculas_asignaturas AS ma ON e.id = ma.student_id
                INNER JOIN asignaturas AS a ON ma.subject_id = a.id
                INNER JOIN indicadores AS i ON a.id = i.subject_id
                INNER JOIN actividades AS ac ON i.id = ac.indicator_id
                INNER JOIN notas AS n ON ac.id = n.activity_id
                LEFT JOIN notas_estudiantes AS ne ON ne.grade_id = n.id AND ne.subjectenrollment_id = ma.id
                WHERE a.id = :subjectId
                GROUP BY e.id, u.nroidenti, u.apellido_pa, u.apellido_ma, u.nombres, i.id, ac.id, n.id, i.nombre, ac.nombre, n.nombre, n.porcentaje, ne.nota
            ),
            
            PromedioPorActividad AS (
                SELECT
                    idstudent,
                    identificacion,
                    estudiante,
                    indicador_id,
                    indicador,
                    actividad_id,
                    actividad,
                    ROUND(SUM(nota_estudiante * porcentaje) / SUM(porcentaje), 2) AS prom_actividad
                FROM NotasPorTipo
                GROUP BY idstudent, identificacion, estudiante, indicador_id, indicador, actividad_id, actividad
            ),

            PromedioPorIndicador AS (
                SELECT
                    idstudent,
                    identificacion,
                    estudiante,
                    indicador_id,
                    indicador,
                    ROUND(SUM(prom_actividad) / COUNT(actividad_id), 2) AS prom_indicador
                FROM PromedioPorActividad
                GROUP BY idstudent, identificacion, estudiante, indicador_id, indicador
            ),

            PromedioFinal AS (
                SELECT
                    idstudent,
                    identificacion,
                    estudiante,
                    ROUND(SUM(prom_indicador) / COUNT(indicador_id), 2) AS prom_final
                FROM PromedioPorIndicador
                GROUP BY idstudent, identificacion, estudiante
            ),

            RankedData AS (
                SELECT
                    npt.idstudent,
                    npt.identificacion,
                    npt.estudiante,
                    npt.indicador_id AS idindicador,
                    npt.indicador,
                    npt.actividad_id AS idactividad,
                    npt.actividad,
                    npt.nota,
                    npt.porcentaje,
                    npt.nota_id,
                    npt.nombre_nota,
                    npt.nota_estudiante,
                    ROUND(ppa.prom_actividad, 2) AS prom_actividad,
                    ROUND(ppi.prom_indicador, 2) AS prom_indicador,
                    ROUND(pf.prom_final, 2) AS prom_final,
                    ROW_NUMBER() OVER (PARTITION BY npt.idstudent, npt.actividad_id ORDER BY npt.nota_id DESC) AS rn_actividad,
                    ROW_NUMBER() OVER (PARTITION BY npt.idstudent, npt.indicador_id ORDER BY npt.actividad_id DESC, npt.nota_id DESC) AS rn_indicador,
                    ROW_NUMBER() OVER (PARTITION BY npt.idstudent ORDER BY npt.indicador DESC , npt.actividad_id DESC, npt.nota_id DESC) AS rn_final
                FROM NotasPorTipo AS npt
                JOIN PromedioPorActividad AS ppa
                    ON npt.idstudent = ppa.idstudent
                    AND npt.indicador_id = ppa.indicador_id
                    AND npt.actividad_id = ppa.actividad_id
                JOIN PromedioPorIndicador AS ppi
                    ON npt.idstudent = ppi.idstudent
                    AND npt.indicador_id = ppi.indicador_id
                JOIN PromedioFinal AS pf
                    ON npt.idstudent = pf.idstudent
                ORDER BY npt.estudiante, npt.indicador, npt.actividad, npt.nota_id
            )

            SELECT
                idstudent,
                identificacion,
                estudiante,
                idindicador,
                indicador,
                idactividad,
                actividad,
                nota,
                porcentaje,
                nombre_nota,
                ROUND(nota_estudiante, 1) AS nota_estudiante,
                ROUND(prom_actividad, 1) AS prom_actividad,
                ROUND(prom_indicador, 1) AS prom_indicador,
                ROUND(prom_final + 0.001, 0) AS prom_final,
                CASE
                    WHEN rn_actividad = 1 THEN 1
                    ELSE 0
                END AS estado_actividad,
                CASE
                    WHEN rn_indicador = 1 THEN 1
                    ELSE 0
                END AS estado_indicador,
                CASE
                    WHEN rn_final = 1 THEN 1
                    ELSE 0
                END AS estado_promfinal
            FROM RankedData
                ';
        
        $estudiantes = DB::select($query, ['subjectId' => $idsubject]);
        
        $currentUrl = URL::current();
        $link = $currentUrl;
        $qrCode = (new QrGeneratorService())->get_qr_by_link($link);

        $pdf = PDF::loadView('reportes.acta_auxiliar_notas', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'estudiantes' => $estudiantes,
            'actividad_notas' => $actividad_notas,
            'notas' => $notas,
            'qrCode' => $qrCode
        ]);
        
        $pdf->setPaper('a4', 'landscape');
        
        return $pdf->stream();
    }


    public function promedio_asignaturas($idstudent, $idsemester)
    {
        $infos = DB::table('estudiantes AS e')
            ->select(
                'pr.codprograma AS codprograma',
                'pr.nombre AS programa',
                'pr.nivel_formativo AS nivel_formativo',
                'pl.nombre AS plan',
                'pl.tipo AS tipoplan',
                'pl.modalidad AS modalidad',
                'pl.enfoque AS enfoque',
                DB::raw('CONCAT(se.anho, "-", se.numero) AS semestre'),
                'se.tipo AS tiposemestre',
                'e.id AS idstudent',
                DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante')
            )
            ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones AS ti', 'ti.id', '=', 'u.identificationtype_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->join('matriculas_semestres AS ms', 'ms.student_id', '=', 'e.id')
            ->join('semestres AS se', 'se.id', '=', 'ms.semester_id')
            ->where('e.id', '=', $idstudent)
            ->where('se.id', '=', $idsemester)
            ->get();

        // Subconsulta para ver cada nota
        $gradesQuery = DB::table('matriculas_asignaturas AS ma')
        ->selectRaw('pl.nombre AS plan,
            c.codcurso AS codcurso,
            c.nombre AS curso,
            CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
            pe.numero AS periodo,
            a.tipo AS condicion,
            a.seccion AS seccion,
            a.turno AS turno,
            i.id AS idindicator,
            ac.id AS idactivity,
            n.id AS idgrade,
            ne.id AS idstudentgrade,
            n.nombre AS tipo_nota,
            n.porcentaje AS porcentaje,
            COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota')
        ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
        ->join('cursos AS c', 'c.id', '=', 'a.course_id')
        ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
        ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
        ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
        ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
        ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
        ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
        ->leftJoin('notas_estudiantes AS ne', function ($join) {
            $join->on('ne.grade_id', '=', 'n.id')
                ->on('ne.subjectenrollment_id', '=', 'ma.id');
        })
        ->where('ma.student_id', '=', $idstudent)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity', 'idgrade', 'idstudentgrade', 'tipo_nota', 'porcentaje');

        // Subconsulta para promedios por actividad
        $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_2'))
        ->mergeBindings($gradesQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity')
        ->selectRaw('plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            idindicator,
            idactivity,
            COALESCE(ROUND(SUM(nota * porcentaje), 1), 0) AS promedio_actividades');

        // Subconsulta para promedios por indicador
        $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_3'))
        ->mergeBindings($activityQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator')
        ->selectRaw('plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            idindicator,
            COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 1), 0) AS promedio_indicadores');

        // Consulta final
        $asignaturas = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_4'))
        ->mergeBindings($indicatorQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno')
        ->selectRaw('plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final')
        ->get();

        $pdf = PDF::loadView('reportes.promedios_asignaturas', [
            // 'institutions' => $this->institutions,
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'asignaturas' => $asignaturas
        ]);
        return $pdf->stream();
    }


    public function promedio_asignaturas2($idsemester)
    {
        $idstudent = Auth::User()->students[0]->id;
        
        $infos = DB::table('estudiantes AS e')
            ->select(
                'pr.codprograma AS codprograma',
                'pr.nombre AS programa',
                'pr.nivel_formativo AS nivel_formativo',
                'pl.nombre AS plan',
                'pl.tipo AS tipoplan',
                'pl.modalidad AS modalidad',
                'pl.enfoque AS enfoque',
                DB::raw('CONCAT(se.anho, "-", se.numero) AS semestre'),
                'se.tipo AS tiposemestre',
                'e.id AS idstudent',
                DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante')
            )
            ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones AS ti', 'ti.id', '=', 'u.identificationtype_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->join('matriculas_semestres AS ms', 'ms.student_id', '=', 'e.id')
            ->join('semestres AS se', 'se.id', '=', 'ms.semester_id')
            ->where('e.id', '=', $idstudent)
            ->where('se.id', '=', $idsemester)
            ->get();
            
        // Subconsulta para ver cada nota
        $gradesQuery = DB::table('matriculas_asignaturas AS ma')
        ->selectRaw('pl.nombre AS plan,
            c.codcurso AS codcurso,
            c.nombre AS curso,
            CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
            pe.numero AS periodo,
            a.tipo AS condicion,
            a.seccion AS seccion,
            a.turno AS turno,
            i.id AS idindicator,
            ac.id AS idactivity,
            n.id AS idgrade,
            ne.id AS idstudentgrade,
            n.nombre AS tipo_nota,
            n.porcentaje AS porcentaje,
            COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota')
        ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
        ->join('cursos AS c', 'c.id', '=', 'a.course_id')
        ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
        ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
        ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
        ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
        ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
        ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
        ->leftJoin('notas_estudiantes AS ne', function ($join) {
            $join->on('ne.grade_id', '=', 'n.id')
                ->on('ne.subjectenrollment_id', '=', 'ma.id');
        })
        ->where('ma.student_id', '=', $idstudent)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion',
        'seccion', 'turno', 'idindicator', 'idactivity', 'idgrade',
        'idstudentgrade', 'tipo_nota', 'porcentaje');

        // Subconsulta para promedios por actividad
        $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_2'))
            ->mergeBindings($gradesQuery)
            ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity')
            ->selectRaw('plan,
                codcurso,
                curso,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                idindicator,
                idactivity,
                COALESCE(ROUND(SUM(nota * porcentaje), 1), 0) AS promedio_actividades');

        // Subconsulta para promedios por indicador
        $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_3'))
        ->mergeBindings($activityQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator')
        ->selectRaw('plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            idindicator,
            COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 1), 0) AS promedio_indicadores');

        // Consulta final
        $asignaturas = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_4'))
        ->mergeBindings($indicatorQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno')
        ->selectRaw('plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final')
        ->get();

        $pdf = PDF::loadView('reportes.promedios_asignaturas', [
            // 'institutions' => $this->institutions,
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos,
            'asignaturas' => $asignaturas
        ]);
        return $pdf->stream();
    }

    public function list_egresados($idplan)
    {
        $estudiantes = Student::join('usuarios as us', 'us.id', '=', 'estudiantes.user_id')
            ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
            ->select(
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                DB::raw('CONCAT(it.tipo, " - ", us.nroidenti) AS identificacion'),
                DB::raw('CONCAT(us.apellido_pa, " ", us.apellido_ma, " ", us.nombres) AS estudiante'),
                'us.correo',
                'us.celular',
                'estudiantes.anho_ingreso'
            )
            ->where('estudiantes.plan_id', $idplan)
            ->where('estudiantes.estado', 5)
            ->get();

        $infos = Plan::join('programas', 'planes.program_id', '=', 'programas.id')
            ->select(
                'planes.nombre as plan',
                'planes.tipo',
                'planes.modalidad',
                'planes.enfoque',
                'programas.codprograma',
                'programas.nombre as programa',
                'programas.nivel_formativo'
            )
            ->where('planes.id', $idplan)
            ->get();


        $pdf = PDF::loadView('reportes.reporte_egresados', [
            'institutions' => AppServiceProvider::$institutions,
            'estudiantes' => $estudiantes,
            'infos' => $infos
        ]);
        return $pdf->stream();
    }

    public function boleta_pago($idpago)
    {
        
        DB::statement("SET lc_time_names = 'es_ES'");

        $infos = DB::table('pagos as pa')
        ->select(
            'pa.id as idpago',
            'pa.fecha',
            DB::raw('DATE_FORMAT(pa.fecha, "%W, %d de %M del %Y") as fecha2'),
            'pa.documento',
            'pa.nro_operacion',
            'pa.monto_inicial',
            'pa.descuento',
            'pa.monto_final',
            'pa.estado',
            'es.id as idest',
            'uses.id as idusuario_est',
            'tiid_est.tipo as tipoidenti_est',
            'uses.nroidenti as nroidenti_est',
            'uses.nombres as nombres_est',
            'uses.apellido_pa as apellido_pa_est',
            'uses.apellido_ma as apellido_ma_est',
            DB::raw('CONCAT(uses.apellido_pa, " ", uses.apellido_ma, ", ", uses.nombres) as estudiante'),
            'uses.telefono as telefono_est',
            'uses.celular as celular_est',
            'uses.correo as correo_est',
            'pr.nombre as programa',
            'ad.id as idadmin',
            'usad.id as idusuario_adm',
            DB::raw('CONCAT(tiid_est.tipo, " - ", uses.nroidenti) AS identificacion'),
            'tiid_adm.tipo as tipoidenti_adm',
            'usad.nroidenti as nroidenti_adm',
            'usad.nombres as nombres_adm',
            'usad.apellido_pa as apellido_pa_adm',
            'usad.apellido_ma as apellido_ma_adm',
            'usad.telefono as telefono_adm',
            'usad.celular as celular_adm',
            'usad.correo as correo_adm',
            'co.id as idconcepto',
            'co.nombre as nombreconcepto',
            'mepa.id as idmetodopago',
            'mepa.nombre as nombremetodopago',
            'ba.id as idbanco',
            'ba.nombre as nombrebanco'
        )
        ->join('estudiantes as es', 'pa.student_id', '=', 'es.id')
        ->join('planes as pl', 'pl.id', '=', 'es.plan_id')
        ->join('programas as pr', 'pr.id', '=', 'pl.program_id')
        ->join('usuarios as uses', 'es.user_id', '=', 'uses.id')
        ->join('tipos_identificaciones as tiid_est', 'uses.identificationtype_id', '=', 'tiid_est.id')
        ->join('administradores as ad', 'pa.administrator_id', '=', 'ad.id')
        ->join('usuarios as usad', 'ad.user_id', '=', 'usad.id')
        ->join('tipos_identificaciones as tiid_adm', 'usad.identificationtype_id', '=', 'tiid_adm.id')
        ->join('conceptos as co', 'pa.concepto_id', '=', 'co.id')
        ->leftJoin('metodos_pagos as mepa', 'pa.metodo_pago_id', '=', 'mepa.id')
        ->leftJoin('bancos as ba', 'pa.banco_id', '=', 'ba.id')
        ->where('pa.id','=',$idpago)
        ->get();


        $pdf = PDF::loadView('reportes.boleta_pago', [
            'institutions' => AppServiceProvider::$institutions,
            'infos' => $infos
        ]);

        // Define el tamaño del papel como boleta (ancho: 8 cm, alto: 21 cm)
        $pdf->setPaper([0, 0, 226.77, 566.93], 'portrait');

        return $pdf->stream();
    }

    public function list_certificado_general($idstudent)
    {
        DB::statement("SET lc_time_names = 'es_ES'");

        // Subconsulta gradesQuery
        $gradesQuery = DB::table('estudiantes AS es')
            ->join('matriculas_semestres AS ms', 'ms.student_id', '=', 'es.id')
            ->join('matriculas_asignaturas AS ma', 'ma.student_id', '=', 'ms.student_id')
            ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
            ->join('cursos AS c', 'c.id', '=', 'a.course_id')
            ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
            ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
            ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
            ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
            ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
            ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
            ->leftJoin('notas_estudiantes AS ne', function ($join) {
                $join->on('ne.grade_id', '=', 'n.id')
                    ->on('ne.subjectenrollment_id', '=', 'ma.id');
            })
            ->selectRaw('
                pl.nombre AS plan,
                c.codcurso AS codcurso,
                c.nombre AS curso,
                CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
                pe.numero AS periodo,
                a.tipo AS condicion,
                a.seccion AS seccion,
                a.turno AS turno,
                CONCAT(se.anho, " - ", se.numero) AS semestre,
                i.id AS idindicator,
                ac.id AS idactivity,
                n.id AS idgrade,
                ne.id AS idstudentgrade,
                n.nombre AS tipo_nota,
                n.porcentaje AS porcentaje,
                COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota
            ')
            ->where('ma.student_id', '=', $idstudent)
            ->groupBy([
                'plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre',
                'idindicator', 'idactivity', 'idgrade', 'idstudentgrade', 'tipo_nota', 'porcentaje'
            ])
        ->orderBy('curso');

        // Subconsulta activityQuery
        $activityQuery = DB::table(DB::raw("({$gradesQuery->toSql()}) AS gradesQuery"))
            ->mergeBindings($gradesQuery)
            ->selectRaw('
                plan,
                codcurso,
                curso,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                semestre,
                idindicator,
                idactivity,
                COALESCE(ROUND(SUM(nota * porcentaje), 1), 0) AS promedio_actividades
            ')
        ->groupBy(['plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre', 'idindicator', 'idactivity']);

        // Subconsulta indicatorQuery
        $indicatorQuery = DB::table(DB::raw("({$activityQuery->toSql()}) AS activityQuery"))
            ->mergeBindings($activityQuery)
            ->selectRaw('
                plan,
                codcurso,
                curso,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                semestre,
                idindicator,
                COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 1), 0) AS promedio_indicadores
            ')
        ->groupBy(['plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre', 'idindicator']);

        // Subconsulta finalGrades
        $finalGrades = DB::table(DB::raw("({$indicatorQuery->toSql()}) AS indicatorQuery"))
            ->mergeBindings($indicatorQuery)
            ->selectRaw('
                plan,
                codcurso,
                curso,
                creditos_horas,
                periodo,
                condicion,
                seccion,
                turno,
                semestre,
                COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final
            ')
        ->groupBy([ 'plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre']);

        // Consulta final
        $cursos = DB::table('planes AS pl')
            ->join('estudiantes AS es', 'es.plan_id', '=', 'pl.id')
            ->join('periodos AS pe', 'pe.plan_id', '=', 'pl.id')
            ->join('cursos AS c', 'c.period_id', '=', 'pe.id')
            ->join('modulos_formativos AS mf', 'mf.id', '=', 'c.training_module_id')
            ->leftJoinSub($finalGrades, 'fg', function ($join) {
                $join->on('fg.codcurso', '=', 'c.codcurso')
                    ->on('fg.plan', '=', 'pl.nombre');
            })
            ->selectRaw('
                pl.nombre AS plan,
                mf.numero AS modulo,
                pe.numero AS periodo,
                c.codcurso AS codcurso,
                c.nombre AS nombre_curso,
                c.creditos AS creditos,
                c.horas AS horas,
                fg.seccion AS seccion,
                fg.turno AS turno,
                COALESCE (fg.semestre, "--") AS semestre,
                COALESCE(fg.promedio_final, "--") AS nota_numero,
                CASE 
                    WHEN fg.promedio_final = 0 THEN "cero"
                    WHEN fg.promedio_final = 1 THEN "uno"
                    WHEN fg.promedio_final = 2 THEN "dos"
                    WHEN fg.promedio_final = 3 THEN "tres"
                    WHEN fg.promedio_final = 4 THEN "cuatro"
                    WHEN fg.promedio_final = 5 THEN "cinco"
                    WHEN fg.promedio_final = 6 THEN "seis"
                    WHEN fg.promedio_final = 7 THEN "siete"
                    WHEN fg.promedio_final = 8 THEN "ocho"
                    WHEN fg.promedio_final = 9 THEN "nueve"
                    WHEN fg.promedio_final = 10 THEN "diez"
                    WHEN fg.promedio_final = 11 THEN "once"
                    WHEN fg.promedio_final = 12 THEN "doce"
                    WHEN fg.promedio_final = 13 THEN "trece"
                    WHEN fg.promedio_final = 14 THEN "catorce"
                    WHEN fg.promedio_final = 15 THEN "quince"
                    WHEN fg.promedio_final = 16 THEN "dieciséis"
                    WHEN fg.promedio_final = 17 THEN "diecisiete"
                    WHEN fg.promedio_final = 18 THEN "dieciocho"
                    WHEN fg.promedio_final = 19 THEN "diecinueve"
                    WHEN fg.promedio_final = 20 THEN "veinte"
                    ELSE "--"
                END AS nota_letras,
                CASE 
                    WHEN fg.promedio_final >= 13 THEN "Aprobado"
                    WHEN fg.promedio_final < 13 AND fg.promedio_final > 0 THEN "Desaprobado"
                    WHEN fg.promedio_final = 0 AND fg.plan IS NOT NULL THEN "Por evaluar"
                    ELSE "--"
                END AS estado
            ')
            ->orderBy('semestre')
            ->orderBy('periodo')
            ->orderBy('curso')
            ->where('es.id', '=', $idstudent)
        ->get();

        $estudiantes = DB::table('estudiantes AS e')
            ->select(
                'e.id AS idstudent',
                'pl.nombre AS plan',
                'pr.nombre AS programa',
                DB::raw('DATE_FORMAT(NOW(), "%e de %M del %Y") as fecha_actual'),
                DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                DB::raw('CONCAT(u.nombres, " ", u.apellido_pa, " ", u.apellido_ma) AS estudiante')
            )
            ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones AS ti', 'ti.id', '=', 'u.identificationtype_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->where('e.id', '=', $idstudent)
            ->groupBy('idstudent', 'estudiante', 'identificacion', 'plan', 'programa')
        ->first();

        $pdf = PDF::loadView('reportes.certificado_estudios', [
            'institutions' => AppServiceProvider::$institutions,
            'estudiantes' => $estudiantes,
            'cursos' => $cursos,
        ]);

        $pdf->setPaper('A4', 'portrait');
        return $pdf->stream();
    }

    public function list_certificado_modular($idstudent, $idmodulo)
    {
        $modulo = DB::table('modulos_formativos as mf')
            ->select(
                'mf.id as idmodulo',
                'mf.numero as numero',
                'mf.codigo as codigo',
                'mf.descripcion as descripcion',
                DB::raw('SUM(c.creditos) as total_creditos'),
                DB::raw('SUM(c.horas) as total_horas')
            )
            ->join('cursos as c', 'c.training_module_id', '=', 'mf.id')
            ->where('mf.id', 1)
            ->groupBy('mf.id', 'mf.numero', 'mf.codigo', 'mf.descripcion')
        ->first();

        $estudiantes = DB::table('estudiantes AS e')
            ->select(
                'e.id AS idstudent',
                'pl.nombre AS plan',
                'pr.nombre AS programa',
                DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                DB::raw('CONCAT(u.nombres, " ", u.apellido_pa, " ", u.apellido_ma) AS estudiante')
            )
            ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones AS ti', 'ti.id', '=', 'u.identificationtype_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->where('e.id', '=', $idstudent)
            ->groupBy('idstudent', 'estudiante', 'identificacion', 'plan', 'programa')
        ->first();

        $pdf = PDF::loadView('reportes.certificado_modular', [
            'institutions' => AppServiceProvider::$institutions,
            'estudiantes' => $estudiantes,
            'modulo' => $modulo
        ]);

        $pdf->setPaper('A4', 'landscape');
        return $pdf->stream();
    }
}
