<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Studentgrade;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Collection;
use Yajra\DataTables\Facades\DataTables;

class NotaController extends Controller
{


    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.notas.gestionar_notas.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index2(Request $request)
    {
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.notas.promedios.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list_cursos(Request $request)
    {
        if ($request->ajax()) {

            $user = Auth::user();
            $teacherdata = $user->teachers;
            $idteacher = $teacherdata[0]->id;

            $data = DB::table('asignaturas')
            ->select(
                'asignaturas.id AS idsubject',
                'asignaturas.teacher_id AS idteacher',
                'programas.nombre AS programa',
                'planes.nombre AS plan',
                'periodos.numero AS periodo',
                'cursos.codcurso',
                'cursos.nombre AS curso',
                'cursos.tipo',
                DB::raw('CONCAT("Crd: ", cursos.creditos, " - Hrs: ", cursos.horas) AS creditos_horas'),
                'asignaturas.tipo AS condicion',
                'asignaturas.seccion',
                'asignaturas.turno'
            )
            ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
            ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
            ->join('planes', 'planes.id', '=', 'periodos.plan_id')
            ->join('programas', 'programas.id', '=', 'planes.program_id')
            ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
            ->where('asignaturas.teacher_id', '=', $idteacher)
            // ->whereRaw('semestres.anho = YEAR(NOW())')
            // ->whereRaw('semestres.anho = 2024')
            ->orderBy('programa')
            ->orderBy('plan')
            ->orderBy('periodo')
            ->orderBy('curso')
            ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_indicadores(Request $request)
    {
        $idsubject = $request->input('idsubject');

        if ($request->ajax()) {

            $data = DB::table('asignaturas as s')
            ->select(
                DB::raw('COALESCE(s.id, 0) as idsubject'),
                DB::raw('COALESCE(i.id, 0) as idindicator'),
                DB::raw('COALESCE(i.nombre, "") as indicador'),
                DB::raw('COALESCE(i.descripcion, "") as indicador_descripcion'),
                DB::raw('COALESCE(a.id, 0) as idactivity'),
                DB::raw('COALESCE(a.nombre, "") as actividad'),
                DB::raw('COALESCE(a.fecha, "") as fecha'),
                DB::raw('COALESCE(g.id, 0) as idgrade'),
                DB::raw('COALESCE(g.nombre, "") as nota'),
                DB::raw('CONCAT(g.nombre, " - ", g.porcentaje*100, "%") AS tipo_nota'),
                DB::raw('COALESCE(g.porcentaje, 0) as porcentaje')
            )
            ->join('indicadores as i', 'i.subject_id', '=', 's.id')
            ->leftJoin('actividades as a', 'a.indicator_id', '=', 'i.id')
            ->leftJoin('notas as g', 'g.activity_id', '=', 'a.id')
            ->where('s.id', '=', $idsubject)
            ->orderBy('indicador')
            ->orderBy('actividad')
            ->orderBy('nota')
            ->get();
            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_estudiantes(Request $request)
    {
        if ($request->ajax()) {

            $idgrade = $request->input('idgrade');
            $idteacher = $request->input('idteacher');

            $data = DB::table('asignaturas AS a')
                ->select(
                    'a.id AS idsubject',
                    'i.id AS idindicator',
                    'ac.id AS idactivity',
                    'n.id AS idgrade',
                    'ma.id AS idsubjectenrollment',
                    'e.id AS idstudent',
                    DB::raw('COALESCE(ne.id, 0) as idstudentgrade'),
                    'c.nombre AS curso',
                    'i.nombre AS indicador',
                    'ac.nombre AS actividad',
                    'n.nombre AS nombre_nota',
                    DB::raw('CONCAT(n.nombre, " - ", n.porcentaje * 100, "%") AS tipo_nota'),
                    'n.porcentaje AS porcentaje',
                    DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                    DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante'),
                    DB::raw('COALESCE(ne.nota, 0) AS nota_estudiante')
                )
                ->join('cursos as c', 'c.id', '=', 'a.course_id')
                ->join('indicadores AS i', 'i.subject_id', '=', 'a.id')
                ->join('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
                ->join('notas AS n', 'n.activity_id', '=', 'ac.id')
                ->join('matriculas_asignaturas AS ma', 'ma.subject_id', '=', 'a.id')
                ->leftJoin('notas_estudiantes AS ne', function ($join) {
                    $join->on('ne.grade_id', '=', 'n.id')
                        ->on('ne.subjectenrollment_id', '=', 'ma.id');
                })
                ->join('estudiantes AS e', 'e.id', '=', 'ma.student_id')
                ->join('usuarios AS u', 'u.id', '=', 'e.user_id')
                ->join('tipos_identificaciones AS ti', 'ti.id', '=', 'u.identificationtype_id')
                ->where('n.id', '=', $idgrade)
                ->where('a.teacher_id', '=', $idteacher)
                ->orderBy('estudiante', 'ASC')
                ->get();


            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // FALTA ARREGLAR
    public function update_nota(Request $request, $idstudentgrade, $idsubjectenrollment)
    {
        $data_studentgrade = DB::table('notas_estudiantes as ne')
            ->join('matriculas_asignaturas as ma', 'ma.id', '=', 'ne.subjectenrollment_id')
            ->join('asignaturas as su', 'su.id', '=', 'ma.subject_id')
            ->join('semestres as se', 'se.id', '=', 'su.semester_id')
            ->select('se.estado')
            ->where('ne.id', $idstudentgrade)
            ->get();

        $data_semester = DB::table('asignaturas AS su')
            ->join('matriculas_asignaturas AS ma', 'ma.subject_id', '=', 'su.id')
            ->join('semestres AS se', 'se.id', '=', 'su.semester_id')
            ->select('se.estado')
            ->where('ma.id', $idsubjectenrollment)
            ->get();

        //  if ($data_studentgrade->isNotEmpty() && $data_semester[0]->estado == 1) {
        if ($data_semester[0]->estado == 1) {

            $item = Studentgrade::find($idstudentgrade);

            if (!$item) {

                $item = new Studentgrade();
                $item->subjectenrollment_id = $request->input('txt-idsubjectenrollment');
                $item->grade_id = $request->input('txt-idgrade');
                $item->asistencia = 0;
                $item->nota = $request->input('txt-nota_estudiante');

                // Guarda el nuevo registro en la base de datos
                if ($item->save()) {
                    // El guardado fue exitoso
                    return response()->json([
                        "status" => true,
                        "mensaje" => 'Grade guardado'
                    ]);
                } else {
                    // El guardado falló
                    return response()->json([
                        "status" => false,
                        "mensaje" => 'Grade no guardado'
                    ]);
                }
            } else {

                $item->nota = $request->input('txt-nota_estudiante');

                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            }
        } else {
            return response()->json(["status" => false, "mensaje" => 'La edicion de notas esta deshabilitada']);
        }
    }



    public function list_promedios(Request $request)
    {
        if ($request->ajax()) {

            $idsubject = $request->input('idsubject');

            // Subconsulta para promedios por nota
            $gradesQuery = DB::table('estudiantes AS e')
                ->selectRaw('
                    a.id AS idsubject,
                    e.id AS idstudent,
                    CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion,
                    CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante,
                    i.id AS idindicator,
                    ac.id AS idactivity,
                    n.id AS idgrade,
                    n.porcentaje AS porcentaje,
                    ne.id AS idstudentgrade,
                    COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota
                ')
                ->join('usuarios AS u', 'e.user_id', '=', 'u.id')
                ->join('tipos_identificaciones AS ti', 'u.identificationtype_id', '=', 'ti.id')
                ->join('matriculas_asignaturas AS ma', 'e.id', '=', 'ma.student_id')
                ->join('asignaturas AS a', 'ma.subject_id', '=', 'a.id')
                ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
                ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
                ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
                ->leftJoin('notas_estudiantes AS ne', function ($join) {
                    $join->on('ne.grade_id', '=', 'n.id')
                        ->on('ne.subjectenrollment_id', '=', 'ma.id');
                })
                ->where('a.id', '=', $idsubject) // Cambiar por el id correspondiente
                ->groupBy(
                    'a.id', 'e.id', 'u.apellido_pa', 'u.apellido_ma', 'u.nombres', 'u.nroidenti',
                    'ti.tipo', 'i.id', 'ac.id', 'n.id', 'n.porcentaje', 'ne.id'
                );

            // Subconsulta para promedios por actividad
            $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_1'))
                ->mergeBindings($gradesQuery)
                ->selectRaw('
                    idsubject,
                    idstudent,
                    identificacion,
                    estudiante,
                    idindicator,
                    idactivity,
                    COALESCE(ROUND(SUM(nota * porcentaje), 2), 0) AS promedio_actividades
                ')
                ->groupBy('idsubject', 'idstudent', 'identificacion', 'estudiante', 'idindicator', 'idactivity');

            // Subconsulta para promedios por indicador
            $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_2'))
                ->mergeBindings($activityQuery)
                ->selectRaw('
                    idsubject,
                    idstudent,
                    identificacion,
                    estudiante,
                    idindicator,
                    COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 2), 0) AS promedio_indicadores
                ')
                ->groupBy('idsubject', 'idstudent', 'identificacion', 'estudiante', 'idindicator');

            // Consulta final
            $finalQuery = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_3'))
                ->mergeBindings($indicatorQuery)
                ->selectRaw('
                    idsubject,
                    idstudent,
                    identificacion,
                    estudiante,
                    COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 0), 0) AS promedio_final
                ')
                ->groupBy('idsubject', 'idstudent', 'identificacion', 'estudiante')
                ->orderBy('estudiante')
                ->get();

            // datatable
            return DataTables::of($finalQuery)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    

    public function list_promedio_estudiante(Request $request)
    {
        if ($request->ajax()) {
            
            $idsubject = $request->input('idsubject');
            $idstudent = $request->input('idstudent');
            
            $query = "
                WITH NotasPorTipo AS (
                    SELECT
                        i.id AS indicador_id,
                        ac.id AS actividad_id,
                        i.nombre AS indicador,
                        ac.nombre AS actividad,
                        n.nombre AS nombre_nota,
                        n.porcentaje AS porcentaje,
                        COALESCE(ROUND(ne.nota, 1), 0) AS nota_estudiante
                    FROM estudiantes AS e
                    INNER JOIN matriculas_asignaturas AS ma ON e.id = ma.student_id
                    INNER JOIN asignaturas AS a ON ma.subject_id = a.id
                    LEFT JOIN indicadores AS i ON a.id = i.subject_id
                    LEFT JOIN actividades AS ac ON i.id = ac.indicator_id
                    LEFT JOIN notas AS n ON ac.id = n.activity_id
                    LEFT JOIN notas_estudiantes AS ne ON ne.grade_id = n.id AND ne.subjectenrollment_id = ma.id
                    WHERE a.id = :subjectId AND e.id = :studentId
                    GROUP BY i.id, ac.id, i.nombre, ac.nombre, n.porcentaje, n.nombre, ne.nota, ne.id
                    ORDER BY i.nombre, ac.nombre, n.nombre
                ),

                PromedioPorActividad AS (
                    SELECT
                        indicador_id,
                        actividad_id,
                        indicador,
                        actividad,
                        COALESCE(ROUND(SUM(nota_estudiante * porcentaje) / SUM(porcentaje), 2), 0) AS prom_actividad
                    FROM NotasPorTipo
                    GROUP BY indicador_id, actividad_id, indicador, actividad
                    ORDER BY indicador, actividad
                ),

                PromedioPorIndicador AS (
                    SELECT
                        indicador_id,
                        indicador,
                        ROUND(SUM(prom_actividad) / COUNT(actividad_id), 2) AS prom_indicador
                    FROM PromedioPorActividad
                    GROUP BY indicador_id, indicador
                    ORDER BY indicador
                ),

                PromedioFinal AS (
                    SELECT
                        ROUND(SUM(prom_indicador) / COUNT(indicador_id), 2) AS prom_final
                    FROM
                        PromedioPorIndicador
                )

                SELECT
                    COALESCE (npt.indicador, '--') as indicador,
                    COALESCE (npt.actividad, '--') as actividad,
                    COALESCE (npt.porcentaje, '--') as porcentaje,
                    COALESCE (npt.nombre_nota, '--') as nombre_nota,
                    COALESCE (npt.nota_estudiante, 0) as nota_estudiante,
                    COALESCE (ppa.prom_actividad, 0) as prom_actividad,
                    COALESCE (ppi.prom_indicador, 0) as prom_indicador,
                    COALESCE (pf.prom_final, 0) as prom_final
                FROM NotasPorTipo AS npt
                LEFT JOIN PromedioPorActividad AS ppa
                    ON npt.indicador_id = ppa.indicador_id
                    AND npt.actividad_id = ppa.actividad_id
                LEFT JOIN PromedioPorIndicador AS ppi
                    ON npt.indicador_id = ppi.indicador_id
                JOIN PromedioFinal AS pf
                ORDER BY npt.indicador, npt.actividad, npt.porcentaje;
                ";

            $result = DB::select($query, ['subjectId' => $idsubject, 'studentId' => $idstudent]);

            // datatable
            return DataTables::of($result)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar la informaci贸n'
        ]);
    }


}
