<?php

namespace App\Http\Controllers\docente;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use \Illuminate\Support\Facades\Auth;
use App\Models\Attendance;


class DocenteAsistenciaController extends Controller
{

    public function index(Request $request)
    {
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('docente.asistencias.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list_students(Request $request)
    {
        $userId = Auth::User()->id;
        $idsemester = $request->input('idsemester');
        $idsubject = $request->input('idsubject');
        $idsubjectclass = $request->input('idsubjectclass');

        if ($request->ajax()) {

            $data = DB::table('asignaturas as a')
            ->select(
                'ma.id AS idsubjectenrollment',
                'ca.id AS idsubjectclass',
                'a.id AS idsubject',
                DB::raw('CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion'),
                DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante'),
                'c.codcurso',
                'c.nombre AS curso',
                DB::raw('CONCAT(s.anho, "-", s.numero) AS semestre'),
                'ca.nombre AS clase',
                'ca.fecha AS fecha_clase',
                'ca.estado AS estado_clase',
                'asi.id AS idattendance',
                DB::raw('COALESCE(asi.estado, "0") AS estado_asistencia')
            )
            ->join('cursos as c', 'c.id', '=', 'a.course_id')
            ->join('docentes as d', 'd.id', '=', 'a.teacher_id')
            ->join('semestres as s', 's.id', '=', 'a.semester_id')
            ->join('horarios as h', 'h.subject_id', '=', 'a.id')
            ->join('clases_asignaturas as ca', 'ca.schedule_id', '=', 'h.id')
            ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
            ->leftJoin('asistencias as asi', function ($join) {
                $join->on('asi.subjectenrollment_id', '=', 'ma.id')
                    ->on('asi.subjectclass_id', '=', 'ca.id');
            })
            ->join('estudiantes as e', 'e.id', '=', 'ma.student_id')
            ->join('usuarios as u', 'u.id', '=', 'e.user_id')
            ->join('tipos_identificaciones as ti', 'ti.id', '=', 'u.identificationtype_id')
            ->where('d.user_id', '=', $userId)
            ->where('s.id', '=', $idsemester)
            ->where('ca.id', '=', $idsubjectclass)
            ->orderBy('curso')
            ->orderBy('fecha_clase')
            ->get();

            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Attendance();
        $item->tipo = $request->input('txt_tipo_name');
        $item->numero = $request->input('txt_numero_name');
        $item->piso = $request->input('txt_piso_name');
        $item->capacidad = $request->input('txt_capacidad_name');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Attendance::find($id);

        if (!$item) {
            $item = new Attendance();
            $item->subjectclass_id = $request->input('txt-idsubjectclass');
            $item->subjectenrollment_id = $request->input('txt-idsubjectenrollment');
            $item->estado= $request->input('txt-estado_asistencia');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        } else {
            $item->subjectclass_id = $request->input('txt-idsubjectclass');
            $item->subjectenrollment_id = $request->input('txt-idsubjectenrollment');
            $item->estado= $request->input('txt-estado_asistencia');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }
}







