<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use App\Models\Publicacion;

class PublicacionesController extends Controller
{
    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 3;

                $result = DB::table('estudiantes as e')
                    ->join('usuarios as u', 'u.id', '=', 'e.user_id')
                    ->join('planes as pl', 'pl.id', '=', 'e.plan_id')
                    ->join('publicacions as pu', 'pu.plan_id', '=', 'pl.id')
                    ->select([
                        'e.id as idstudent',
                        'u.id as iduser',
                        'u.estado as estado',
                        'pl.id as plaid',
                        'pl.nombre',
                        'pu.id',
                        'pu.titulo',
                        'pu.contenido',
                        'pu.carpeta',
                        'pu.imagen',
                        'pu.created_at'
                    ])
                    ->where('u.estado', 1)
                    ->where('u.id', Auth::User()->id)
                    ->get();

                return view('alumno.bienestar.publicaciones.index')
                ->with('datatipoacceso', $tipoacceso)
                ->with('data', $result );

            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');

            } else if ($userTypeAccesocombo == "2") {

                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar

                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function verImagen($idpublicacion, $carpeta, $imagen)
    {
        // Buscar la publicación por ID
        $item = Publicacion::find($idpublicacion);

        if (!$item || !$item->imagen) {
            abort(404, 'Imagen no encontrada.');
        }

        // Ruta completa del archivo de la imagen
        $file = storage_path('app/publicaciones/').$carpeta.'/'. $imagen;

        if (file_exists($file)) {
            // Determinar el tipo MIME de la imagen
            $mimeType = mime_content_type($file);

            if (strpos($mimeType, 'image/') !== 0) {
                abort(400, 'El archivo no es una imagen válida.');
            }

            // Devolver la imagen como respuesta
            return response()->file($file, [
                'Content-Type' => $mimeType,
            ]);
        } else {
            abort(404, 'Archivo no encontrado.');
        }
    }
}
