<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Course;
use App\Models\Student;
use App\Models\Courseequivalence;
use App\Models\Studentvalidation;
use App\Models\Subject;
use App\Models\Subjectenrollment;
use App\Models\User;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Route;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Http\Response;

class StudentvalidationController extends Controller
{


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.estudiantes.convalidaciones.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        $idplanequivalence = $request->input('idplanequivalence');
        $idstudent = $request->input('idstudent');

        if ($request->ajax()) {
            // query
            $data = DB::table('convalidaciones_estudiantes as stva')
                ->select(
                    'stva.id as idstudentvalidation',
                    'stva.fecha',
                    'coeq.id as idcourseequivalence',
                    'coeq.documento as documentocourseequivalence',
                    'co1.id as idcourse1',
                    'co1.tipo as tipocurso1',
                    'co1.codcurso as codcurso1',
                    'co1.nombre as nombrecurso1',
                    'co1.codpredecesor as codpredecesorcurso1',
                    'co1.horas as horascurso1',
                    'co1.creditos as creditoscurso1',
                    'pe1.id as idperiod1',
                    'pe1.numero as numeroperiodo1',
                    'co2.id as idcourse2',
                    'co2.tipo as tipocurso2',
                    'co2.codcurso as codcurso2',
                    'co2.nombre as nombrecurso2',
                    'co2.codpredecesor as codpredecesorcurso2',
                    'co2.horas as horascurso2',
                    'co2.creditos as creditoscurso2',
                    'pe2.id as idperiod2',
                    'pe2.numero as numeroperiodo2'
                )
                ->join('equivalencias_cursos as coeq', 'stva.courseequivalence_id', '=', 'coeq.id')
                ->join('cursos as co1', 'coeq.course_id1', '=', 'co1.id')
                ->join('periodos as pe1', 'co1.period_id', '=', 'pe1.id')
                ->join('cursos as co2', 'coeq.course_id2', '=', 'co2.id')
                ->join('periodos as pe2', 'co2.period_id', '=', 'pe2.id')
                ->join('equivalencias_planes as pleq', 'coeq.planequivalence_id', '=', 'pleq.id')
                ->join('estudiantes as st', 'stva.student_id', '=', 'st.id')
                ->where('pleq.id', $idplanequivalence)
                ->where('st.id', $idstudent)
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'No se pueden cargar los datos']);
    }


    public function store(Request $request)
    {
        // validar si el alumno ha aprobado el curso
        $idcourseequivalence = $request->input('idcourseequivalence');
        $idstudent = $request->input('idstudent');

        $equi_curso = Courseequivalence::find($idcourseequivalence);
        $idcurso1 = $equi_curso->course_id1;
        $asignaturas = Subject::where('course_id', $idcurso1)->get();
        // Validar si existen registros en matriculas_asignaturas

        $validacion = Subjectenrollment::whereIn('asignatura_id', $asignaturas->pluck('id'))
            ->where('estado', 1) // Aca se edita el estado para aprobar
            ->where('student_id', $idstudent)
            ->exists();

        if (!$validacion) {
            return response()->json(["status" => false, "mensaje" => 'El alumno no ha aprobado el curso previamente']);
        }





        // validar si existe
        $item = new Studentvalidation();
        $item->courseequivalence_id = $idcourseequivalence;
        $item->student_id = $idstudent;
        $item->fecha = $request->input('fecha');
        $item->documento = '--';
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }

    public function destroy($idstudentvalidation)
    {
        // Busca el registro por su id
        $item = Studentvalidation::find($idstudentvalidation);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
