<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\Student;
use App\Models\Socioeconomicsheet;
use App\Models\Subject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class StudentSituacionController extends Controller
{
    //


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.bolsa_laboral.situacion_estudiante.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes as job')
            ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
            ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
            ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
            ->select(
                'job.id as idjob', 'job.puesto', 'job.vacantes', 'job.modalidad', 'job.experiencia', 'job.fecpublicacion',
                'job.feccierre', 'job.salariomin', 'job.salariomax', 'job.nivel_educativo', 'job.descripcion', 'job.estado',
                'com.id as idcompany', 'com.nombre as nombrecompany',
                'cat.id as idcategory', 'cat.nombre as nombrecategory',
                'ubi.id as idubigeo',
                DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'), 'ubi.departamento',
                DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'), 'ubi.provincia',
                DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'), 'ubi.distrito'
            )
            ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }


    public function list_estudiantes(Request $request)
    {
        $idplan = $request->input('idplan');

        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes')
            ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
            ->join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
            ->join('planes', 'planes.id', '=', 'estudiantes.plan_id')
            ->join('programas', 'programas.id', '=', 'planes.program_id')
            ->select(
                DB::raw('ROW_NUMBER() OVER (ORDER BY usuarios.apellido_pa) AS n'),
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                'usuarios.nroidenti',
                DB::raw("CONCAT(usuarios.apellido_pa, ' ', usuarios.apellido_ma, ', ', usuarios.nombres) AS estudiante"),
                'estudiantes.id as idstudent',
                'estudiantes.anho_ingreso',
                'estudiantes.estado',
                DB::raw("CONCAT('Plan ', planes.nombre, ' (', planes.tipo, ')') AS plan"),
                'programas.nombre AS programa'
            )
            ->where('planes.id', '=', $idplan) // Aca iria el id del plan
            ->whereNotIn('estudiantes.estado', [5, 6])
            ->orderBy('estado')
            ->orderBy('anho_ingreso')
            ->orderBy('estudiante')
            ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }

    public function update_estudiante(Request $request, $id)
    {
        $item = Student::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->estado = "5";

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Éxito: registros actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error: registros no pudo ser actualizado'
                ]);
            }
        }
    }

    public function list_egresados(Request $request)
    {
        $idplan = $request->input('idplan');

        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes')
            ->join('usuarios', 'usuarios.id', '=', 'estudiantes.user_id')
            ->join('tipos_identificaciones AS it', 'it.id', '=', 'usuarios.identificationtype_id')
            ->join('planes', 'planes.id', '=', 'estudiantes.plan_id')
            ->join('programas', 'programas.id', '=', 'planes.program_id')
            ->select(
                DB::raw('ROW_NUMBER() OVER (ORDER BY usuarios.apellido_pa) AS n'),
                'it.id AS ididentificationtype',
                'it.tipo AS tipoidenti',
                'usuarios.nroidenti',
                DB::raw("CONCAT(usuarios.apellido_pa, ' ', usuarios.apellido_ma, ', ', usuarios.nombres) AS estudiante"),
                'estudiantes.id AS idstudent',
                'estudiantes.anho_ingreso',
                'estudiantes.estado',
                DB::raw("CONCAT('Plan ', planes.nombre, ' (', planes.tipo, ')') AS plan"),
                'programas.nombre AS programa'
            )
            ->where('planes.id', '=', $idplan)
            ->whereIn('estudiantes.estado', [5, 6])
            ->orderBy('estado')
            ->orderBy('anho_ingreso')
            ->orderBy('estudiante')
            ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }

    public function update_egresado(Request $request, $id)
    {
        $item = Student::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->estado = "6";

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Éxito: registros actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error: registros no pudo ser actualizado'
                ]);
            }
        }
    }

    public function store_egresado(Request $request)
    {

        $item = new Socioeconomicsheet();
        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado_civil = $request->input('txt_estadocivil');
            $item->nro_hijos = $request->input('txt_nrohijos');
            $item->ingreso_mensual = $request->input('txt_ingresomensual');
            $item->ocupacion = $request->input('txt_ocupacion');
            $item->empresa = $request->input('txt_emopresas');
            $item->tipovivienda = $request->input('txt_tipovivienda');
            $item->gastos_mensuales = $request->input('txt_gastosmensuales');
            $item->student_id = $request->input('txt_idstudent');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }

    public function list_record_academico(Request $request)
    {
        $idStudent = $request->input('idStudent');

        if ($request->ajax()) {

            // Subconsulta gradesQuery
            $gradesQuery = DB::table('estudiantes AS es')
                ->join('matriculas_semestres AS ms', 'ms.student_id', '=', 'es.id')
                ->join('matriculas_asignaturas AS ma', 'ma.student_id', '=', 'ms.student_id')
                ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
                ->join('cursos AS c', 'c.id', '=', 'a.course_id')
                ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
                ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
                ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
                ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
                ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
                ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
                ->leftJoin('notas_estudiantes AS ne', function ($join) {
                    $join->on('ne.grade_id', '=', 'n.id')
                        ->on('ne.subjectenrollment_id', '=', 'ma.id');
                })
                ->selectRaw('
                    es.id AS idstudent,
                    pl.nombre AS plan,
                    c.codcurso AS codcurso,
                    c.nombre AS curso,
                    CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
                    pe.numero AS periodo,
                    a.tipo AS condicion,
                    a.seccion AS seccion,
                    a.turno AS turno,
                    CONCAT(se.anho, " - ", se.numero) AS semestre,
                    i.id AS idindicator,
                    ac.id AS idactivity,
                    n.id AS idgrade,
                    ne.id AS idstudentgrade,
                    n.nombre AS tipo_nota,
                    n.porcentaje AS porcentaje,
                    COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota
                ')
                ->where('ma.student_id', '=', $idStudent)
                ->groupBy([
                    'plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre',
                    'idindicator', 'idactivity', 'idgrade', 'idstudentgrade', 'tipo_nota', 'porcentaje', 'idstudent'
                ])
            ->orderBy('curso');

            // Subconsulta activityQuery
            $activityQuery = DB::table(DB::raw("({$gradesQuery->toSql()}) AS gradesQuery"))
                ->mergeBindings($gradesQuery)
                ->selectRaw('
                    plan,
                    codcurso,
                    curso,
                    creditos_horas,
                    periodo,
                    condicion,
                    seccion,
                    turno,
                    semestre,
                    idindicator,
                    idactivity,
                    COALESCE(ROUND(SUM(nota * porcentaje), 1), 0) AS promedio_actividades
                ')
            ->groupBy(['plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre', 'idindicator', 'idactivity']);

            // Subconsulta indicatorQuery
            $indicatorQuery = DB::table(DB::raw("({$activityQuery->toSql()}) AS activityQuery"))
                ->mergeBindings($activityQuery)
                ->selectRaw('
                    plan,
                    codcurso,
                    curso,
                    creditos_horas,
                    periodo,
                    condicion,
                    seccion,
                    turno,
                    semestre,
                    idindicator,
                    COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 1), 0) AS promedio_indicadores
                ')
            ->groupBy(['plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre', 'idindicator']);

            // Subconsulta finalGrades
            $finalGrades = DB::table(DB::raw("({$indicatorQuery->toSql()}) AS indicatorQuery"))
                ->mergeBindings($indicatorQuery)
                ->selectRaw('
                    plan,
                    codcurso,
                    curso,
                    creditos_horas,
                    periodo,
                    condicion,
                    seccion,
                    turno,
                    semestre,
                    COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final
                ')
            ->groupBy([ 'plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'semestre']);

            // Consulta final
            $result = DB::table('planes AS pl')
                ->join('estudiantes AS es', 'es.plan_id', '=', 'pl.id')
                ->join('periodos AS pe', 'pe.plan_id', '=', 'pl.id')
                ->join('cursos AS c', 'c.period_id', '=', 'pe.id')
                ->join('modulos_formativos AS mf', 'mf.id', '=', 'c.training_module_id')
                ->leftJoinSub($finalGrades, 'fg', function ($join) {
                    $join->on('fg.codcurso', '=', 'c.codcurso')
                        ->on('fg.plan', '=', 'pl.nombre');
                })
                ->selectRaw('
                    es.id AS idstudent,
                    pl.nombre AS plan,
                    mf.id AS idmodulo,
                    mf.numero AS numero_modulo,
                    mf.codigo AS codigo_modulo,
                    mf.descripcion AS descripcion_modulo,
                    pe.numero AS periodo,
                    c.codcurso AS codcurso,
                    c.nombre AS nombre_curso,
                    c.tipo AS tipo_curso,
                    c.creditos AS creditos,
                    c.horas AS horas,
                    fg.seccion AS seccion,
                    fg.turno AS turno,
                    fg.semestre AS semestre,
                    fg.promedio_final AS promedio_final,
                    CASE 
                        WHEN fg.promedio_final >= 13 THEN "Aprobado"
                        WHEN fg.promedio_final < 13 AND fg.promedio_final > 0 THEN "Desaprobado"
                        WHEN fg.promedio_final = 0 AND fg.plan IS NOT NULL THEN "Por evaluar"
                        ELSE "--"
                    END AS estado
                ')
                ->orderBy('numero_modulo')
                ->orderBy('periodo')
                ->orderBy('tipo_curso', 'asc')
                ->orderBy('curso')
                ->where('es.id', '=', $idStudent)
            ->get();
            
            // datatable
            return DataTables::of($result)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }
}
