<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Student;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class StudentController extends Controller
{
    //


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.seguridad.administradores.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = Student::join('roles AS r', 'r.id', '=', 'Students.role_id')
                ->join('usuarios AS u', 'u.id', '=', 'Students.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->join('tipos_usuarios AS ut', 'ut.id', '=', 'u.usertype_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'u.ubigeo_id')
                ->join('generos AS g', 'g.id', '=', 'u.genre_id')
                ->get([
                    'Students.id AS idadministrador',
                    'r.id AS idrole', 
                    'r.nombre AS nombrerole',
                    'u.id AS iduser', 
                    'u.nroidenti', 
                    'u.password', 
                    'u.nombres', 
                    'u.apellido_pa', 
                    'u.apellido_ma', 
                    DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'), 
                    'u.fecnac', 
                    'u.correo', 
                    'u.telefono', 
                    'u.celular', 
                    'u.direccion', 
                    'u.estado',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'ut.id AS idusertype', 'ut.tipo',
                    'ub.id AS idubigeo', 
                    DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'), 
                    'ub.departamento', 
                    DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'), 
                    'ub.provincia', 
                    DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'), 
                    'ub.distrito',
                    'g.id AS idgenre', 
                    'g.nombre AS nombregenre'
                ]);
            
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }



    public function store(Request $request)
    {

        $r_nroidenti = $request->input('txt_nroidenti');

        $usuario = User::where('nroidenti', $r_nroidenti)->first();

        if ($usuario) {
            $alumno = Student::where('user_id', $usuario->id)->first();
        }
        // VALIDAR SI EXISTE UN ALUMNO CON ESE NUMERO DE IDENTIFICACION
        if ($usuario && $alumno) {
            return response()->json(["status" => false, "mensaje" => 'El alumno ya está registrado']);
        }
        // SI NO EXISTE EL ALUMNO CON EL NUMERO DE IDENTIFICACION
        else {

            // SI EL USUARIO EXISTE
            if ($usuario) {

                // setear datos
                if ($usuario->usertype_id == '1') {
                    $new_usertype_id = 5;
                } else if ($usuario->usertype_id == '2') {
                    $new_usertype_id = 6;
                } else if ($usuario->usertype_id == '4') {
                    $new_usertype_id = 7;
                }

                $usuario->usertype_id = $new_usertype_id;
                $usuario->password = $request->input('txt_password');
                $usuario->nombres = $request->input('txt_nombres');
                $usuario->apellido_pa = $request->input('txt_apellido_pa');
                $usuario->apellido_ma = $request->input('txt_apellido_ma');
                $usuario->fecnac = $request->input('txt_fecnac');
                $usuario->correo = $request->input('txt_correo');
                $usuario->telefono = $request->input('txt_telefono');
                $usuario->celular = $request->input('txt_celular');
                $usuario->direccion = $request->input('txt_direccion');
                $usuario->estado = $request->input('txt_estado');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $usuario->ubigeo_id = $idubigeo;
                $usuario->genre_id = $request->input('txt_genre_id');

                // validar guardado
                if ($usuario->save()) {
                    // recoger id insertado
                    $userId = $usuario->id;
                    // nuevo objeto
                    $item2 = new Student();
                    $item2->apoderado = $request->input('txt-apoderado');
                    $item2->anho_ingreso = $request->input('txt_anho_ingreso');
                    $item2->estado = $request->input('txt_estadoestudiante');
                    $item2->plan_id = $request->input('txt-idplan');
                    $item2->user_id = $userId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }

            // SI EL USUARIO NO EXISTE
            else {


                // nuevo objeto
                $item = new User();
                // setear datos
                $item->identificationtype_id = $request->input('txt-identificationtype');
                $item->nroidenti = $request->input('txt_nroidenti');
                $item->password = $request->input('txt_password');
                $item->nombres = $request->input('txt_nombres');
                $item->apellido_pa = $request->input('txt_apellido_pa');
                $item->apellido_ma = $request->input('txt_apellido_ma');
                $item->fecnac = $request->input('txt_fecnac');
                $item->correo = $request->input('txt_correo');
                $item->telefono = $request->input('txt_telefono');
                $item->celular = $request->input('txt_celular');
                $item->direccion = $request->input('txt_direccion');
                $item->estado = $request->input('txt_estado');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $item->ubigeo_id = $idubigeo;
                $item->genre_id = $request->input('txt_genre_id');
                $item->usertype_id = '3';

                // validar guardado
                if ($item->save()) {
                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Student();
                    $item2->apoderado = $request->input('txt-apoderado');
                    $item2->anho_ingreso = $request->input('txt_anho_ingreso');
                    $item2->estado = $request->input('txt_estadoestudiante');
                    $item2->plan_id = $request->input('txt-idplan');
                    $item2->user_id = $newUserId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }
        }
    }


    public function update(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->nombres = $request->input('txt_nombres');
            $item->apellido_pa = $request->input('txt_apellido_pa');
            $item->apellido_ma = $request->input('txt_apellido_ma');
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $item->estado = $request->input('txt_estado');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            $item->genre_id = $request->input('txt_genre_id');
            // validar guardado
            if ($item->save()) {
                // nuevo objeto
                $item2 = new Student();

                $item2 = Student::where('user_id', $id)->first();
                // validar existencia del registro
                if (!$item2) {
                    abort(404);
                } else {
                    // recoger datos
                    $item2->apoderado = $request->input('txt-apoderado');
                    $item2->anho_ingreso = $request->input('txt_anho_ingreso');
                    $item2->estado = $request->input('txt_estadoestudiante');
                    // $item2->plan_id = $request->input('txt_name_plan_title');
                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                    }
                }
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function update_plan(Request $request, $id)
    {

        $item = Student::find($id);
        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->plan_id = $request->input('txt_name_plan_title');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function update_password(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    
    public function destroy($id)
    {
        // Busca el registro por su ID
        $usuario = User::find($id);
        $idusertype = $usuario->usertype_id;


        // SI SOLO ES ADMINISTRADOR
        if ($idusertype == '3') {

            // validar existencia del registro
            if (!$usuario) {
                return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
            }

            // validar eliminación
            if ($usuario->delete()) {
                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }

        // SI TIENE OTROS ROLES
        else {
            // eliminar registro del administrador
            $alumno = Student::where('user_id', $usuario->id)->first();
            if (!$alumno) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error, el registro no existe'
                ]);
            }
            // validar eliminación
            if ($alumno->delete()) {

                // actualizar tipo de usuario
                if ($idusertype == '5') {
                    $new_idusertype = 1;
                } else if ($idusertype == '6') {
                    $new_idusertype = 2;
                } else if ($idusertype == '7') {
                    $new_idusertype = 4;
                }
                $usuario->usertype_id = $new_idusertype;
                $usuario->save();

                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
    }


    public function ajax_all_by_idplan(Request $request, $idplan)
    {
        if ($request->ajax()) {
            $data = DB::table('estudiantes AS s')
                ->join('usuarios AS u', 's.user_id', '=', 'u.id')
                ->join('matriculas_semestres AS seen', 'seen.student_id', '=', 's.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->select(
                    'u.id AS iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado',
                    's.id AS idstudent',
                    's.anho_ingreso',
                    's.estado'
                )
                ->where('s.plan_id', $idplan)
                ->where('seen.semester_id', $request->input('idsemester'))      // filtro x semestre
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Teacher::all();
            $data = DB::table('estudiantes as s')
                ->join('usuarios as u', 's.user_id', '=', 'u.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->select(
                    'u.id as iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado',
                    's.id as idstudent',
                    's.anho_ingreso',
                    's.estado',
                )
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_by_idprogram(Request $request, $idprogram)
    {
        if ($request->ajax()) {
            $data = DB::table('estudiantes AS st')
                ->select(
                    'u.id as iduser',
                    'it.id as ididentificationtype',
                    'it.tipo as tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado',
                    'st.id as idstudent',
                    'st.anho_ingreso',
                    'st.estado'
                )
                ->join('usuarios as u', 'st.user_id', '=', 'u.id')
                ->join('planes as pl', 'st.plan_id', '=', 'pl.id')
                ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->join('tipos_identificaciones as it', 'it.id', '=', 'u.identificationtype_id')
                ->where('pr.id', $idprogram)
                ->orderBy('u.apellido_pa', 'ASC')
                ->orderBy('u.apellido_ma', 'ASC')
                ->orderBy('u.nombres', 'ASC')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
