<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Semesterenrollment;
use App\Models\Pago;
use App\Models\Concepto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class SemesterenrollmentController extends Controller
{
    //

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.matricula.alumnos_semestre.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        
        $idsemester = $request->input('idsemester');
        $idplan = $request->input('idplan');
        
        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes as st')
                ->crossJoin('semestres as se')
                ->leftJoin('matriculas_semestres as seen', function ($join) {
                    $join->on('st.id', '=', 'seen.student_id')
                        ->on('se.id', '=', 'seen.semester_id');
                })
                ->join('usuarios as us', 'st.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('planes as pl', 'st.plan_id', '=', 'pl.id')
                ->join('programas as pr', 'pl.program_id', '=', 'pr.id')
                ->leftJoin('pagos as pa', function ($join) {
                    $join->on('pa.student_id', '=', 'st.id')
                        ->on('pa.semester_id', '=', 'se.id');
                })
                ->select(
                    'se.id as idsemester',
                    'se.anho',
                    'se.numero',
                    'se.fecinicio',
                    'se.fecfin',
                    'seen.id as idsemesterenrollment',
                    'seen.student_id',
                    'seen.fecha as fechamatricula',
                    'seen.docboucher',
                    'pa.estado as estadopago',
                    'st.id as idstudent',
                    'st.anho_ingreso',
                    'st.estado as estadostudent',
                    'us.id as iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    'us.nombres',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular',
                    'us.direccion',
                    'pr.id as idprogram',
                    'pr.codprograma',
                    'pr.nombre as nombreprogram',
                    'pr.nivel_formativo',
                    'pl.id as idplan',
                    'pl.nombre as nombreplan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    DB::raw("CASE WHEN seen.student_id IS NOT NULL THEN '1' ELSE '0' END as relacion_estado")
                )
                ->where('se.id', $idsemester)
                ->where('st.plan_id', $idplan)
                ->orderBy('us.apellido_pa', 'ASC')
                ->orderBy('us.apellido_ma', 'ASC')
                ->orderBy('us.nombres', 'ASC')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {
        $data_semester = DB::table('semestres AS se')
        ->select('se.estado_matricula')
        ->where('se.id', $request->input('txt-idsemester'))
        ->get();
        
        if ($data_semester[0]->estado_matricula == 1) {
            
            $idstudent = $request->input('txt-idstudent');
            
            $item = new Semesterenrollment();
            $item->semester_id = $request->input('txt-idsemester');
            $item->student_id = $idstudent;
            $item->docboucher = "--";
            $item->estado = 0;
            $item->fecha = $request->input('txt-fecha');
            
            $item_concepto = Concepto::find(1);
            
            $item_pago = new Pago();
            $item_pago->semester_id = $request->input('txt-idsemester');
            $item_pago->student_id = $request->input('txt-idstudent');
            $item_pago->concepto_id = 1;
            $item_pago->fecha = $request->input('txt-fecha');
            $item_pago->monto_inicial = $item_concepto->monto;
            $item_pago->administrator_id = Auth::user()->administradores[0]->id;
            $item_pago->descuento = 0;
            $item_pago->monto_final = $item_concepto->monto;
            $item_pago->documento = "--";
            $item_pago->estado = 0;
            
            if ($item->save() && $item_pago->save() ) {
                return response()->json(["status" => true, "mensaje" => 'Matricula registrada correctamente']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Matricula no se pudo registrar']);
            }
        } else {
            return response()->json(["status" => false, "mensaje" => 'Las matriculas estan deshabilitadas']);
        }
    }


    public function update(Request $request, $idsemesterenrollment)
    {
        $data_semester = DB::table('semestres AS se')
        ->select('se.estado')
        ->where('se.id', $request->input('txt-idsemester'))
        ->get();

        if ($data_semester[0]->estado == 1) {
            $item = Semesterenrollment::find($idsemesterenrollment);

            // validar existencia del registro
            if (!$item) {
                abort(404);
            } else {
                // recoger datos
                $item->fecha = $request->input('txt-fecha');
                
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                }
            }
            
        } else {
            return response()->json(["status" => false, "mensaje" => 'Las matriculas estan deshabilitadas']);
        }
    }


    public function destroy($idsemesterenrollment)
    {
        // Busca el registro por su ID
        $item = Semesterenrollment::find($idsemesterenrollment);

        // recuperar data
        $idstudent = $item->student_id;
        $idsemester = $item->semester_id;

        $item_pago = DB::table('pagos')->where('semester_id', $idsemester)->where('student_id', $idstudent)->delete();

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }


        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
