<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Schedule;
use App\Models\Classroom;
use App\Models\Subject;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class ScheduleController extends Controller
{


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.horarios.asignar_horario.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index2(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.horarios.horario_general.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index3(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.horarios.horario_docente.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index4(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.horarios.horario_estudiante.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');
            $idperiod = $request->input('idperiod');

            $query = DB::table('asignaturas')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->join('programas', 'programas.id', '=', 'planes.program_id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->leftJoin('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->select(
                    'programas.nombre as programa',
                    'planes.nombre as plan',
                    'periodos.numero as periodo',
                    'cursos.codcurso',
                    'cursos.nombre',
                    'cursos.creditos',
                    'cursos.horas',
                    'asignaturas.id as idasignatura',
                    'asignaturas.seccion',
                    'asignaturas.turno',
                    'horarios.id as idhorario',
                    'horarios.dia',
                    DB::raw("TIME_FORMAT(horarios.horaini, '%H:%i') as horaini"),
                    DB::raw("TIME_FORMAT(horarios.horafin, '%H:%i') as horafin"),
                    DB::raw("DATE_FORMAT(horarios.horaini, '%h:%i %p') as horaini2"), // Formato de 12 horas con AM/PM
                    DB::raw("DATE_FORMAT(horarios.horafin, '%h:%i %p') as horafin2"), // Formato de 12 horas con AM/PM
                    DB::raw("TIME_FORMAT(horarios.duracion, '%h:%i hrs') as duracion"),
                    'aulas.id as idaula',
                    'aulas.tipo',
                    'aulas.numero',
                    'aulas.piso'
                )
                ->where('semestres.id', $idsemester)
                ->orderBy('periodo')
                ->orderBy('programa')
                ->orderBy('plan')
                ->orderBy('cursos.nombre')
                ->orderBy('horarios.dia');

            if ($idperiod != "null") {
                $query->where('periodos.id', $idperiod);
            }

            $data = $query->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false, "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function list2(Request $request)
    {
        if ($request->ajax()) {
            //$data = Schedule::select('*');

            $idsemester = $request->input('idsemester');

            $data = DB::table('asignaturas')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->leftJoin('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->leftJoin('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->select(
                    'cursos.codcurso',
                    'cursos.nombre',
                    'cursos.creditos',
                    'cursos.horas',
                    'asignaturas.id AS idasignatura',
                    'asignaturas.seccion',
                    'asignaturas.turno',
                    'horarios.id AS idhorario',
                    'horarios.dia',
                    DB::raw("TIME_FORMAT(horarios.horaini, '%H:%i hrs') AS horaini"),
                    DB::raw("TIME_FORMAT(horarios.horafin, '%H:%i hrs') AS horafin"),
                    DB::raw("TIME_FORMAT(horarios.duracion, '%h:%i hrs') AS duracion"),
                    'aulas.id AS idaula',
                    'aulas.tipo',
                    'aulas.numero',
                    'aulas.piso'
                )
                ->where('semestres.id', $idsemester)
                ->orderBy('cursos.nombre')
                ->orderBy('horarios.dia')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false, "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store(Request $request)
    {
        if ($request->ajax()) {
            
            $horario = DB::table('horarios as h')
                ->join('asignaturas as a', 'a.id', '=', 'h.subject_id')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->select('h.id', 'h.dia', 'h.horaini', 'h.horafin', 'h.classroom_id')
                ->where('h.dia', $request->input('txt_dia'))
                ->where(function ($query) use ($request) {
                    $query->where(function ($q) use ($request) {
                        $q->whereTime('h.horaini', '>=', $request->input('txt_horaini'))
                            ->whereTime('h.horaini', '<', $request->input('txt_horafin'));
                    })->orWhere(function ($q) use ($request) {
                        $q->whereTime('h.horafin', '>', $request->input('txt_horaini'))
                            ->whereTime('h.horafin', '<=', $request->input('txt_horafin'));
                    });
                })
                // ->where('subject_id', $request->input('txt_idasignatura'))
                ->where('h.classroom_id', $request->input('txt_idaula'))
                ->where('s.id', $request->input('txt-idsemester'))
                ->get();
                
            $item2 = DB::table('asignaturas as a')
            ->selectRaw('c.horas * 45 as duracion_curso, SUM(TIME_TO_SEC(h.duracion) / 60) AS duracion_horario')
            ->leftJoin('horarios as h', 'h.subject_id', '=', 'a.id')
            ->join('cursos as c', 'c.id', '=', 'a.course_id')
            ->where('a.id', '=', $request->input('txt_idasignatura'))
            ->groupBy('c.horas')
            ->first();
            
            //Agarramos la hora de inicio y fin del horario para pasarlo a minutos
            $hora_inicio = strtotime($request->input('txt_horaini'));
            $hora_fin = strtotime($request->input('txt_horafin'));
            $duracion_actual = ($hora_fin - $hora_inicio)/60;
            
            if(($item2->duracion_horario + $duracion_actual) > $item2->duracion_curso)
            {
                return response()->json([ "status" => false, "mensaje" => 'Error: El horario supera las horas del curso']);
            }
            
            // Si el horario esta vacio
            if ($horario->isEmpty()) {
                $item = new Schedule();
                $item->dia = $request->input('txt_dia');
                $item->horaini = $request->input('txt_horaini');
                $item->horafin = $request->input('txt_horafin');
                $item->duracion = DB::raw('TIMEDIFF(horafin, horaini)');
                $item->subject_id = $request->input('txt_idasignatura');
                $item->classroom_id = $request->input('txt_idaula');
                
                // Guarda el nuevo registro en la base de datos
                if ($item->save()) {
                    // El guardado fue exitoso
                    return response()->json(["status" => true, "mensaje" => 'Éxito: registros realizado']);
                } else {
                    // El guardado falló
                    return response()->json(["status" => false,"mensaje" => 'Error: registros no realizado']);
                }
            } else {
                // No se encontraron registros
                return response()->json([
                    "status" => false,
                    "mensaje" => 'El horario ya esta ocupado'
                ]);
            }
        }
    }

    public function update(Request $request, $id)
    {
        $query = DB::table('asignaturas as a')
        ->selectRaw('c.horas * 45 as duracion_curso, SUM(TIME_TO_SEC(h.duracion) / 60) AS duracion_horario')
        ->leftJoin('horarios as h', 'h.subject_id', '=', 'a.id')
        ->join('cursos as c', 'c.id', '=', 'a.course_id')
        ->where('a.id', '=', $request->input('txt_idasignatura'))
        ->groupBy('c.horas')
        ->first();

        //Agarramos la hora de inicio y fin del horario para pasarlo a minutos
        $hora_inicio = strtotime($request->input('txt_horaini'));
        $hora_fin = strtotime($request->input('txt_horafin'));
        $duracion_actual = ($hora_fin - $hora_inicio)/60;

        if(($query->duracion_horario + $duracion_actual) > $query->duracion_curso)
        {
            return response()->json([ "status" => false, "mensaje" => 'Error: El horario supera las horas del curso']);
        }

        $item = Schedule::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->dia = $request->input('txt_dia');
            $item->horaini = $request->input('txt_horaini');
            $item->horafin = $request->input('txt_horafin');
            $item->duracion = DB::raw('TIMEDIFF(horafin, horaini)');
            $item->subject_id = $request->input('txt_idasignatura');
            $item->classroom_id = $request->input('txt_idaula');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json([
                    "status" => true,
                    "mensaje" => 'Éxito: registros actualizado'
                ]);
            } else {
                // El guardado falló
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error: registros no pudo ser actualizado'
                ]);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $Schedule = Schedule::find($id);

        // Verifica si el registro existeSchedule
        if (!$Schedule) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($Schedule->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Schedule::all();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function horario_general(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');
            $idplan = $request->input('idplan');

            $data = DB::table('asignaturas')->select([
                'cursos.codcurso',
                'cursos.nombre as curso',
                'asignaturas.turno',
                'asignaturas.seccion',
                'cursos.creditos',
                'cursos.horas',
                'periodos.numero as periodo',
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Lunes'),
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Martes'),
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Miercoles'),
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Jueves'),
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Viernes'),
                DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Sabado'),
                // DB::raw('GROUP_CONCAT(CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END) AS Martes'),
                // DB::raw('GROUP_CONCAT(CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END) AS Miercoles'),
                // DB::raw('GROUP_CONCAT(CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END) AS Jueves'),
                // DB::raw('GROUP_CONCAT(CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END) AS Viernes'),
                // DB::raw('GROUP_CONCAT(CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%H:%i"), " - ", TIME_FORMAT(horarios.horafin, "%H:%i")) END) AS Sabado'),
                DB::raw('COALESCE( CONCAT(usuarios.nombres, " ", usuarios.apellido_pa, " ", usuarios.apellido_ma), "-") AS docente'),
                DB::raw('COALESCE(aulas.numero, "-") AS aula'),
            ])
                ->leftJoin('docentes', 'docentes.id', '=', 'asignaturas.teacher_id')
                ->leftJoin('usuarios', 'usuarios.id', '=', 'docentes.user_id')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->where('semestres.id', $idsemester)
                ->where('planes.id', $idplan)
                ->groupBy(
                    'cursos.codcurso',
                    'cursos.nombre',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'cursos.creditos',
                    'cursos.horas',
                    'periodos.numero',
                    'docentes.user_id',
                    'docente',
                    'aula'
                )
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false, "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function horario_docente(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');
            $idteacher = $request->input('idteacher');

            $data = DB::table('asignaturas')
                ->select([
                    'programas.nombre as programa',
                    'planes.nombre as plan',
                    'cursos.codcurso',
                    'cursos.nombre as curso',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'cursos.creditos',
                    'cursos.horas',
                    'periodos.numero as periodo',
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Lunes'),
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Martes'),
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Miercoles'),
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Jueves'),
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Viernes'),
                    DB::raw('COALESCE( GROUP_CONCAT( CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Sabado'),
                    DB::raw('COALESCE(aulas.numero, "-") AS aula'),
                ])
                ->leftJoin('docentes', 'docentes.id', '=', 'asignaturas.teacher_id')
                ->leftJoin('usuarios', 'usuarios.id', '=', 'docentes.user_id')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->join('programas', 'programas.id', '=', 'planes.program_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->where('semestres.id', $idsemester)
                ->where('asignaturas.teacher_id', $idteacher)
                ->groupBy('programas.nombre', 'planes.nombre', 'cursos.codcurso', 'cursos.nombre', 'asignaturas.turno', 'asignaturas.seccion', 'cursos.creditos', 'cursos.horas', 'periodos.numero', 'aula')
                ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false, "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function horario_estudiante(Request $request)
    {
        if ($request->ajax()) {

            $idsemester = $request->input('idsemester');
            $idstudent = $request->input('idstudent');

            $data = DB::table('asignaturas')
                ->select(
                    'cursos.codcurso',
                    'cursos.nombre AS curso',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'periodos.numero AS periodo',
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Lunes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Lunes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Martes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Martes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Miercoles" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Miercoles'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Jueves" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Jueves'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Viernes" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Viernes'),
                    DB::raw('COALESCE(GROUP_CONCAT(CASE WHEN horarios.dia = "Sabado" THEN CONCAT(TIME_FORMAT(horarios.horaini, "%h:%i %p"), " - ", TIME_FORMAT(horarios.horafin, "%h:%i %p")) END), "-") AS Sabado'),
                    DB::raw('COALESCE(CONCAT(usuarios.nombres, " ", usuarios.apellido_pa, " ", usuarios.apellido_ma), "-") AS docente'),
                    DB::raw('COALESCE(aulas.numero, "-") AS aula')
                )
                ->leftJoin('docentes', 'docentes.id', '=', 'asignaturas.teacher_id')
                ->leftJoin('usuarios', 'usuarios.id', '=', 'docentes.user_id')
                ->join('matriculas_asignaturas', 'asignaturas.id', '=', 'matriculas_asignaturas.subject_id')
                ->join('estudiantes', 'estudiantes.id', '=', 'matriculas_asignaturas.student_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->leftJoin('horarios', 'horarios.subject_id', '=', 'asignaturas.id')
                ->leftJoin('aulas', 'aulas.id', '=', 'horarios.classroom_id')
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->where('semestres.id', $idsemester)
                ->where('estudiantes.id', $idstudent)
                ->groupBy(
                    'cursos.codcurso',
                    'cursos.nombre',
                    'asignaturas.turno',
                    'asignaturas.seccion',
                    'periodos.numero',
                    'semestres.id',
                    'docentes.user_id',
                    'docente',
                    'aula'
                )
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false, "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function generar_horario(Request $request, $idsemester)
    {
        if ($request->ajax()) {

            // Obtén la lista de asignaturas
            $data = DB::table('asignaturas')
                ->select(
                    'asignaturas.id as idsubject',
                    'cursos.nombre as curso',
                    'cursos.horas as horas',
                    'periodos.numero as periodo',
                    'planes.nombre as plan',
                    'programas.nombre as programa'
                )
                ->join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->join('programas', 'programas.id', '=', 'planes.program_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->where('semestres.id', $idsemester)
                ->orderBy('periodo')
                ->orderBy('programa')
                ->orderBy('plan')
                ->orderBy('curso')
                ->get();

            // Obtén la lista de aulas disponibles
            $classroom = Classroom::select('id')->get();
            $idaula = $classroom->pluck('id')->toArray();

            // Define las horas disponibles en un día
            $horas_disponibles = [
                '08:00:00', '09:00:00', '10:00:00', '11:00:00', '12:00:00',
                '13:00:00', '14:00:00', '15:00:00', '16:00:00', '17:00:00', '18:00:00'
            ];

            // Define el número de días en una semana (de lunes a viernes)
            $dias_semana = ['Lunes', 'Martes', 'Miercoles', 'Jueves', 'Viernes', 'Sabado'];

            $conthora = 0;
            $contdia =  0;
            $contaula = 0;

            foreach ($data as $row) {

                if ($this->query_horario($dias_semana[$contdia], $horas_disponibles[$conthora], $horas_disponibles[$conthora + 1], $idaula[$contaula])->isEmpty()) {

                    $item = new Schedule();
                    $item->dia = $dias_semana[$contdia];
                    $item->horaini = $horas_disponibles[$conthora];
                    $item->horafin = $horas_disponibles[$conthora + 1];
                    $item->subject_id = $row->idsubject;
                    $item->classroom_id = $idaula[$contaula];

                    $item->save();

                    if($dias_semana[$contdia] == "Sabado") {
                        $contdia = -1;
                    }

                } else {

                    $conthora++;

                    $item = new Schedule();
                    $item->dia = $dias_semana[$contdia];
                    $item->horaini = $horas_disponibles[$conthora];
                    $item->horafin = $horas_disponibles[$conthora + 1];
                    $item->subject_id = $row->idsubject;
                    $item->classroom_id = $idaula[$contaula];

                    $item->save();

                    $conthora--;

                }

                $contdia++;

            }


            return response()->json(["status" => true, "mensaje" => 'Horario generado automáticamente']);
        }
    }

    public function query_horario($dia, $horaini, $horafin, $aula)
    {
        $horario = DB::table('horarios')
                    ->select('id', 'dia', 'horaini', 'horafin', 'classroom_id')
                    ->where('dia', $dia)
                    ->where(function ($query) use ($horaini, $horafin) {
                        $query->where(function ($q) use ($horaini, $horafin) {
                            $q->whereTime('horaini', '>=', $horaini)
                                ->whereTime('horafin', '<=', $horafin);
                        })->orWhere(function ($q) use ($horafin) {
                            $q->whereTime('horaini', '<', $horafin);
                        });
                    })
                    ->where('classroom_id', $aula)
                    ->get();

        return $horario;
    }
}
