<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Models\Publicacion;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;

class PublicacionesController extends Controller
{

    public function index(Request $request)
    {

        if (Auth::check()) {

            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                ;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.bienestar.publicaciones.index')
                    ->with('datatipoacceso', $tipoacceso)
                    ->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {


            $result = DB::table('publicacions as p')
                ->join('planes as pl', 'p.plan_id', '=', 'pl.id')
                ->select(
                    'p.id',
                    'p.titulo',
                    'p.contenido',
                    'p.carpeta',
                    'p.imagen',
                    'p.plan_id',
                    'pl.nombre',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque',
                    'p.created_at as fecharegistro'
                )
                ->orderBy('p.created_at', 'desc')
                ->get();


            if ($result->isEmpty()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Warnin, No hay registros',
                    "data" => []
                ]);
            } else {
                return response()->json([
                    "status" => true,
                    "mensaje" => 'SuccesFull, la consulta tiene registros encontrados',
                    "data" => $result
                ]);
            }
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function list_parameter(Request $request,$opcion )
    {

        if ($request->ajax()) {


            if($opcion == "1"){

                $result = DB::table('publicacions as p')
                ->join('planes as pl', 'p.plan_id', '=', 'pl.id')
                ->select('p.id', 'p.titulo', 'p.contenido', 'p.plan_id', 'pl.nombre', 'pl.tipo', 'pl.modalidad', 'pl.enfoque', 'p.created_at as fecharegistro')
                ->where('p.created_at', '>=', Carbon::now()->subHours(48)) // Filtrar últimas 48 horas
                ->orderBy('p.created_at', 'desc')
                ->get();

            }else  if($opcion == "2"){

                $result = DB::table('publicacions as p')
                ->join('planes as pl', 'p.plan_id', '=', 'pl.id')
                ->select('p.id', 'p.titulo', 'p.contenido', 'p.plan_id', 'pl.nombre', 'pl.tipo', 'pl.modalidad', 'pl.enfoque', 'p.created_at as fecharegistro')
                ->where('p.created_at', '<', Carbon::now()->subHours(48)) // Filtrar más de 48 horas
                ->orderBy('p.created_at', 'desc')
                ->get();

            }




            if ($result->isEmpty()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Warnin, No hay registros',
                    "data" => []
                ]);
            } else {
                return response()->json([
                    "status" => true,
                    "mensaje" => 'SuccesFull, la consulta tiene registros encontrados',
                    "data" => $result
                ]);
            }
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }
    public function store(Request $request)
    {
        try {
            // Validación de los campos
            $validator = Validator::make($request->all(), [
                'txt-plans' => 'required', // Validar que existe en la tabla de planes
                'txt-titulo' => 'required|string|max:255', // Limitar el tamaño del título
                'contenido' => 'required|string', // Verificar que el contenido es texto
                'txt-imagen' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Hacer la imagen opcional
            ]);

            // Manejar errores de validación
            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "errors" => $validator->errors(),
                ], 422); // Código 422 para errores de validación
            }

            // Variables para la publicación
            $fileName = null; // Iniciar el nombre del archivo como null

            // Verificar si se ha subido una imagen
            if ($request->hasFile('txt-imagen')) {



                $folderName = Str::uuid(); // Nombre único para la carpeta

                // Crear la carpeta para almacenar la imagen
                Storage::disk('local')->makeDirectory('publicaciones/' . $folderName);

                $archivo = $request->file('txt-imagen');
                $fileName = $archivo->getClientOriginalName(); // Obtener el nombre original del archivo

                // Almacenar el archivo en la carpeta correspondiente
                $archivo->storeAs('publicaciones/' . $folderName, $fileName, 'local');
            } else {
                $folderName = "default"; // Nombre único para la carpeta
                // Si no se ha subido una imagen, asignar una imagen por defecto
                $fileName = 'pic6.jpg'; // Ruta de la imagen por defecto
            }

            // Crear la nueva publicación
            $publicacion = new Publicacion();
            $publicacion->plan_id = $request->input('txt-plans');
            $publicacion->carpeta = $folderName;
            $publicacion->imagen = $fileName; // Guardar el nombre de la imagen (o la por defecto)
            $publicacion->titulo = $request->input('txt-titulo');
            $publicacion->contenido = $request->input('contenido');

            // Guardar la publicación en la base de datos
            if ($publicacion->save()) {
                return response()->json([
                    "status" => true,
                    "mensaje" => '¡Éxito! Publicación registrada.',
                    "data" => $publicacion // Opcional: Devolver la publicación creada
                ], 201); // Código 201 para creación exitosa
            }

            // Respuesta en caso de error al guardar
            return response()->json([
                "status" => false,
                "mensaje" => 'Error al registrar la publicación. Inténtalo nuevamente.',
                "data" => $publicacion
            ], 500); // Código 500 para errores internos

        } catch (\Exception $e) {
            // Manejar excepciones inesperadas
            return response()->json([
                "status" => false,
                "mensaje" => 'Ocurrió un error inesperado.',
                "error" => $e->getMessage(), // Para debugging en desarrollo
            ], 500);
        }
    }


    public function update(Request $request)
    {
        try {
            // Validación de los campos
            $validator = Validator::make($request->all(), [
                'txt-plans' => 'required', // Validar que existe en la tabla de planes
                'txt-titulo' => 'required|string|max:255', // Limitar el tamaño del título
                'contenido' => 'required|string', // Verificar que el contenido es texto
                'txt-imagen' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Hacer la imagen opcional
            ]);

            // Manejar errores de validación
            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "errors" => $validator->errors(),
                ], 422); // Código 422 para errores de validación
            }

            $idpublicacion = $request->input('txt-idpublicacion');

            $item = Publicacion::find($idpublicacion);

            if ($request->hasFile('txt-imagen')) {

                $folderName = $item->carpeta;
                $fileName = $item->imagen;

                if ($item->imagen && Storage::disk('local')->exists('publicaciones/' . $folderName . '/' . $fileName)) {
                    Storage::disk('local')->delete('publicaciones/' . $folderName . '/' . $fileName);
                }

                $archivo = $request->file('txt-imagen');
                $fileName = $archivo->getClientOriginalName(); // Obtener el nombre original del archivo

                // Almacenar el archivo en la carpeta correspondiente
                $archivo->storeAs('publicaciones/' . $folderName, $fileName, 'local');
                $item->carpeta = $folderName;
                $item->imagen = $fileName;
            }

            // Crear la nueva publicación
            $item->plan_id = $request->input('txt-plans');

            $item->titulo = $request->input('txt-titulo');
            $item->contenido = $request->input('contenido');

            // Guardar la publicación en la base de datos
            if ($item->save()) {
                return response()->json([
                    "status" => true,
                    "mensaje" => '¡Éxito! Publicación Actualizada.',
                    "data" => $item // Opcional: Devolver la publicación creada
                ], 200); // Código 201 para creación exitosa
            }

            // Respuesta en caso de error al guardar
            return response()->json([
                "status" => false,
                "mensaje" => 'Error al registrar la publicación. Inténtalo nuevamente.',
                "data" => $item
            ], 500); // Código 500 para errores internos

        } catch (\Exception $e) {
            // Manejar excepciones inesperadas
            return response()->json([
                "status" => false,
                "mensaje" => 'Ocurrió un error inesperado.',
                "error" => $e->getMessage(), // Para debugging en desarrollo
            ], 500);
        }
    }



    public function destroy($id)
    {
        // Busca el registro por su ID
        $publicacion = Publicacion::find($id);

        // Verifica si el registro existe
        if (!$publicacion) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($publicacion->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, el registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al eliminar registro'
            ]);
        }
    }

    public function verImagen($idpublicacion, $carpeta, $imagen)
    {
        // Buscar la publicación por ID
        $item = Publicacion::find($idpublicacion);

        if (!$item || !$item->imagen) {
            abort(404, 'Imagen no encontrada.');
        }

        // Ruta completa del archivo de la imagen
        $file = storage_path('app/publicaciones/').$carpeta.'/'. $imagen;

        if (file_exists($file)) {
            // Determinar el tipo MIME de la imagen
            $mimeType = mime_content_type($file);

            if (strpos($mimeType, 'image/') !== 0) {
                abort(400, 'El archivo no es una imagen válida.');
            }

            // Devolver la imagen como respuesta
            return response()->file($file, [
                'Content-Type' => $mimeType,
            ]);
        } else {
            abort(404, 'Archivo no encontrado.');
        }
    }




}
