<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Subject;
use App\Models\Nota;
use App\Models\User;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Route;
use Barryvdh\DomPDF\Facade\Pdf as PDF;
use Illuminate\Http\Response;

class NotaController extends Controller
{

    public function index1(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.notas.notas_asignaturas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function index2(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.notas.notas_alumnos.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list_nota_asignatura(Request $request)
    {
        if ($request->ajax()) {
            
            $idsubject = $request->input('idsubject');
            
        // Subconsulta para promedios por nota
        $gradesQuery = DB::table('estudiantes AS e')
        ->selectRaw('
            a.id AS idsubject,
            e.id AS idstudent,
            CONCAT(ti.tipo, " - ", u.nroidenti) AS identificacion,
            CONCAT(u.apellido_pa, " ", u.apellido_ma, ", ", u.nombres) AS estudiante,
            i.id AS idindicator,
            ac.id AS idactivity,
            n.id AS idgrade,
            n.nombre AS tipo_nota,
            n.porcentaje AS porcentaje,
            ne.id AS idstudentgrade,
            COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 2), 0) AS nota
        ')
        ->join('usuarios AS u', 'e.user_id', '=', 'u.id')
        ->join('tipos_identificaciones AS ti', 'u.identificationtype_id', '=', 'ti.id')
        ->join('matriculas_asignaturas AS ma', 'e.id', '=', 'ma.student_id')
        ->join('asignaturas AS a', 'ma.subject_id', '=', 'a.id')
        ->join('indicadores AS i', 'i.subject_id', '=', 'a.id')
        ->join('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
        ->join('notas AS n', 'n.activity_id', '=', 'ac.id')
        ->leftJoin('notas_estudiantes AS ne', function ($join) {
            $join->on('ne.grade_id', '=', 'n.id')
                ->on('ne.subjectenrollment_id', '=', 'ma.id');
        })
        ->where('a.id', '=', $idsubject)
        // ->where('e.id', '=', 7)
        ->groupBy(
            'idsubject', 'idstudent',
            'estudiante', 'identificacion', 'idindicator', 'idactivity',
            'idgrade', 'idstudentgrade', 'tipo_nota', 'porcentaje', 'ti.tipo',
            'u.nroidenti', 'u.apellido_pa', 'u.apellido_ma', 'u.nombres'
        );

        // Subconsulta para promedios por actividad
        $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_2'))
        ->mergeBindings($gradesQuery)
        ->groupBy(
            'idsubject', 'idstudent',
            'estudiante', 'identificacion', 'idindicator', 'idactivity'
        )
        ->selectRaw('
            idsubject,
            idstudent,
            identificacion,
            estudiante,
            idindicator,
            idactivity,
            COALESCE(ROUND(SUM(nota * porcentaje), 2), 0) AS promedio_actividades
        ');

        // Subconsulta para promedios por indicador
        $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_3'))
        ->mergeBindings($activityQuery)
        ->groupBy(
            'idsubject', 'idstudent',
            'estudiante', 'identificacion', 'idindicator'
        )
        ->selectRaw('
            idsubject,
            idstudent,
            identificacion,
            estudiante,
            idindicator,
            COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 2), 0) AS promedio_indicadores
        ');

        // Consulta final
        $promedios = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_4'))
        ->mergeBindings($indicatorQuery)
        ->groupBy(
            'estudiante', 'identificacion',
            'idsubject', 'idstudent'
        )
        ->selectRaw('
            idsubject,
            idstudent,
            identificacion,
            estudiante,
            COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final
        ')
        ->get();

            // datatable
            return DataTables::of($promedios)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_nota_alumno(Request $request)
    {
        if ($request->ajax()) {

        $idsemester = $request->input('idsemester');
        $idstudent = $request->input('idstudent');

        // Subconsulta para ver cada nota
        $gradesQuery = DB::table('matriculas_asignaturas AS ma')
        ->selectRaw('
            a.id AS idsubject,
            ma.student_id AS idstudent,
            pl.nombre AS plan,
            c.codcurso AS codcurso,
            c.nombre AS curso,
            CONCAT("Crd: ", c.creditos, " - Hrs: ", c.horas) AS creditos_horas,
            pe.numero AS periodo,
            a.tipo AS condicion,
            a.seccion AS seccion,
            a.turno AS turno,
            i.id AS idindicator,
            ac.id AS idactivity,
            n.id AS idgrade,
            ne.id AS idstudentgrade,
            n.nombre AS tipo_nota,
            n.porcentaje AS porcentaje,
            COALESCE(ROUND(SUM(ne.nota) / COUNT(ne.id), 1), 0) AS nota
        ')
        ->join('asignaturas AS a', 'a.id', '=', 'ma.subject_id')
        ->join('cursos AS c', 'c.id', '=', 'a.course_id')
        ->join('periodos AS pe', 'pe.id', '=', 'c.period_id')
        ->join('planes AS pl', 'pl.id', '=', 'pe.plan_id')
        ->join('semestres AS se', 'se.id', '=', 'a.semester_id')
        ->leftJoin('indicadores AS i', 'i.subject_id', '=', 'a.id')
        ->leftJoin('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
        ->leftJoin('notas AS n', 'n.activity_id', '=', 'ac.id')
        ->leftJoin('notas_estudiantes AS ne', function ($join) {
            $join->on('ne.grade_id', '=', 'n.id')
                ->on('ne.subjectenrollment_id', '=', 'ma.id');
        })
        ->where('ma.student_id', '=', $idstudent)
        ->where('se.id', '=', $idsemester)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity', 'idgrade', 'idstudentgrade', 'tipo_nota', 'porcentaje', 'idsubject', 'idstudent');

        // Subconsulta para promedios por actividad
        $activityQuery = DB::table(DB::raw('(' . $gradesQuery->toSql() . ') AS subconsulta_2'))
        ->mergeBindings($gradesQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idactivity', 'idsubject', 'idstudent')
        ->selectRaw('
            idsubject,
            idstudent,
            plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            idindicator,
            idactivity,
            COALESCE(ROUND(SUM(nota * porcentaje), 1), 0) AS promedio_actividades
        ');

        // Subconsulta para promedios por indicador
        $indicatorQuery = DB::table(DB::raw('(' . $activityQuery->toSql() . ') AS subconsulta_3'))
        ->mergeBindings($activityQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idindicator', 'idsubject', 'idstudent')
        ->selectRaw('
            idsubject,
            idstudent,
            plan,
            codcurso,
            curso,
            creditos_horas,
            periodo,
            condicion,
            seccion,
            turno,
            idindicator,
            COALESCE(ROUND(SUM(promedio_actividades) / COUNT(idactivity), 1), 0) AS promedio_indicadores
        ');

        // Consulta final
        $promedios = DB::table(DB::raw('(' . $indicatorQuery->toSql() . ') AS subconsulta_4'))
        ->mergeBindings($indicatorQuery)
        ->groupBy('plan', 'curso', 'codcurso', 'creditos_horas', 'periodo', 'condicion', 'seccion', 'turno', 'idsubject', 'idstudent')
        ->selectRaw('
            idsubject,
            idstudent,
            plan,
            periodo,
            codcurso,
            curso,
            creditos_horas,
            condicion,
            seccion,
            turno,
            COALESCE(ROUND(SUM(promedio_indicadores) / COUNT(idindicator), 1), 0) AS promedio_final
        ')
        ->get();

            // datatable
            return DataTables::of($promedios)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function list_detalle_nota(Request $request)
    {
        if ($request->ajax()) {

            $idsubject = $request->input('idsubject');
            $idstudent = $request->input('idstudent');

            // Subconsulta para promedios por nota
            $data = DB::table('estudiantes AS e')
            ->select('ne.id AS idstudentgrade',
            'i.nombre AS indicador',
            'ac.nombre AS actividad',
            'n.nombre AS tipo_nota',
            'n.porcentaje AS porcentaje',
            'n.nombre AS nombre_nota',
            'ne.nota AS nota_estudiante')
            ->join('usuarios AS u', 'e.user_id', '=', 'u.id')
            ->join('tipos_identificaciones AS ti', 'u.identificationtype_id', '=', 'ti.id')
            ->join('matriculas_asignaturas AS ma', 'e.id', '=', 'ma.student_id')
            ->join('asignaturas AS a', 'ma.subject_id', '=', 'a.id')
            ->join('indicadores AS i', 'i.subject_id', '=', 'a.id')
            ->join('actividades AS ac', 'ac.indicator_id', '=', 'i.id')
            ->join('notas AS n', 'n.activity_id', '=', 'ac.id')
            ->leftJoin('notas_estudiantes AS ne', function ($join) {
                $join->on('ne.grade_id', '=', 'n.id')
                    ->on('ne.subjectenrollment_id', '=', 'ma.id');
            })
            ->where('a.id', '=', $idsubject)
            ->where('e.id', '=', $idstudent)
            ->groupBy('indicador', 'actividad', 'tipo_nota', 'idstudentgrade',
            'porcentaje', 'nombre_nota', 'nota_estudiante')
            ->get();

            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar la información'
        ]);
    }
}
