<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjobapplication;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class JpjobapplicationController extends Controller
{
    //

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.bolsa_laboral.postulaciones.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }
    public function list(Request $request)
    {
        if ($request->ajax()) {

            $idcompany = $request->input('idcompany');
            $idcategory = $request->input('idcategory');
            // query
            $data = DB::table('bt_solicitudes_empleos as jobapp')
                ->join('bt_trabajos as job', 'jobapp.jpjob_id', '=', 'job.id')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->join('estudiantes as stu', 'jobapp.student_id', '=', 'stu.id')
                ->join('usuarios as us', 'stu.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->select(
                    'jobapp.id as idjobapplication',
                    'jobapp.fecaplicacion',
                    'jobapp.estado as estadojobapplication',
                    'jobapp.documento',
                    'jobapp.isvisto',
                    'jobapp.feedback',
                    'jobapp.fecfeedback',
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito',
                    'stu.id as idstudent',
                    'us.id as iduser',
                    'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    'us.nombres',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular'
                );

                if($idcompany != "all") { 
                    $data = $data->where('com.id', $idcompany);
                }

                if($idcategory != "all") { 
                    $data = $data->where('cat.id', $idcategory);
                }
                
                $data = $data->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }

    public function aprobar(Request $request, $id)
    {
        $item = Jpjobapplication::find($id);

        // Obtener la fecha y hora actual
        $fechaActual = Carbon::now();

        // También puedes formatear la fecha según tus necesidades
        $fechaFormateada = $fechaActual->format('Y-m-d');

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado = '1';
            $item->feedback = $request->input('txt-feedback');
            $item->fecfeedback = $fechaFormateada;
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function rechazar(Request $request, $id)
    {
        $item = Jpjobapplication::find($id);

        // Obtener la fecha y hora actual
        $fechaActual = Carbon::now();

        // También puedes formatear la fecha según tus necesidades
        $fechaFormateada = $fechaActual->format('Y-m-d');

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado = '0';
            $item->feedback = $request->input('txt-feedback');
            $item->fecfeedback = $fechaFormateada;
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($idjobapplication)
    {
        // Busca el registro por su id
        $item = Jpjobapplication::find($idjobapplication);

        // recuperar data
        $ruta = $item->documento;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $file = storage_path('app/') . $ruta;
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
