<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\Course;
use App\Models\Semesterperiod;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class CourseController extends Controller
{
    //


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.cursos.asignaturas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {

        $idsemester = $request->input('idsemester');
        $idperiod = $request->input('idperiod');

        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('semestres as se', 'su.semester_id', '=', 'se.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->select(
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.vacantes',
                    'su.matriculados',
                    'su.teacher_id',
                    'co.codcurso',
                    'co.nombre as nomcurso',
                    'co.creditos',
                    'co.horas',
                    'se.id as idsemester',
                    'co.id as idcourse',
                    'pe.id as idperiod'
                )
                ->where('se.id', $idsemester)
                ->where('pe.id', $idperiod)
                ->get();
                
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function list_by_idperiod(Request $request)
    {
        $idperiod = $request->input('idperiod');
        if ($request->ajax()) {
            // query
            $data = Course::where('period_id', $idperiod)
                ->orderBy('nombre', 'asc')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function ajax_all_by_idplan(Request $request, $idplan)
    {
        if ($request->ajax()) {
            $data = DB::table('cursos as co')
                ->select(
                    'pe.id as idperiod','pe.numero',
                    'co.id as idcourse','co.tipo','co.codcurso',
                    'co.nombre','co.codpredecesor','co.horas','co.creditos'
                )
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->where('pe.plan_id', $idplan)
                ->orderBy('pe.numero', 'ASC')
                ->orderBy('co.nombre', 'ASC')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
