<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Attendance;
use App\Models\Subjectclass;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class AttendanceController extends Controller
{
    //
    public function store(Request $request)
    {
        $item = new Attendance();
        $item->nombre = $request->input('txt-g_nombre');
        $item->Attendancetype_id = $request->input('txt-g_idAttendancetype');
        $item->activity_id = $request->input('txt-g_idactivity');

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Attendance guardado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Attendance no guardado'
            ]);
        }
    }

    
    public function update(Request $request, $id)
    {
        $item = Attendance::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->nombre = $request->input('txt-g_nombre');
            $item->Attendancetype_id = $request->input('txt-g_idAttendancetype');

            if ($item->save()) {
                // El guardado fue exitoso
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                // El guardado falló
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Attendance::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }


    public function generar_clases(Request $request, $idsemester, $fecha)
    {
        if ($request->ajax()) {

            $clases = DB::table('clases_asignaturas as ca')
            ->select([
                'ca.id as idsubjectclass',
                'ca.nombre',
                'ca.dia',
                'ca.fecha',
                'ca.estado'
            ])
            ->join('horarios as h', 'h.id', '=', 'ca.schedule_id')
            ->join('asignaturas as a', 'a.id', '=', 'h.subject_id')
            ->join('semestres as s', 's.id', '=', 'a.semester_id')
            ->where('s.id', $idsemester)
            ->get();

            if(!$clases) {
                return response()->json(["status" => false, "mensaje" => 'Las clases ya fueron creadas anteriormente']);
            }

            // Obtén la lista de horarios del semestre dado
            $horarios = DB::table('horarios as h')
                ->select(
                    'h.id as idhorario',
                    'h.dia',
                    'h.horaini',
                    'h.horafin')
                ->join('asignaturas as a', 'a.id', '=', 'h.subject_id')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->where('s.id', $idsemester)
                ->get();

            // Establecer la configuración regional a español
            //setlocale(LC_TIME, 'es_ES');


            // Recorrer cada horario y generar clases según la lógica dada
            foreach ($horarios as $horario) {

                $nueva_fecha = $fecha;

                // Obtener el día de la semana en español
                $nombreDia = strftime("%A", strtotime($fecha));

                if($horario->dia == "Lunes" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                } else if($horario->dia == "Lunes" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 6 . " days"));
                } else if($horario->dia == "Lunes" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 5 . " days"));
                } else if($horario->dia == "Lunes" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 4 . " days"));
                } else if($horario->dia == "Lunes" && $nombreDia == "Friday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 3 . " days"));
                } else if($horario->dia == "Lunes" && $nombreDia == "Saturday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 2 . " days"));
                }

                if($horario->dia == "Martes" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 1 . " days"));
                } else if($horario->dia == "Martes" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                } else if($horario->dia == "Martes" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 6 . " days"));
                } else if($horario->dia == "Martes" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 5 . " days"));
                } else if($horario->dia == "Martes" && $nombreDia == "Viernes") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 4 . " days"));
                } else if($horario->dia == "Martes" && $nombreDia == "Sabado") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 3 . " days"));
                }

                if($horario->dia == "Miercoles" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 2 . " days"));
                } else if($horario->dia == "Miercoles" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 1 . " days"));
                } else if($horario->dia == "Miercoles" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                } else if($horario->dia == "Miercoles" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 6 . " days"));
                } else if($horario->dia == "Miercoles" && $nombreDia == "Viernes") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 5 . " days"));
                } else if($horario->dia == "Miercoles" && $nombreDia == "Sabado") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 4 . " days"));
                }

                if($horario->dia == "Jueves" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 3 . " days"));
                } else if($horario->dia == "Jueves" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 2 . " days"));
                } else if($horario->dia == "Jueves" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 1 . " days"));
                } else if($horario->dia == "Jueves" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                } else if($horario->dia == "Jueves" && $nombreDia == "Friday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 6 . " days"));
                } else if($horario->dia == "Jueves" && $nombreDia == "Saturday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 5 . " days"));
                }

                if($horario->dia == "Viernes" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 4 . " days"));
                } else if($horario->dia == "Viernes" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 3 . " days"));
                } else if($horario->dia == "Viernes" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 2 . " days"));
                } else if($horario->dia == "Viernes" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 1 . " days"));
                } else if($horario->dia == "Viernes" && $nombreDia == "Friday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                } else if($horario->dia == "Viernes" && $nombreDia == "Saturday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 6 . " days"));
                }

                if($horario->dia == "Sabado" && $nombreDia == "Monday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 5 . " days"));
                } else if($horario->dia == "Sabado" && $nombreDia == "Tuesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 4 . " days"));
                } else if($horario->dia == "Sabado" && $nombreDia == "Wednesday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 3 . " days"));
                } else if($horario->dia == "Sabado" && $nombreDia == "Thursday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 2 . " days"));
                } else if($horario->dia == "Sabado" && $nombreDia == "Friday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 1 . " days"));
                } else if($horario->dia == "Sabado" && $nombreDia == "Saturday") {
                    $nueva_fecha = date("Y-m-d", strtotime($nueva_fecha . " + " . 0 . " days"));
                }

                for ($semana = 1; $semana <= 18; $semana++) {
                    $diasAgregados = ($semana - 1) * 7;
                    $this->storeClase($horario->idhorario, 'Semana ' .$semana, date("Y-m-d", strtotime($nueva_fecha . " + " . $diasAgregados . " days")), 0);
                }
            }

            return response()->json(["status" => true, "mensaje" => 'Clases generadas automáticamente']);
        }
    }


    function storeClase($scheduleId, $nombre, $fecha, $estado)
    {
        $item = new Subjectclass(); // Reemplaza Clase con el modelo real de tu aplicación
        $item->schedule_id = $scheduleId;
        $item->fecha = $fecha;
        $item->nombre = $nombre;
        $item->estado = $estado;

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            // El guardado fue exitoso
            return response()->json([
                "status" => true,
                "mensaje" => 'Attendance guardado'
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Attendance no guardado'
            ]);
        }
    }
}



    // $this->storeClase($horario->idhorario, 'Semana 1', $nueva_fecha, 0);
    // $this->storeClase($horario->idhorario, 'Semana 2', date("Y-m-d", strtotime($nueva_fecha . " + " . 7 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 3', date("Y-m-d", strtotime($nueva_fecha . " + " . 14 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 4', date("Y-m-d", strtotime($nueva_fecha . " + " . 21 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 5', date("Y-m-d", strtotime($nueva_fecha . " + " . 28 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 6', date("Y-m-d", strtotime($nueva_fecha . " + " . 35 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 7', date("Y-m-d", strtotime($nueva_fecha . " + " . 42 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 8', date("Y-m-d", strtotime($nueva_fecha . " + " . 49 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 9', date("Y-m-d", strtotime($nueva_fecha . " + " . 56 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 10', date("Y-m-d", strtotime($nueva_fecha . " + " . 63 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 11', date("Y-m-d", strtotime($nueva_fecha . " + " . 70 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 12', date("Y-m-d", strtotime($nueva_fecha . " + " . 77 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 13', date("Y-m-d", strtotime($nueva_fecha . " + " . 84 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 14', date("Y-m-d", strtotime($nueva_fecha . " + " . 91 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 15', date("Y-m-d", strtotime($nueva_fecha . " + " . 98 . " days")), 0);
    // $this->storeClase($horario->idhorario, 'Semana 16', date("Y-m-d", strtotime($nueva_fecha . " + " . 105 . " days")), 0);




