<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Appointment;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

class AppointmentController extends Controller
{
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.centro_medico.citas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('citas AS ci')
            ->select([
                'ci.id AS idappointment',
                'ci.asunto',
                'ci.descripcion',
                'ci.fecha',
                'ci.hora_ini',
                'ci.hora_fin',
                DB::raw("CONCAT(DATE_FORMAT(ci.fecha, '%d/%m/%Y'), ' - De ', DATE_FORMAT(ci.hora_ini, '%H:%i'), ' a ', DATE_FORMAT(ci.hora_fin, '%H:%i')) AS fecha_hora"),
                'ci.estado',
                'tci.id AS idappointmenttype',
                'tci.nombre AS tipo_cita',
                'us.id AS iduser',
                DB::raw("CONCAT(us.nroidenti, ' → ', us.nombres, ' ', us.apellido_pa, ' ', us.apellido_ma) AS usuario"),
            ])
            ->join('tipos_citas AS tci', 'tci.id', '=', 'ci.appointment_type_id')
            ->join('usuarios AS us', 'us.id', '=', 'ci.user_id')
            ->join('tipos_identificaciones AS tid', 'tid.id', '=', 'us.identificationtype_id')
            ->orderByRaw('DATE(ci.fecha) DESC, TIME(ci.hora_ini) ASC, tci.nombre')
            ->get();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Appointment();
        $item->user_id = $request->input('txt-user_id');
        $item->appointment_type_id = $request->input('txt-appointment_type_id');
        $item->asunto = $request->input('txt-asunto');
        $item->descripcion = $request->input('txt-descripcion');
        $item->fecha_ini = $request->input('txt-fecha_ini');
        $item->fecha_fin = $request->input('txt-fecha_fin');
        $item->estado = $request->input('txt-estado');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            $data = Appointment::all();
            return response()->json($data);
        }
        return  response()->json([
            "status" => false,
            "mensaje" => 'Error en request'
        ]);
    }


    public function update(Request $request, $id)
    {
        $item = Appointment::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {
            $item->appointment_type_id = $request->input('txt-appointment_type_id');
            $item->asunto = $request->input('txt-asunto');
            $item->descripcion = $request->input('txt-descripcion');
            $item->fecha_ini = $request->input('txt-fecha_ini');
            $item->fecha_fin = $request->input('txt-fecha_fin');
            $item->estado = $request->input('txt-estado');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        // Busca el registro por su ID
        $item = Appointment::find($id);

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }
}
