<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Tddocument;
use App\Models\Tdfilemovement;
use App\Models\Tdmovement;
use App\Models\User;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Mail;
use App\Mail\FinalizarEnviarCorreoTramiteDocumentario;
use App\Mail\RechazarEnviarCorreoTramiteDocumentario;

class AdmTraminteDocumentario extends Controller
{

    //verificaro
    public function indexti(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.tramitedocumentario.ti.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function indexother(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.tramitedocumentario.otros.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }else if ($userTypeAccesocombo == "3"){
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    //verificaro
    public function listadm(Request $request)
    {
        if ($request->ajax()) {
            $results = Tddocument::select(
                'td_documentos.id as iddocumento',
                'td_movimientos.id as idmovimiento',
                'u.nombres',
                'td_documentos.codigosolicitud',
                'u.nroidenti',
                'u.correo',
                'u.celular',
                'td_documentos.asunto',
                'td_archivos.nombre AS nombredoc',
                'td_archivos.ruta_archivo',
                'td_documentos.created_at',
                'td_documentos.folio',
                'td_movimientos.estado',
                'td_comprobantes.comprobante',
                'td_movimientos.areaorigen',
                'td_movimientos.areadestino',
                DB::raw('ROW_NUMBER() OVER (PARTITION BY td_documentos.student_id, td_comprobantes.comprobante, td_comprobantes.concepto ORDER BY td_documentos.created_at DESC, td_movimientos.id DESC) AS rn')
            )
                ->join('td_archivos', 'td_documentos.id', '=', 'td_archivos.tddocument_id')
                ->join('td_comprobantes', 'td_documentos.id', '=', 'td_comprobantes.tddocument_id')
                ->join('td_movimientos', 'td_documentos.id', '=', 'td_movimientos.tddocument_id')
                ->join('estudiantes as e','td_documentos.student_id', '=',  'e.id' )
                ->join('usuarios as u','e.user_id', '=','u.id' )
                ->orderBy('td_comprobantes.comprobante')
                ->orderByDesc('td_documentos.created_at')
                ->orderByDesc('td_movimientos.id')
                ->orderBy('td_movimientos.estado', 'ASC') // Ordenar por estado en ascendente
                ->get();

            // Filtrar por rn = 1
            $data = $results->where('rn', 1);

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }
    public function listadmother(Request $request)
    {
        if ($request->ajax()) {

            $objetoarea = new HeaderController();
            $dataarea = $objetoarea->DataAreaAdm();
            $dataAreaNombre = $dataarea[0]['NOMBRE'];

            $results = Tddocument::select(
                'td_documentos.id as iddocumento',
                'td_movimientos.id as idmovimiento',
                'u.nombres',
                'td_documentos.codigosolicitud',
                'u.nroidenti',
                'u.correo',
                'u.celular',
                'td_documentos.asunto',
                'td_archivos.nombre AS nombredoc',
                'td_archivos.ruta_archivo',
                'td_documentos.created_at',
                'td_documentos.folio',
                'td_movimientos.estado',
                'td_comprobantes.comprobante',
                'td_movimientos.areaorigen',
                'td_movimientos.areadestino',
                DB::raw('ROW_NUMBER() OVER (PARTITION BY td_documentos.student_id, td_comprobantes.comprobante, td_comprobantes.concepto ORDER BY td_documentos.created_at DESC, td_movimientos.id DESC) AS rn'))
                ->join('td_archivos', 'td_documentos.id', '=', 'td_archivos.tddocument_id')
                ->join('td_comprobantes', 'td_documentos.id', '=', 'td_comprobantes.tddocument_id')
                ->join('td_movimientos', 'td_documentos.id', '=', 'td_movimientos.tddocument_id')
                ->join('estudiantes as e','td_documentos.student_id', '=',  'e.id' )
                ->join('usuarios as u','e.user_id', '=','u.id' )
                ->orderBy('td_comprobantes.comprobante')
                ->orderByDesc('td_documentos.created_at')
                ->orderByDesc('td_movimientos.id')
                ->orderBy('td_movimientos.estado', 'ASC') // Ordenar por estado en ascendente
                ->get();

            // Filtrar por rn = 1
            $results2 = $results->where('rn', 1);
            $results3 = $results2->where('areadestino', $dataAreaNombre);
            $data = $results3->values();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }

    public function listadmotherfinalizado(Request $request)
    {
        if ($request->ajax()) {

            $objetoarea = new HeaderController();
            $dataarea = $objetoarea->DataAreaAdm();
            $dataAreaNombre = $dataarea[0]['NOMBRE'];

            $results = Tddocument::select(
                'td_documentos.id as iddocumento',
                'td_movimientos.id as idmovimiento',
                'u.nombres',
                'td_documentos.codigosolicitud',
                'u.nroidenti',
                'u.correo',
                'u.celular',
                'td_documentos.asunto',
                'td_archivos.nombre AS nombredoc',
                'td_archivos.ruta_archivo',
                'td_documentos.created_at',
                'td_documentos.folio',
                'td_movimientos.estado',
                'td_comprobantes.comprobante',
                'td_movimientos.areaorigen',
                'td_movimientos.areadestino',
                'td_movimientos_archivos.nombre AS namedocemitido',
                DB::raw('ROW_NUMBER() OVER (PARTITION BY td_documentos.student_id, td_comprobantes.comprobante, td_comprobantes.concepto ORDER BY td_documentos.created_at DESC, td_movimientos.id DESC) AS rn'))
                ->join('td_archivos', 'td_documentos.id', '=', 'td_archivos.tddocument_id')
                ->join('td_comprobantes', 'td_documentos.id', '=', 'td_comprobantes.tddocument_id')
                ->join('td_movimientos', 'td_documentos.id', '=', 'td_movimientos.tddocument_id')
                ->join('td_movimientos_archivos', 'td_movimientos.id', '=', 'td_movimientos_archivos.tdmovement_id')
                ->join('estudiantes as e','td_documentos.student_id', '=',  'e.id' )
                ->join('usuarios as u','e.user_id', '=','u.id' )
                ->orderBy('td_comprobantes.comprobante')
                ->orderByDesc('td_documentos.created_at')
                ->orderByDesc('td_movimientos.id')
                ->orderBy('td_movimientos.estado', 'ASC') // Ordenar por estado en ascendente
                ->get();

            // Filtrar por rn = 1
            // Filtrar por rn = 1
            $results2 = $results->where('rn', 1);
            $results3 = $results2->where('areaorigen', $dataAreaNombre);
            $data = $results3->values();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos',
        ]);
    }

    //verificaro
    public function viewDocumentoSolicitante($dni, $operacion, $codigosolicitud, $nombredoc)
    {

        $ruta = 'public/Repotramitesdocumentarios/' . $dni . '/' . $operacion . '/' . $codigosolicitud . '/' . $nombredoc;
        $file = storage_path('app/' . $ruta);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Nro_OP_' . $operacion . '_' . $cadenaAleatoria . '_DOC_' . $nombredoc . '.pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo del solictante no encontrado'], 404);
        }
    }

    //verificaro
    public function viewDocumentoEmitido($dni, $operacion, $codigosolicitud, $nombredoc)
    {

        $ruta = 'public/Repotramitesdocumentarios/' . $dni . '/' . $operacion . '/' . $codigosolicitud . '/' . $nombredoc;
        $file = storage_path('app/' . $ruta);

        if (file_exists($file)) {
            $headers = [
                'Content-Type' => 'application/pdf'
            ];
            $cadenaAleatoria = Str::random(20);
            $fileTitle = 'Nro_OP_' . $operacion . '_' . $cadenaAleatoria . '_DOC_' . $nombredoc . '.pdf';

            return response()->download($file, $fileTitle, $headers, 'inline');
        } else {
            return response()->json(['error' => 'Archivo del solictante no encontrado'], 404);
        }
    }


    //verificaro
    public function derivarTramiteDocumentario(Request $request)
    {

        $idusarioadmin = Auth::User()->id;

        $item = new Tdmovement();

        $item->tddocument_id = $request->input('id_documento');

        if ($request->input('txt_hidden_origen') === "TI") {
            $item->areaorigen = "Mesa de partes";
        } else {
            $item->areaorigen = $request->input('txt_hidden_origen');
        }

        $item->areadestino = $request->input('txt_data_areadestino');
        $item->estado = intval("2");

        // validar guardado
        if ($item->save()) {

            return response()->json(["status" => true, "mensaje" => 'Registro derivado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no deriado']);
        }
    }


    //verificaro
    public function rechazarTramiteDocumentario(Request $request)
    {

        // Busca el registro por su ID
        $id = $request->input('id_documento_mdrt');
        $solicitud = Tddocument::find($id);

        // Verifica si el registro existe
        if (!$solicitud) {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, el registro nos existe: ' . $id
            ]);
        }else if ($solicitud->delete()) {

            $areaorigen = $request->input('txt_hidden_origen');
            $email = $request->input('txt_data_correo_mdrt');
            $asunto = $request->input('txt_data_asunto_mdrt');
            $solicitante = $request->input('txt_data_solicitante_mdrt');
            $codigotd = $request->input('txt_data_codigosolicitud_mdrt');
            $motivoRechazo = $request->input('txt_detalle_rechazo');
            $dni = $request->input('id_dni_mdrt');
            $operacion = $request->input('id_operacion_mdrt');
            $nombredoc = $request->input('id_nombredoc_mdrt');

            $ruta = 'public/Repotramitesdocumentarios/' . $dni . '/' . $operacion . '/' .  $codigotd . '/' . $nombredoc;
            $rutaCarpeta = 'public/Repotramitesdocumentarios/' . $dni . '/' . $operacion . '/' .  $codigotd; // Ruta de la carpeta que quieres limpiar dentro de 'storage/app'

            $file = [
                'attachment' =>  storage_path('app/' . $ruta)
            ];

            Mail::to($email)->send(new RechazarEnviarCorreoTramiteDocumentario($areaorigen, $asunto, $solicitante,  $codigotd, $motivoRechazo, $file, $nombredoc));


            if (Storage::exists($rutaCarpeta)) {
                Storage::disk('local')->deleteDirectory($rutaCarpeta);
                $mensajeCarpeta = "Carpeta eliminada del repositorio";
            } else {
                $mensajeCarpeta = "No se ha podido eliminar Carpeta del repositorio";
            }

            return response()->json([
                "status" => true,
                "mensaje" => 'Éxito, la solicitud fue rechazado/eliminado, solitante noficado por email',
                "mensajeRepositorio" => $mensajeCarpeta
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Error, al rechazar/eliminar registro'
            ]);
        }
    }


    //verificaro
    public function finalizarTramiteStorefile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'File_documentoemitir_mdf' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
        ], [
            'File_documentoemitir_mdf.file' => 'El archivo PDF es requerido.',
            'File_documentoemitir_mdf.mimes' => 'El archivo debe ser un PDF.',
            'File_documentoemitir_mdf.max' => 'El tamaño del archivo no debe superar los 500 KB.',
        ]);

        if ($validator->fails()) {

            return response()->json([
                "status" => false,
                "mensaje" => $validator->errors(),
            ]);
        } else {
            if ($request->hasFile('File_documentoemitir_mdf')) {

                $item = new Tdmovement();

                $item->tddocument_id = $request->input('id_documento_mdf');
                $item->areaorigen = $request->input('txt_hidden_origen_mdf');
                $item->areadestino = "Solicitante";
                $item->descripcion = "";
                $item->estado = intval("3");

                // $idusuarioadmin = Auth::User()->nroidenti;
                // $item->USUARIO = $idusuarioadmin;

                if ($item->save()) {

                    $folderName = $request->input('txt_data_dni_mdf') . '/' . $request->input('cod_comprobante_mdf'). '/' . $request->input('data_codsolicitud_mdf');
                    Storage::disk('local')->makeDirectory('public/Repotramitesdocumentarios/' . $folderName); // creamos la carpeta en el disco local
                    $archivo = $request->file('File_documentoemitir_mdf'); // obtenemos el archivo
                     $archivo->storeAs('public/Repotramitesdocumentarios/' . $folderName, $archivo->getClientOriginalName()); // guardado (ruta,nombre del archivo)
                    $filePath = 'public/Repotramitesdocumentarios/' . $folderName . '/' . $archivo->getClientOriginalName(); // ruta del archivo

                    $item2 = new Tdfilemovement();

                    $idTdmovement = $item->id;

                    $item2->nro_item = 1;
                    $item2->nombre = $archivo->getClientOriginalName();
                    $item2->ruta_archivo = $filePath;
                    $item2->estado = "Finalizado";

                    $item2->tdmovement_id = $idTdmovement;
                    // guardar
                    if ($item2->save()) {

                        $areaorigen = $request->input('txt_hidden_origen_mdf');
                        $email = $request->input('txt_data_correo_mdf');
                        $asunto = $request->input('txt_data_asunto_mdf');
                        $solicitante = $request->input('txt_data_destino_mdf');
                        $codigotd = $request->input('data_codsolicitud_mdf');

                        $file = $request->file('File_documentoemitir_mdf');
                        $nombredoc =   $file->getClientOriginalName();

                        Mail::to($email)->send(new FinalizarEnviarCorreoTramiteDocumentario($areaorigen, $asunto, $solicitante,  $codigotd, $file, $nombredoc));

                        return response()->json(["status" => true, "mensaje" => 'Tramite correctamente finalizado y notificado email al solicitante']);

                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Tramite no finalizado, consultar con el adminitrador']);
                    }
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            } else {
                return response()->json([
                    'status' => false,
                    'mensaje' => 'Error de envio de archivo por HTTP'
                ]);
            }
        }
    }
}
