<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;

class LoginGoogleController extends Controller
{
    function login()
    {
        $user = Socialite::driver('google')->user();
        // $userExists = User::where('google_id', $user->id)->where('external_auth','google')->first();
        $userExists = User::where('correo', $user->email)->where('external_auth', 'google')->first();

        if ($userExists) {
            Auth::login($userExists);
        } else {
            return redirect()->route('login')->with('error', 'El correo proporcionado no está asociado con ningún usuario registrado.');
            // return response()->json([
            //     "status" => false,
            //     "message" => "El correo de usuario no esta asociado con ningun correo",
            // ]);
        }


        if (Auth::User()->estado != 1) {
            Auth::logout(); // Cerrar sesión si el usuario no está activo
            return redirect()->route('login');
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!"
            ]);
        }

        $idusertype = Auth::User()->usertype_id;
        $ruta = 'login';

        switch ($idusertype) {
            case 1:
            case 4:
            case 5:
            case 7:
                $ruta = 'home.adm.dashboard';
                session()->put('userTypeAccesocombo', 1);
                break;
            case 2:
            case 6:
                $ruta = 'home.docente.index';
                session()->put('userTypeAccesocombo', 2);
                break;
            case 3:
                $ruta = 'home.student.index';
                session()->put('userTypeAccesocombo', 3);
                break;
            default:
                break;
        }

        return redirect()->route($ruta);
    }
}
