<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\paggeAccess\PageAccessController;
use App\Http\Controllers\sidebar\SidebarController;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;

use App\Models\Firstuserlogin;
use Illuminate\Support\Facades\Session;
use App\Services\TramitesService;

class LoginController extends Controller
{

    //INYECCION DE DEPENDENCIA
    protected $tramites;

    public function __construct(TramitesService $tramites)
    {
        $this->tramites = $tramites;
    }

    public function index()
    {

        $statusmodule = $this->tramites->estadomodulotramitedocumentario();

        // Verifica si la página está habilitada
        if ($statusmodule) {
            view()->share('module', true);
        } else {
            view()->share('module', false);
        }
        return view('welcome');
    }

    public function registration()
    {
        return view('auth.register');
    }

    public function profileLogin(Request $request)
    {
        // OBTENER TIPO DE USUARIO
        $txt_usertype = $request->input('tipoUsuarioLogin');

        if (Auth::User()->estado == 1) {
            $idusertype = Auth::User()->usertype_id;

            // TIPO DE USUARIO

            // txt_usertype : administrador
            if ($txt_usertype == 'admin') {
                if ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7") {
                    $ruta = 'home.adm.dashboard'; // Redirige a la página de inicio si el rol no coincide
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json(["status" => false, "errors" => ["Acceso denegado"], "message" => "Acceso denegado!"]);
                }
            }
            // txt_usertype : docente
            if ($txt_usertype == 'docente') {
                if ($idusertype == "2" || $idusertype == "4" || $idusertype == "6" || $idusertype == "7") {
                    $ruta = 'home.docente.index'; // Redirige a la página de inicio si el rol no coincide
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json(["status" => false, "errors" => ["Acceso denegado"], "message" => "Acceso denegado!"]);
                }
            }
            // txt_usertype : alumno
            if ($txt_usertype == 'alumno') {
                if ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7") {
                    $ruta = 'home.student.index'; // Redirige a la página de inicio si el rol no coincide
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json(["status" => false, "errors" => ["Acceso denegado"], "message" => "Acceso denegado!"]);
                }
            }

            $userTypeAccesocombo = 0;

            switch ($txt_usertype) {
                case 'admin':
                    $userTypeAccesocombo = 1;
                    break;
                case 'docente':
                    $userTypeAccesocombo = 2;
                    break;
                case 'alumno':
                    $userTypeAccesocombo = 3;
                    break;
                default:
                    $userTypeAccesocombo = 0;
                    break;
            }

            $request->session()->put('userTypeAccesocombo', $userTypeAccesocombo);

            //si el usuario esta autentificado y esta activo
            return response()->json([
                "status" => true,
                "message" => "Acceso autorizado",
                "redirect" => route($ruta)
            ]);
        } else {

            Auth::logout(); // Cerrar sesión si el usuario no está activo
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!"
            ]);
        }
    }


    public function authenticateLogin(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'nroidenti' => 'required|min:6|max:12',
            'password' => 'required'
        ], [
            'nroidenti.min' => 'El código no cuenta con la cantidad de carácteres requeridos',
            'nroidenti.max' => 'El código no cuenta con la cantidad de carácteres requeridos',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false,
                "errors" => $validator->errors(),
                "message" => "Digite bien los campos!"
            ]);
        } else {

            if (Auth::attempt($request->only([
                "nroidenti",
                "password"
            ]))) {

                if (Auth::User()->estado == 1) {

                    /*
                    TIPOS DE USUARIO
                    1: admin
                    2: docente
                    3: alumno
                    4: admin-docente
                    5: admin-alumno
                    6: docente-alumno
                    7: admin-docente-alumno
                    */
                    $idusertype = Auth::User()->usertype_id;

                    $ruta = 'login';
                    $hasRedirect = false;
                    $userRoles = [];

                    switch ($idusertype) {
                        case 1:
                        case 4:
                        case 5:
                        case 7:
                            $hasRedirect = true;
                            $ruta = 'home.adm.dashboard';
                            $request->session()->put('userTypeAccesocombo', 1);
                            break;
                        case 2:
                        case 6:
                            $hasRedirect = true;
                            $ruta = 'home.docente.index';
                            $request->session()->put('userTypeAccesocombo', 2);
                            break;
                        case 3:
                            $hasRedirect = true;
                            $ruta = 'home.student.index';
                            $request->session()->put('userTypeAccesocombo', 3);
                            break;
                        default:
                            $userRoles = [];
                            break;
                    }

                    //si el usuario esta autentificado y esta activo
                    return response()->json([
                        "status" => true,
                        "message" => "Credenciales correctas",
                        "userRoles" => $userRoles,
                        "hasRedirect" => $hasRedirect,
                        "redirect" => route($ruta)
                    ]);
                } else {

                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json([
                        "status" => false,
                        "message" => "Usuario inactivo, consulte con el administrador!"
                    ]);
                }
            } else {
                return response()->json([
                    "status" => false,
                    "errors" => ["Credenciales inválidas"],
                    "message" => "Credenciales inválidas!"

                ]);
            }
        }
    }


    public function dashboard(Request $request)
    {
        //instanciando objeto del controlador sidebar
        $objeto = new SidebarController();
        //con el objeto llamamos la funcion listar modulos
        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {

            $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

            if ($result) {
                view()->share('modal_mensajeversion', false);
            } else {
                view()->share('modal_mensajeversion', true);
            }

            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            // VALIDACION TIPO DE USUARIO
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                return view('home.adm.dashboard')
                    ->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function homeDocentes(Request $request)
    {

        if (Auth::check()) {

            $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

            if ($result) {
                view()->share('modal_mensajeversion', false);
            } else {
                view()->share('modal_mensajeversion', true);
            }


            // VALIDACION TIPO DE USUARIO
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "2" && ($idusertype == "2" || $idusertype == "4" || $idusertype == "6" || $idusertype == "7")) {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 2;
                return view('home.docente.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function homeStudent(Request $request)
    {

        if (Auth::check()) {

            $result = Firstuserlogin::where('nroidenti', Auth::User()->nroidenti)->first();

            if ($result) {
                view()->share('modal_mensajeversion', false);
            } else {
                view()->share('modal_mensajeversion', true);
            }

            // VALIDACION TIPO DE USUARIO
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "3" && ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7")) {
                $tipoacceso = 3;
                return view('home.student.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function confirmarNotificacionUpdateVersion(Request $request)
    {

        $item = new Firstuserlogin();
        $item->nroidenti = Auth::User()->nroidenti;
        $item->estado = "1";
        if ($item->save()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Noticación Recibida',
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'Noticación no Recibida'
            ]);
        }
    }


    public function logout(Request $request)
    {
        Session::flush();
        Auth::logout();
        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return response()->json([
            "status" => true,
            "message" => "Cerrando sesion",
            "redirect" => route('login')
        ]);
    }

    public function changeLoginType($type, Request $request)
    {
        $txt_usertype = $type;
        $ruta_login = 'login';

        if (Auth::User()->estado == 1) {
            $idusertype = Auth::User()->usertype_id;

            // TIPO DE USUARIO

            // txt_usertype : administrador
            if ($txt_usertype == 'admin') {
                if ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7") {
                    $ruta = 'home.adm.dashboard';
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json([
                        "status" => false,
                        "message" => "Acceso denegado!",
                        "redirect" => route($ruta_login)
                    ]);
                }
            }
            // txt_usertype : docente
            if ($txt_usertype == 'docente') {
                if ($idusertype == "2" || $idusertype == "4" || $idusertype == "6" || $idusertype == "7") {
                    $ruta = 'home.docente.index';
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json([
                        "status" => false,
                        "message" => "Acceso denegado!",
                        "redirect" => route($ruta_login)
                    ]);
                }
            }
            // txt_usertype : alumno
            if ($txt_usertype == 'alumno') {
                if ($idusertype == "3" || $idusertype == "5" || $idusertype == "6" || $idusertype == "7") {
                    $ruta = 'home.student.index';
                } else {
                    Auth::logout(); // Cerrar sesión si el usuario no está activo
                    return response()->json([
                        "status" => false,
                        "message" => "Acceso denegado!",
                        "redirect" => route($ruta_login)
                    ]);
                }
            }

            $userTypeAccesocombo = 0;

            switch ($txt_usertype) {
                case 'admin':
                    $userTypeAccesocombo = 1;
                    break;
                case 'docente':
                    $userTypeAccesocombo = 2;
                    break;
                case 'alumno':
                    $userTypeAccesocombo = 3;
                    break;
                default:
                    $userTypeAccesocombo = 0;
                    break;
            }

            $request->session()->put('userTypeAccesocombo', $userTypeAccesocombo);

            //si el usuario esta autentificado y esta activo
            return response()->json([
                "status" => true,
                "message" => "Acceso autorizado",
                "redirect" => route($ruta)
            ]);
        } else {

            Auth::logout(); // Cerrar sesión si el usuario no está activo
            return response()->json([
                "status" => false,
                "message" => "Usuario inactivo, consulte con el administrador!",
                "redirect" => route($ruta_login)
            ]);
        }
    }
}
