<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\FinalizarEnviarCorreoTramiteDocumentario;
use App\Mail\RechazarEnviarCorreoTramiteDocumentario;

class TdResponderController extends Controller
{

    public function responder($td_id, Request $request)
    {

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no encontrado']);
        }

        // actualizar campos
        $tdItem->td_estado_id = 2;
        $tdItem->nota_respuesta = $request->input('nota_respuesta');

        $user = Auth::user();


        if ($request->hasFile('documento')) {

            // validar documento
            $validator = Validator::make($request->all(), [
                'documento' => 'required|file|mimes:pdf|max:2000', // Valida PDF y tamaño máximo de 2MB
            ], [
                'documento.file' => 'El archivo PDF es requerido.',
                'documento.mimes' => 'El archivo debe ser un PDF.',
                'documento.max' => 'El tamaño del archivo no debe superar los 2 MB.',
            ]);
            // documento inválido
            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "mensaje" => $validator->errors()->first(),
                ]);
            }
            // documento válido
            else {
                $tdPath = "tramites_documentarios/respuestas";

                $yearMonth = Carbon::now()->format('Ym');  // '202411'
                $dateTime = now()->format('YmdHis');  // '20241106095930'
                $fileName = "{$user->nroidenti}_{$dateTime}.pdf"; // 73223649_20241106095930.pdf

                $folderName = "{$tdPath}/{$yearMonth}";
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('documento');   // obtenemos el archivo
                $archivo->storeAs("{$folderName}", $fileName);  // guardado (ruta,nombre del archivo)

                $filePath = "{$folderName}/{$fileName}";  // ruta del archivo
                $tdItem->pdf_respuesta = $filePath;
                // guardar
                if ($tdItem->save()) {

                    // CORREO
                    $email_destino = $tdItem->correo;
                    $area = $tdItem->area->nombre;
                    $asunto = $tdItem->info_asunto;
                    $solicitante = "{$tdItem->apellido_pa} {$tdItem->apellido_ma}, {$tdItem->nombres}";
                    $codigo_nt = "{$tdItem->serie}-{$tdItem->numero}";
                    Mail::to($email_destino)->send(new FinalizarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $archivo, $fileName));
                    // CORREO

                    return response()->json(["status" => true, "mensaje" => 'Trámite Documentario respondido correctamente']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Trámite Documentario no respondido']);
                }
            }
        }

        return response()->json(["status" => false, "mensaje" => 'Documento no encontrado']);
    }
}
