<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\RoleArea;
use App\Models\Td;
use App\Models\TdMovimiento;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Mail;
use App\Mail\RechazarEnviarCorreoTramiteDocumentario;

class TdMovimientoController extends Controller
{

    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $td_id = $request->input('td_id');

            $data = $this->get_by_td_id($td_id);

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store_by_td_id($td_id, Request $request)
    {
        $area_origen_id = $request->input('area-origen');
        $area_destino_id = $request->input('area-destino');
        $nota = $request->input('nota');
        if ($area_origen_id === $area_destino_id) {
            return response()->json(["status" => false, "mensaje" => 'No se puede derivar a la misma área']);
        }

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'No existe el trámite documentario']);
        }

        $tdItem->area_id = $area_destino_id;

        $tdMovimientoItem = new TdMovimiento();
        $tdMovimientoItem->fecha = Carbon::now();
        $tdMovimientoItem->area_origen_id = $area_origen_id;
        $tdMovimientoItem->area_destino_id = $area_destino_id;
        $tdMovimientoItem->nota = $nota;
        $tdMovimientoItem->td_id = $td_id;


        // Guarda el nuevo registro en la base de datos
        if ($tdMovimientoItem->save()) {
            if ($tdItem->save()) {
                return response()->json(["status" => true, "mensaje" => 'N.T. derivada correctamente']);
            }
        }

        return response()->json(["status" => false, "mensaje" => 'N.T. no derivada']);
    }


    public function cancelar_by_td_id($td_id)
    {;

        $tdItem = Td::find($td_id);
        if (!$tdItem) {
            return response()->json(["status" => false, "mensaje" => 'No existe el trámite documentario']);
        }

        $tdItem->td_estado_id = 3;

        // Guarda el nuevo registro en la base de datos
        if ($tdItem->save()) {

            // CORREO
            $email_destino = $tdItem->correo;
            $area = $tdItem->area->nombre;
            $asunto = $tdItem->asunto;
            $solicitante = "{$tdItem->apellido_pa} {$tdItem->apellido_ma}, {$tdItem->nombres}";
            $codigo_nt = "{$tdItem->serie}-{$tdItem->numero}";
            $motivoRechazo ="Se rechaza por información incorrecta. Favor de reenviar otra NT";

            // Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo, $file, $nombredoc));
            Mail::to($email_destino)->send(new RechazarEnviarCorreoTramiteDocumentario($area, $asunto, $solicitante,  $codigo_nt, $motivoRechazo));
            // CORREO

            return response()->json(["status" => true, "mensaje" => 'N.T. cancelada correctamente']);
        }

        return response()->json(["status" => false, "mensaje" => 'N.T. no cancelada']);
    }

    // api

    public function get_by_td_id($td_id)
    {
        $data = TdMovimiento::where('td_id', $td_id)
            ->with(['area_origen', 'area_destino'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }
}
