<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class TdMisTramitesController extends Controller
{
    // public function index()
    // {
    //     return view('tramite_documentario.index');
    // }

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                // si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('tramite_documentario.mis_tramites.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                // docente
                $tipoacceso = 2;
                return view('tramite_documentario.mis_tramites.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "3") {
                // alumno
                $tipoacceso = 3;
                return view('tramite_documentario.mis_tramites.index')->with('datatipoacceso', $tipoacceso);
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_mis_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_mis_tramites()
    {
        $user = Auth::user();
        $data = Td::where('user_id', $user->id)
            ->with(['area','td_tipo','td_estado','user'])
            ->orderBy('fecha', 'desc')
            ->get();
        return $data;
    }
}
