<?php

namespace App\Http\Controllers\tramite_documentario;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use \Illuminate\Support\Facades\Auth;

use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\RoleArea;
use App\Models\Td;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;

class TdGestionarController extends Controller
{
    // public function index()
    // {
    //     return view('tramite_documentario.index');
    // }

    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                // si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('tramite_documentario.gestionar.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                // docente
                $tipoacceso = 2;
                return view('docente.horarios.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "3") {
                // alumno
                $tipoacceso = 3;
                return view('tramite_documentario.index')->with('datatipoacceso', $tipoacceso);
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function datatable(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_tramites()
    {
        $user = Auth::user();

        $usertype_id = $user->usertype_id;

        // si no es administrador
        if (!in_array($usertype_id, [1, 4, 5, 7])) {
            return [];
        }

        // admin
        $admin = $user->administradores[0];

        // get role_id
        $role_id = $admin->role_id;

        // get areas by role_id
        $areas = RoleArea::where('role_id', $role_id)->pluck('area_id')->toArray();

        // td by areas
        $data = Td::whereIn('area_id', $areas)
            ->with(['area', 'td_tipo', 'td_estado', 'user'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }


    public function index_libre(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                // si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('tramite_documentario.gestionar_libre.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                // docente
                $tipoacceso = 2;
                return view('docente.horarios.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "3") {
                // alumno
                $tipoacceso = 3;
                return view('tramite_documentario.index')->with('datatipoacceso', $tipoacceso);
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function datatable_libre(Request $request)
    {
        if ($request->ajax()) {

            $data = $this->get_tramites();

            return \Yajra\DataTables\DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    // api

    public function get_tramites_libre()
    {
        $user = Auth::user();

        $usertype_id = $user->usertype_id;

        // si no es administrador
        if (!in_array($usertype_id, [1, 4, 5, 7])) {
            return [];
        }

        // admin
        $admin = $user->administradores[0];

        // get role_id
        $role_id = $admin->role_id;

        // get areas by role_id
        $areas = RoleArea::where('role_id', $role_id)->pluck('area_id')->toArray();

        // td by areas
        $data = Td::whereIn('area_id', $areas)
            ->with(['area', 'td_tipo', 'td_estado', 'user'])
            ->orderBy('fecha', 'desc')
            ->get();

        return $data;
    }
}
