<?php

namespace App\Http\Controllers\registros_pagos;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TesoreriaReporteController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.registros_pagos.reportes.index')
                    ->with('datatipoacceso', $tipoacceso)
                    ->with('datalist', $sidebar)
                    ->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function grafica_1(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('pagos AS pa')
            ->join('estudiantes AS e', 'e.id', '=', 'pa.student_id')
            ->join('planes AS pl', 'pl.id', '=', 'e.plan_id')
            ->join('programas AS pr', 'pr.id', '=', 'pl.program_id')
            ->select(
                'pr.id AS idprograma',
                'pr.nombre AS programa',
                DB::raw('SUM(pa.monto_final) AS total')
            )
            ->whereYear('pa.fecha', $anho)
            ->whereBetween(DB::raw('MONTH(pa.fecha)'), [$mesinicio, $mesfin])
            ->groupBy('idprograma', 'programa')
            ->orderBy('programa')
            ->get();
            
            // data
            return response()->json($data);
        }
        
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function grafica_2(Request $request, $anho, $mesinicio, $mesfin, $studentId)
    {
        if ($request->ajax()) {
            
            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table('pagos as p')
            ->join('conceptos as c', 'c.id', '=', 'p.concepto_id')
            ->join('estudiantes as e', 'e.id', '=', 'p.student_id')
            ->select('c.nombre as concepto', DB::raw('SUM(p.monto_final) as total'))
            ->whereYear('fecha', $anho)
            ->whereBetween(DB::raw('MONTH(fecha)'), [$mesinicio, $mesfin])
            ->where('e.id', $studentId)
            ->groupBy('concepto')
            ->orderBy('concepto')
            ->get();
            
            // data
            return response()->json($data);
        }
        
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function ingresos_egresos(Request $request, $anho, $mesinicio, $mesfin)
    {
        if ($request->ajax()) {
            
            DB::statement("SET lc_time_names = 'es_ES'");
            // query
            $data = DB::table(DB::raw("(
                    SELECT SUM(monto_final) AS ingresos, 0 AS egresos
                    FROM pagos
                    WHERE YEAR(fecha) = ? AND MONTH(fecha) BETWEEN ? AND ?
                    
                    UNION ALL
                    
                    SELECT 0 AS ingresos, SUM(monto) AS egresos
                    FROM viaticos
                    WHERE YEAR(fecha) = ? AND MONTH(fecha) BETWEEN ? AND ?
                ) AS totales"))
                ->selectRaw('
                    CONCAT("S/. ", SUM(ingresos)) AS ingresos, 
                    CONCAT("S/. ", SUM(egresos)) AS egresos, 
                    CONCAT("S/. ", (SUM(ingresos) - SUM(egresos))) AS total')  
                ->setBindings([$anho, $mesinicio, $mesfin, $anho, $mesinicio, $mesfin])      
                ->get();
                
            // data
            return response()->json($data);
        }
        
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

}
