<?php

namespace App\Http\Controllers\planes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class DownloadExcelController extends Controller
{


    public function downloadExcelFile(Request $request)
    {
        $tipoplan = $request->input('cb_tipoplan_name');
        $nivel_formativo =  $request->input('nivel_formativo');
        if ($tipoplan === "Modular") {
            if ($nivel_formativo === "Profesional Tecnico"){
                $fileName = "public/Plantillaplanes/modular/PLANTILLA_MODULAR_PROFESIONAL.xlsx";
            }else{
                $fileName = "public/Plantillaplanes/modular/PLANTILLA_MODULAR_TECNICO.xlsx";
            }
        } else if ($tipoplan === "Transversal") {
            if ($nivel_formativo === "Profesional Tecnico"){
                $fileName = "public/Plantillaplanes/transversal/PLANTILLA_TRANSVERSAL_PROFESIONAL.xlsx";
            }else{
                $fileName = "public/Plantillaplanes/transversal/PLANTILLA_TRANSVERSAL_TECNICO.xlsx";
            }
        }

        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage

            $file = storage_path('app/'.$fileName);


            $plantilla = IOFactory::load($file);

            $plan =  $request->input('text_nombreplan_name');
            $programa =  $request->input('cboProgramaName');
            $modalidad =  $request->input('cb_modalidad_name');
            $enfoque =  $request->input('cb_enfoq_name');

            $sheet = $plantilla->getActiveSheet();
            $sheet->setCellValue('E3', $plan)
                ->setCellValue('B3', $programa)
                ->setCellValue('E4', $tipoplan);

            // if ($tipoplan === "Modular") {
            //     $sheet->setCellValue('H3', $modalidad)
            //         ->setCellValue('H4', $enfoque);
            // }

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');
            // header("Content-Length: " . filesize($carpeta . $archivo));
            // Crear un escritor y enviar el archivo al flujo de salida

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }
    //
}
