<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjob;
use App\Models\Jpjobapplication;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class AlumnoPostulacionesController extends Controller
{
    //

    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 3;
                return view('alumno.postulaciones.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }
            
            
    public function list(Request $request)
    {
        if ($request->ajax()) {
            
            $user = Auth::user();
            $studentdata = $user->students;
            $idstudent = $studentdata[0]->id;
            
            // query
            $data = DB::table('bt_solicitudes_empleos as jobapp')
                ->join('bt_trabajos as job', 'jobapp.jpjob_id', '=', 'job.id')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->join('estudiantes as stu', 'jobapp.student_id', '=', 'stu.id')
                ->join('usuarios as us', 'stu.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->select(
                    'jobapp.id as idjobapplication',
                    'jobapp.fecaplicacion',
                    'jobapp.estado as estadojobapplication',
                    'jobapp.documento',
                    'jobapp.isvisto',
                    'jobapp.feedback',
                    'jobapp.fecfeedback',
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.link',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito',
                    'stu.id as idstudent',
                    'us.id as iduser',
                    'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    'us.nombres',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular'
                )
                ->where('stu.id','=',$idstudent)
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'No se puede cargar la información']);
    }
}
