<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use \Illuminate\Support\Facades\Auth;
use App\Models\Attendance;

class AlumnoAsistenciaController extends Controller
{

    public function index(Request $request)
    {
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 3;
                return view('alumno.asistencias.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list_attendances(Request $request)
    {
        $user = Auth::user();
        $studentdata = $user->students;
        $idstudent = $studentdata[0]->id;

        $idsemester = $request->input('idsemester');
        $idsubject = $request->input('idsubject');

        if ($request->ajax()) {

            DB::statement("SET lc_time_names = 'es_ES'");

            $data = DB::table('asignaturas as a')
                ->select(
                    'ma.id AS idsubjectenrollment',
                    'a.id AS idsubject',
                    'ma.student_id AS idstudent',
                    's.id AS idsemester',
                    'ca.nombre AS clase',
                    'ca.fecha AS clase_fecha',
                    DB::raw('DATE_FORMAT(ca.fecha, "%d de %M") as fecha'),
                    DB::raw('COALESCE(asi.estado, 0) AS estado')
                )
                ->leftjoin('cursos as c', 'c.id', '=', 'a.course_id')
                ->join('semestres as s', 's.id', '=', 'a.semester_id')
                ->join('horarios as h', 'h.subject_id', '=', 'a.id')
                ->join('clases_asignaturas as ca', 'ca.schedule_id', '=', 'h.id')
                ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
                ->leftJoin('asistencias as asi', function ($join) {
                    $join->on('asi.subjectenrollment_id', '=', 'ma.id')
                        ->on('asi.subjectclass_id', '=', 'ca.id');
                })
                ->where('s.id', '=', $idsemester)
                ->where('ma.student_id', '=', $idstudent)
                ->where('a.id', '=', $idsubject)
                ->orderBy('clase_fecha', 'ASC')
                ->get();

            // datatable
            return DataTables::of($data)
            ->addIndexColumn()
            ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }


    public function store(Request $request)
    {
        $item = new Attendance();
        $item->tipo = $request->input('txt_tipo_name');
        $item->numero = $request->input('txt_numero_name');
        $item->piso = $request->input('txt_piso_name');
        $item->capacidad = $request->input('txt_capacidad_name');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
        }
    }


    public function update(Request $request, $id)
    {
        $item = Attendance::find($id);

        if (!$item) {
            $item = new Attendance();
            $item->subjectclass_id = $request->input('txt-idsubjectclass');
            $item->subjectenrollment_id = $request->input('txt-idsubjectenrollment');
            $item->estado= $request->input('txt-estado_asistencia');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        } else {
            $item->subjectclass_id = $request->input('txt-idsubjectclass');
            $item->subjectenrollment_id = $request->input('txt-idsubjectenrollment');
            $item->estado= $request->input('txt-estado_asistencia');

            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function ajax_all_subjects(Request $request, $idsemester)
    {

        $user = Auth::user();
        $studentdata = $user->students;
        $idstudent = $studentdata[0]->id;

        if ($request->ajax()) {

            $data = DB::table('asignaturas as a')
            ->select(
                'a.id AS idsubject',
                'a.seccion AS seccion',
                'c.codcurso',
                'c.nombre AS curso',
                'c.tipo',
                'c.horas',
                'c.creditos',
                'pe.numero AS periodo',
                DB::raw("CONCAT(se.anho,'-',se.numero) AS semestre")
            )
            ->join('matriculas_asignaturas as ma', 'ma.subject_id', '=', 'a.id')
            ->join('estudiantes as e', 'e.id', '=', 'ma.student_id')
            ->join('cursos as c', 'c.id', '=', 'a.course_id')
            ->join('periodos as pe', 'pe.id', '=', 'c.period_id')
            ->join('semestres as se', 'se.id', '=', 'a.semester_id')
            ->where('e.id', $idstudent)
            ->where('se.id', $idsemester)
            ->orderBy('curso')
            ->get();

            return response()->json($data);

        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
    
}







