<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Subject;
use App\Models\Teacher;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class SubjectController extends Controller
{


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.cursos.asignaturas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }



    public function list(Request $request)
    {

        $idsemester = $request->input('idsemester');
        $idperiod = $request->input('idperiod');

        if ($request->ajax()) {
            // query
            $data = DB::table('asignaturas as su')
                ->join('semestres as se', 'su.semester_id', '=', 'se.id')
                ->join('cursos as co', 'su.course_id', '=', 'co.id')
                ->join('periodos as pe', 'co.period_id', '=', 'pe.id')
                ->leftJoin('docentes as te', 'su.teacher_id', '=', 'te.id')
                ->leftJoin('usuarios as us', 'te.user_id', '=', 'us.id')
                ->select(
                    'su.id as idsubject',
                    'su.seccion',
                    'su.turno',
                    'su.cupos',
                    'su.tipo as condicion',
                    'su.nota_minima',
                    'su.silabo',
                    'su.instrumentos_evaluacion',
                    'su.teacher_id',
                    'co.codcurso',
                    'co.nombre as nomcurso',
                    'co.creditos',
                    'co.horas',
                    'co.tipo',
                    'se.id as idsemester',
                    'co.id as idcourse',
                    'pe.id as idperiod',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    DB::raw('EXISTS (
                        SELECT 1
                        FROM asignaturas
                        WHERE seccion = "B" AND course_id = co.id
                    ) as exist_sec_b'),
                    DB::raw('EXISTS (
                        SELECT 1
                        FROM asignaturas
                        WHERE seccion = "C" AND course_id = co.id
                    ) as exist_sec_c')
                )
                ->where('se.id', $idsemester)
                ->where('pe.id', $idperiod)
                ->orderBy('co.nombre', 'asc')
                ->orderBy('su.seccion', 'asc')
                ->orderBy('co.tipo', 'desc')
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function store(Request $request)
    {

        $item = new Subject();
        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->seccion = $request->input('txt-newseccion');
            $item->turno = 'M';
            $item->tipo = 'Regular';
            $item->cupos = 0;
            $item->nota_minima = '13';
            $item->course_id = $request->input('txt-idcourse');
            $item->semester_id = $request->input('txt-idsemester');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
            }
        }
    }

    public function update(Request $request, $idsubject)
    {
        $itemSubject = Subject::find($idsubject);
        // validar existencia del registro
        if (!$itemSubject) {
            abort(404);
        } else {
            // recoger datos
            $itemSubject->seccion = $request->input('txt-seccion');
            $itemSubject->turno = $request->input('txt-turno');
            $itemSubject->tipo = $request->input('txt-sub_tipo');
            $itemSubject->cupos = $request->input('txt-cupos');
            // guardar silabo
            if ($request->hasFile('txt-silabo')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-silabo' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-silabo.file' => 'El silabo PDF es requerido.',
                    'txt-silabo.mimes' => 'El silabo debe ser un PDF.',
                    'txt-silabo.max' => 'El tamaño del silabo no debe superar los 2MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "errors" => $validator->errors(),
                    ]);
                } else {
                    // $folderName = $idsubject . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory('subjects/' . $idsubject);   // creamos la carpeta en el disco local
                    // documento
                    $archivo = $request->file('txt-silabo');   // obtenemos el archivo
                    $archivo->storeAs('subjects/' . $idsubject, 'silabo.pdf');  // guardado (ruta,nombre del archivo)
                    // update bd
                    $filePath = 'subjects/' . $idsubject . '/silabo.pdf';  // ruta del archivo
                    $itemSubject->silabo = $filePath;
                }
            }
            // guardar instrumentos de evaluacion
            if ($request->hasFile('txt-instrumentos_evaluacion')) {
                // Validador
                $validator = Validator::make($request->all(), [
                    'txt-instrumentos_evaluacion' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
                ], [
                    'txt-instrumentos_evaluacion.file' => 'El instrumento de evaluación PDF es requerido.',
                    'txt-instrumentos_evaluacion.mimes' => 'El instrumento de evaluación debe ser un PDF.',
                    'txt-instrumentos_evaluacion.max' => 'El tamaño del instrumento de evaluación no debe superar los 2MB.',
                ]);

                if ($validator->fails()) {
                    return response()->json([
                        "status" => false,
                        "errors" => $validator->errors(),
                    ]);
                } else {
                    // $folderName = $idsubject . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory('subjects/' . $idsubject);   // creamos la carpeta en el disco local
                    // documento
                    $archivo = $request->file('txt-instrumentos_evaluacion');   // obtenemos el archivo
                    $archivo->storeAs('subjects/' . $idsubject, 'instrumentos_evaluacion.pdf');  // guardado (ruta,nombre del archivo)
                    // update bd
                    $filePath = 'subjects/' . $idsubject . '/instrumentos_evaluacion.pdf';  // ruta del archivo
                    $itemSubject->instrumentos_evaluacion = $filePath;
                }
            }
            // validar guardado
            if ($itemSubject->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update_teacher(Request $request, $idsubject)
    {

        // $validator = Validator::make($request->all(), [
        //     'text_codigo_programa_name' => 'required|min:5',
        //     'text_name_programa_name' => 'required',
        //     'nivel_formativo' => 'required'
        // ]);

        // if ($validator->fails()) {
        //     return response()->json([
        //         "status" => false,
        //         "mensaje" => $validator->errors()
        //     ]);
        // }

        $itemSubject = Subject::find($idsubject);
        // validar existencia del registro
        if (!$itemSubject) {
            abort(404);
        } else {
            // recoger datos
            $itemSubject->teacher_id = $request->input('txt-idteacher');
            // validar guardado
            if ($itemSubject->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function destroy($id)
    {
        $item = Subject::find($id);

        // validar existencia del registro
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        // validar eliminación
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }


    public function ajax_all_by_idplan(Request $request, $idplan, $idsemester)
    {
        if ($request->ajax()) {

            $data = Subject::join('cursos', 'cursos.id', '=', 'asignaturas.course_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('semestres', 'semestres.id', '=', 'asignaturas.semester_id')
                ->select(
                    'periodos.id AS idperiod',
                    'periodos.numero AS periodo',
                    'cursos.id AS idcourse',
                    'cursos.nombre AS curso',
                    'asignaturas.id AS idsubject',
                    'asignaturas.seccion',
                    'asignaturas.turno',
                    'asignaturas.tipo',
                    'asignaturas.nota_minima'
                )
                ->where('periodos.plan_id', $idplan)
                ->where('semestres.id', $idsemester)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('asignaturas.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function ajax_all_by_idprogram_by_idadmin(Request $request, $idprogram, $idsemester)
    {
        if ($request->ajax()) {

            // $docentedata = Auth::User()->teachers;
            // $idteacher = $docentedata[0]->id;

            $data = DB::table('asignaturas as a')
                ->join('cursos as cu', 'cu.id', '=', 'a.course_id')
                ->join('periodos as pe', 'pe.id', '=', 'cu.period_id')
                ->join('semestres as se', 'se.id', '=', 'a.semester_id')
                ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
                ->select(
                    'pe.id as idperiod',
                    'pe.numero as periodo',
                    'cu.id as idcourse',
                    'cu.nombre as curso',
                    'a.id as idsubject',
                    'a.tipo as tipo',
                    'pl.nombre as plan'
                )
                ->where('se.id', '=', $idsemester)
                // ->where('a.teacher_id', '=', $idteacher)
                ->where('pl.program_id', '=', $idprogram)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('a.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_by_idprogram_by_idteacher(Request $request, $idprogram, $idsemester)
    {
        if ($request->ajax()) {

            $docentedata = Auth::User()->teachers;
            $idteacher = $docentedata[0]->id;

            $data = DB::table('asignaturas as a')
                ->join('cursos as cu', 'cu.id', '=', 'a.course_id')
                ->join('periodos as pe', 'pe.id', '=', 'cu.period_id')
                ->join('semestres as se', 'se.id', '=', 'a.semester_id')
                ->join('planes as pl', 'pl.id', '=', 'pe.plan_id')
                ->select(
                    'pe.id as idperiod',
                    'pe.numero as periodo',
                    'cu.id as idcourse',
                    'cu.nombre as curso',
                    'a.id as idsubject',
                    'a.tipo as tipo',
                    'pl.nombre as plan'
                )
                ->where('se.id', '=', $idsemester)
                ->where('a.teacher_id', '=', $idteacher)
                ->where('pl.program_id', '=', $idprogram)
                ->orderBy('periodo', 'asc')
                ->orderBy('curso', 'asc')
                ->orderBy('a.seccion', 'asc')
                ->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }
}
