<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Semesterenrollment;
use App\Models\Studentdocument;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;

class StudentdocumentController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();
        
        $sidebar = $objeto->ListmodulosSidebar();
        
        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            
            $idusertype = Auth::User()->usertype_id;
            
            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.matricula.reservas_licencias.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function list(Request $request)
    {
        
        // $idplan = $request->input('idplan');
        
        if ($request->ajax()) {
            // query
            $data = DB::table('estudiantes AS st')
                ->select(
                    'st.id AS idstudent',
                    'st.anho_ingreso',
                    'st.estado AS estadostudent',
                    'doc.id AS idstudentdocument',
                    'doc.fecha_solicitud AS fecha_solicitud',
                    'doc.fecha_inicio AS fecha_inicio',
                    'doc.nombre AS nombredocument',
                    'doc.ruta',
                    'doc.estado as estadoregistro',
                    'doc.descripcion',
                    'us.id AS iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'us.nroidenti',
                    'us.nombres',
                    'us.apellido_pa',
                    'us.apellido_ma',
                    'us.fecnac',
                    'us.correo',
                    'us.telefono',
                    'us.celular',
                    'us.direccion',
                    'us.estado AS estadouser',
                    'pr.id AS idprogram',
                    'pr.codprograma',
                    'pr.nombre AS nombreprogram',
                    'pr.nivel_formativo',
                    'pl.id AS idplan',
                    'pl.nombre AS nombreplan',
                    'pl.tipo',
                    'pl.modalidad',
                    'pl.enfoque'
                )
                ->join('documentos_estudiantes AS doc', 'st.id', '=', 'doc.student_id')
                ->join('usuarios AS us', 'st.user_id', '=', 'us.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'us.identificationtype_id')
                ->join('planes AS pl', 'st.plan_id', '=', 'pl.id')
                ->join('programas AS pr', 'pl.program_id', '=', 'pr.id')
                ->orderBy('doc.id', 'desc')
                // ->where('pl.id', '=', $idplan)
                ->get();
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }



    public function store(Request $request)
    {

        // Validador
        $validator = Validator::make($request->all(), [
            'txt-document' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-document.file' => 'El archivo PDF es requerido.',
            'txt-document.mimes' => 'El archivo debe ser un PDF.',
            'txt-document.max' => 'El tamaño del archivo no debe superar los 500 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false, "errors" => $validator->errors(),
            ]);
        } else {
            // get data
            $idstudent = $request->input('txt-students');

            $resultado = Studentdocument::where('student_id', $idstudent)->first();
        
            if ($resultado == null) {
                // crear objeto
                $item = new Studentdocument();
                $item->fecha_solicitud = $request->input('txt-fecha_solicitud');
                $item->fecha_inicio = $request->input('txt-fecha_inicio');
                $item->nombre = $request->input('txt-nombre');
                //
                $item->ruta = "--";
                $item->descripcion = $request->input('txt-descripcion');
                $item->estado = "1";
                $item->student_id = $idstudent;
                //se utiliza en Laravel para verificar si una solicitud HTTP (por ejemplo, una solicitud POST) contiene un archivo subido con el nombre "archivo"
                if ($request->hasFile('txt-document')) {
                    $folderName = 'public/students/' .$idstudent . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-document');   // obtenemos el archivo
                    // validar guardado
                    if ($item->save()) {
                        $lastInsertId = $item->id;  // recoger id insertado
                        $archivo->storeAs($folderName, $lastInsertId . '.pdf');  // guardado (ruta,nombre del archivo)
                        // update bd
                        $filePath = $folderName . '/' . $lastInsertId . '.pdf';  // ruta del archivo
                        $item->ruta = $filePath;
                        if ($item->save()) {
                            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                        } else {
                            return response()->json(["status" => false, "mensaje" => 'Ruta no insertada correctamente']);
                        }
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                }
            } else if ($resultado->estado == 1) {
                return response()->json(["status" => false, "mensaje" => 'Solicitud Vigente, no puede realizar proceso']);
            } else if ($resultado->estado == 2) {
                return response()->json(["status" => false, "mensaje" => 'Solicutd Vencida, revisar caso']);
            } 
        }
    }


    public function update(Request $request, $idstudentdocument)
    {

        // Validador
        $validator = Validator::make($request->all(), [
            'txt-document' => 'required|file|mimes:pdf|max:500', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-document.file' => 'El archivo PDF es requerido.',
            'txt-document.mimes' => 'El archivo debe ser un PDF.',
            'txt-document.max' => 'El tamaño del archivo no debe superar los 500 KB.',
        ]);

        if ($validator->fails()) {
            return response()->json([
                "status" => false, "errors" => $validator->errors(),
            ]);
        } else {
            // get data
            $idstudent = $request->input('txt-students');

            $resultado = Studentdocument::where('student_id', $idstudent)->first();
        
            if ($resultado == null) {
                // crear objeto
                $item = Studentdocument::find($idstudentdocument);
                $item->fecha_solicitud = $request->input('txt-fecha_solicitud');
                $item->fecha_inicio = $request->input('txt-fecha_inicio');
                $item->nombre = $request->input('txt-nombre');
                //
                $item->ruta = "--";
                $item->descripcion = $request->input('txt-descripcion');
                //se utiliza en Laravel para verificar si una solicitud HTTP (por ejemplo, una solicitud POST) contiene un archivo subido con el nombre "archivo"
                if ($request->hasFile('txt-document')) {
                    $folderName = 'public/students/' .$idstudent . '/' . 'reservas_licencias';
                    Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                    $archivo = $request->file('txt-document');   // obtenemos el archivo
                    // validar guardado
                    if ($item->save()) {
                        $lastInsertId = $item->id;  // recoger id insertado
                        $archivo->storeAs($folderName, $lastInsertId . '.pdf');  // guardado (ruta,nombre del archivo)
                        // update bd
                        $filePath = $folderName . '/' . $lastInsertId . '.pdf';  // ruta del archivo
                        $item->ruta = $filePath;
                        if ($item->save()) {
                            return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                        } else {
                            return response()->json(["status" => false, "mensaje" => 'Ruta no insertada correctamente']);
                        }
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                }
            } else if ($resultado->estado == 1) {
                return response()->json(["status" => false, "mensaje" => 'Solicitud Vigente, no puede realizar proceso']);
            } else if ($resultado->estado == 2) {
                return response()->json(["status" => false, "mensaje" => 'Solicutd Vencida, revisar caso']);
            } 
        }
    }



    public function destroy($idstudentdocument)
    {
        // Busca el registro por su id
        $item = Studentdocument::find($idstudentdocument);

        // recuperar data
        $idstudent = $item->student_id;

        // Verifica si el registro existe
        if (!$item) {
            return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
        }

        $file = storage_path('app/students/' . $idstudent . '/reservas_licencias/') . $idstudentdocument . '.pdf';
        if (File::exists($file)) {
            File::delete($file);
        }

        // Elimina el registro de la base de datos
        if ($item->delete()) {
            return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
        } else {
            return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
        }
    }

    public function updateestado(Request $request, $idstudentdocument)
    {

        $item = Studentdocument::find($idstudentdocument);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->estado = $request->input('txt-estado');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Estado actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Estado no actualizado']);
            }
        }
    }
}
