<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\RoleArea;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class RoleAreaController extends Controller
{
    //


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.institucion.roles_areas.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar)->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }



    public function list(Request $request)
    {
        if ($request->ajax()) {
            $data = DB::table('roles AS r')
                ->crossJoin('areas AS a')
                ->leftJoin('roles_areas AS ra', function ($join) {
                    $join->on('r.id', '=', 'ra.role_id')
                        ->on('a.id', '=', 'ra.area_id');
                })
                ->select(
                    'r.id AS role_id',
                    'r.nombre AS role_nombre',
                    'r.descripcion AS role_descripcion',
                    'a.id AS area_id',
                    'a.nombre AS area_nombre',
                    DB::raw('IF(ra.id IS NOT NULL, 1, 0) AS permiso')
                )
                ->distinct()
                ->orderBy('r.nombre', 'ASC')
                ->orderBy('a.nombre', 'ASC')
                ->get();

            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    // habilitar permiso
    public function store(Request $request)
    {
        // query params
        $role_id = $request->query('role_id', false); // valor predeterminado
        $area_id = $request->query('area_id', false); // valor predeterminado
        if (!$role_id || !$area_id) {
            return response()->json(["status" => false, "mensaje" => 'Se necesitan los parámetros']);
        }

        // Busca el registro por su ID
        $roleAreaExist = RoleArea::where('role_id', $role_id)->where('area_id', $area_id)->get();
        if($roleAreaExist->isNotEmpty()){
            return response()->json(["status" => false, "mensaje" => 'El permiso ya existe']);
        }

        $item = new RoleArea();
        $item->role_id = $role_id;
        $item->area_id = $area_id;

        // Guarda el nuevo registro en la base de datos
        if ($item->save()) {
            return response()->json(["status" => true, "mensaje" => '☑️ Permiso habilitado']);
        } else {
            return response()->json(["status" => false, "mensaje" => '✖️ Permiso no habilitado']);
        }

    }

    // deshabilitar permiso
    public function destroy(Request $request)
    {

        // query params
        $role_id = $request->query('role_id', false); // valor predeterminado
        $area_id = $request->query('area_id', false); // valor predeterminado
        if (!$role_id || !$area_id) {
            return response()->json(["status" => false, "mensaje" => 'Se necesitan los parámetros']);
        }

        // Busca el registro por su ID
        $items = RoleArea::where('role_id', $role_id)->where('area_id', $area_id)->get();

        $mensaje = '✖️ Permiso deshabilitado';

        // Verifica si el registro existe
        if ($items->isEmpty()) {
            return response()->json(["status" => true, "mensaje" => $mensaje]);
        }

        foreach ($items as $item) {
            $item->delete();
        }
        return response()->json(["status" => true, "mensaje" => $mensaje]);
    }
}
