<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class DownloadExcelplantillaStudentsController extends Controller
{
    public function downloadExcelFile(Request $request)
    {

        $fileName = 'public/Plantillainscripciones/Plantilla_estudiantes.xlsx';
       
        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage

            $file = storage_path('app/'.$fileName);


            $plantilla = IOFactory::load($file);

             $programa =  $request->input('txt_name_programa_title');
             $plan =  $request->input('txt_name_plan_title');


            $sheet = $plantilla->getActiveSheet();
            $sheet->setCellValue('B2', $programa)
                ->setCellValue('J2', $plan);

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');
            // header("Content-Length: " . filesize($carpeta . $archivo));
            // Crear un escritor y enviar el archivo al flujo de salida

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }
}
