<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Administrator;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class AdministratorController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $objetoarea = new HeaderController();
                $dataarea = $objetoarea->DataAreaAdm();
                $tipoacceso = 1;
                $dataAreaNombre = $dataarea[0]['NOMBRE'];;
                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.seguridad.administradores.index')
                ->with('datatipoacceso', $tipoacceso)
                ->with('datalist', $sidebar)
                ->with('dataarea', $dataAreaNombre);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = Administrator::join('roles AS r', 'r.id', '=', 'administradores.role_id')
                ->join('usuarios AS u', 'u.id', '=', 'administradores.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->join('tipos_usuarios AS ut', 'ut.id', '=', 'u.usertype_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'u.ubigeo_id')
                ->join('generos AS g', 'g.id', '=', 'u.genre_id')
                ->orderBy('u.apellido_pa', 'asc')
                ->orderBy('u.apellido_ma', 'asc')
                ->orderBy('u.nombres', 'asc')
                ->get([
                    'administradores.id AS idadministrador',
                    'r.id AS idrole', 'r.nombre AS nombrerole',
                    'u.id AS iduser', 'u.nroidenti', 'u.password', 'u.nombres', 'u.apellido_pa', 'u.apellido_ma', DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'), 'u.fecnac', 'u.correo', 'u.telefono', 'u.celular', 'u.direccion', 'u.estado',
                    'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
                    'ut.id AS idusertype', 'ut.tipo',
                    'ub.id AS idubigeo', DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'), 'ub.departamento', DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'), 'ub.provincia', DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'), 'ub.distrito',
                    'g.id AS idgenre', 'g.nombre AS nombregenre'
                ]);
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }


    public function store(Request $request)
    {

        function capitalizarArray($array)
        {
            return array_map(function ($elemento) {
                return ucwords(strtolower($elemento));
            }, $array);
        }

        $r_nroidenti = $request->input('txt_nroidenti');

        $usuario = User::where('nroidenti', $r_nroidenti)->first();

        if ($usuario) {
        $administrador = Administrator::where('user_id', $usuario->id)->first();
        }

        // VALIDAR SI EXISTE UN ADMINISTRADOR CON ESE NUMERO DE IDENTIFICACION
        if ($usuario && $administrador) {
            return response()->json(["status" => false, "mensaje" => 'El administrador ya está registrado']);
        }
        // SI NO EXISTE EL ADMINISTRADOR CON EL NUMERO DE IDENTIFICACION
        else {

            // SI EL USUARIO EXISTE
            if ($usuario) {

                // setear datos
                if ($usuario->usertype_id == '2') {
                    $new_usertype_id = 4;
                } else if ($usuario->usertype_id == '3') {
                    $new_usertype_id = 5;
                } else if ($usuario->usertype_id == '6') {
                    $new_usertype_id = 7;
                }
                $usuario->usertype_id = $new_usertype_id;
                $usuario->password = $request->input('txt_password');
                $usuario->estado = $request->input('txt_estado');
                $usuario->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $usuario->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $usuario->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $usuario->fecnac = $request->input('txt_fecnac');
                $usuario->correo = $request->input('txt_correo');
                $usuario->telefono = $request->input('txt_telefono');
                $usuario->celular = $request->input('txt_celular');
                $usuario->genre_id = $request->input('txt_genre_id');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $usuario->ubigeo_id = $idubigeo;
                $usuario->direccion = $request->input('txt_direccion');

                // validar guardado
                if ($usuario->save()) {
                    // recoger id insertado
                    $userId = $usuario->id;
                    // nuevo objeto
                    $item2 = new Administrator();
                    $item2->role_id = $request->input('txt_role_id');
                    $item2->user_id = $userId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }

            // SI EL USUARIO NO EXISTE
            else {

                // nuevo objeto
                $item = new User();
                // setear datos
                $item->identificationtype_id = $request->input('txt-identificationtype');
                $item->nroidenti = $request->input('txt_nroidenti');
                $item->password = $request->input('txt_password');
                $item->estado = $request->input('txt_estado');
                $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $item->fecnac = $request->input('txt_fecnac');
                $item->correo = $request->input('txt_correo');
                $item->telefono = $request->input('txt_telefono');
                $item->celular = $request->input('txt_celular');
                $item->genre_id = $request->input('txt_genre_id');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $item->ubigeo_id = $idubigeo;
                $item->direccion = $request->input('txt_direccion');
                $item->usertype_id = '1';

                // validar guardado
                if ($item->save()) {
                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Administrator();
                    $item2->role_id = $request->input('txt_role_id');
                    $item2->user_id = $newUserId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }

                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }
        }
    }


    public function update(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->estado = $request->input('txt_estado');
            $item->genre_id = $request->input('txt_genre_id');
            $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
            $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
            $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                // nuevo objeto
                $item2 = new Administrator();

                $item2 = Administrator::where('user_id', $id)->first();
                // validar existencia del registro
                if (!$item2) {
                    abort(404);
                } else {
                    // recoger datos
                    $item2->role_id = $request->input('txt_role_id');
                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                    }
                }
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }


    public function update_password(Request $request, $id)
    {

        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }



    public function destroy($id)
    {
        // Busca el registro por su ID
        $usuario = User::find($id);
        $idusertype = $usuario->usertype_id;


        // SI SOLO ES ADMINISTRADOR
        if ($idusertype == '1') {
            // validar existencia del registro
            if (!$usuario) {
                return response()->json(["status" => false, "mensaje" => 'El registro no existe']);
            }

            // validar eliminación
            if ($usuario->delete()) {
                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
        // SI TIENE OTROS ROLES
        else {
            // eliminar registro del administrador
            $administrador = Administrator::where('user_id', $usuario->id)->first();
            if (!$administrador) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error, el registro no existe'
                ]);
            }
            // validar eliminación
            if ($administrador->delete()) {

                // actualizar tipo de usuario
                if ($idusertype == '4') {
                    $new_idusertype = 2;
                } else if ($idusertype == '5') {
                    $new_idusertype = 3;
                } else if ($idusertype == '7') {
                    $new_idusertype = 6;
                }
                $usuario->usertype_id = $new_idusertype;
                $usuario->save();

                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
    }



    public function query_data($nroidenti)
    {
        $token = 'apis-token-6194.hK3hbzBDyBDl6XqMq1idxOEs8zNDv6AJ';

        // Iniciar llamada a API
        $curl = curl_init();

        // Buscar ruc sunat
        curl_setopt_array($curl, array(
            // para usar la versión 2
            CURLOPT_URL => 'https://api.apis.net.pe/v2/reniec/dni?numero=' . $nroidenti,
            // para usar la versión 1
            // CURLOPT_URL => 'https://api.apis.net.pe/v1/ruc?numero=' . $ruc,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => 0,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'Referer: http://apis.net.pe/api-ruc',
                'Authorization: Bearer ' . $token
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // Datos de empresas según padron reducido


        return response()->json([
            "status" => true,
            "mensaje" => 'Consulta realizada',
            "data" => $response
        ]);
    }
}
