<?php

namespace App\Http\Controllers;

use App\Models\Td;
use Illuminate\Http\Request;

class TramiteDocumentarioController extends Controller
{
    public function findOneByCodigo($codigo)
    {
        if (!preg_match('/^[a-zA-Z0-9]+-[a-zA-Z0-9]+$/', $codigo)) {
            return response()->json(["status" => false, "mensaje" => 'Ingrese un formato válido']);
        }

        [$serie, $numero] = explode('-', $codigo);

        $td = Td::where('serie', $serie)->where('numero', $numero)
            ->with(['td_estado', 'td_tipo', 'programa', 'td_tipo_solicitante', 'tipo_identificacion', 'area'])
            ->first();

        // SI NO EXISTE
        if (!$td) {
            return response()->json(["status" => false, "mensaje" => 'No se encuentra registro del trámite documentario']);
        }

        return response()->json([
            "status" => true,
            "mensaje" => 'Trámite Documentario encontrado',
            "data_td" => $td
        ]);
    }

    public function index_consulta()
    {
        return view('tramite_documentario.consulta.index');
    }
}
