<?php
    $brandNavy   = '#00264B';
    $brandBlue   = '#1A4FD3';
    $brandSky    = '#4A84F7';
    $brandOrange = '#E27227';
    $brandGray   = '#F3F6F9';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Malla Curricular - <?php echo e($programa->nombre); ?></title>
    <style>
        /* Margen superior pensado para header fijo (ligeramente mayor) */
        @page { margin: 32mm 18mm 22mm 18mm; }

        * { box-sizing: border-box; }
        body {
            font-family: DejaVu Sans, sans-serif;
            color: <?php echo e($brandNavy); ?>;
            font-size: 12px;
            line-height: 1.35;
        }
        h1,h2,h3,p { margin: 0; }

        /* ===== Header: logo peque09o + texto a la derecha, sin desbordar ===== */
        .header{
            position: fixed; top: -24mm; left:0; right:0; height:22mm;
            border-bottom: 1px solid #dfe5eb;
            padding: 0 0mm;
            display: grid;
            grid-template-columns: 26mm 1fr; /* menos ancho para el logo */
            align-items: center; column-gap: 8mm;
        }
        .header .logo-wrap{
            display:flex; align-items:center; justify-content:center; height: 22mm;
        }
        .header img.logo{ display:block; height: 10mm; width:auto; } /* Logo ms peque09o */

        .header .titular{
            display:flex; flex-direction:column; justify-content:center; gap: 2px;
            overflow: hidden;   /* evita que se salga del header */
            white-space: nowrap; /* todo en una lnea */
        }
        .inst{
            font-weight: 900; font-size: 12.2px; letter-spacing: .2px;
            text-transform: uppercase; color: <?php echo e($brandNavy); ?>;
            overflow: hidden; text-overflow: ellipsis;
        }
        .subinst{
            font-weight: 600; font-size: 10.6px; color:#2b3642;
            overflow: hidden; text-overflow: ellipsis;
        }
        .program{
            margin-top: 1px;
            font-weight: 700; font-size: 10.6px; color:#0f253a;
            overflow: hidden; text-overflow: ellipsis;
        }



        /* ===== Footer: lnea arriba + badge posicionado a la derecha ===== */
        .footer{
            position: fixed;
            bottom: -14mm;
            left: 0; right: 0;
            height: 12mm;
            border-top: 1px solid #dfe5eb;
            /* quitamos flex para evitar problemas en motores PDF */
        }
                
        
        /* Badge numrico */
        .page-badge{
            position: absolute;      /* posicionamiento preciso dentro del footer */
            right: 10mm;             /* pegado a la derecha */
            top: 2mm;                /* un poquito debajo de la lnea del footer */
            width: 10mm; height: 10mm;
            border-radius: 50%;
            border: 1px solid #d5dde6;
            background: <?php echo e($brandNavy); ?>;
            color: #ffffff;
            font-weight: 800;
            font-size: 11px;
            line-height: 8mm;       /* centra verticalmente el nmero */
            text-align: center;      /* centra horizontalmente el nmero */
        }
        .page-badge::before{
            content: counter(page);  /* solo el nmero */
        }

        
        
        
        
        
        
        
        
        
        
        
        

        /* ===== Portada breve ===== */
        .cover{ margin-top: 14mm; margin-bottom: 10mm; }
        .title-big{
            font-size: 22px; font-weight: 900; margin-bottom: 4px; letter-spacing: .2px;
        }
        .subtitle{ font-size: 12px; color:#2b3642; }

        /* ===== Tablas (estilo profesional) ===== */
        table { width:100%; border-collapse: collapse; }
        caption {
            text-align:left; font-weight:800; color: <?php echo e($brandNavy); ?>;
            margin: 10px 0 6px 0; font-size: 13px;
        }
        thead th{
            background: #f4f7fb; color: #0f253a;
            border-top: 1px solid #cdd6e3; border-bottom: 1px solid #cdd6e3;
            border-left: 1px solid #dfe5eb; border-right: 1px solid #dfe5eb;
            padding: 7px 8px; font-size: 11px;
            text-transform: uppercase; letter-spacing: .3px;
        }
        tbody td{
            border: 1px solid #e3e8ee;
            padding: 6px 8px; vertical-align: top;
        }
        /* Rayado (zebra) suave y seguro para PDF */
        tbody tr:nth-child(even) td{ background:#fafbfd; }
        /* Totales */
        tfoot td{
            border: 1px solid #cfd8e3; font-weight: 800; padding: 6px 8px;
            background: #f2f5f9;
        }

        .text-right { text-align:right; }
        .text-center { text-align:center; }
        .w-num { width: 10%; }
        .w-name{ width: 70%; }
        .w-horas, .w-cred { width: 10%; }

        /* Bloques */
        .semester-block{ page-break-inside: avoid; margin-bottom: 10mm; }
        .summary-block{ margin: 6mm 0 8mm 0; page-break-inside: avoid; }
        .muted{ color:#5b6773; }
        .small{ font-size: 11px; }
        .rule{ height:1px; background:#e5ebf2; margin: 8mm 0; }
    </style>
</head>
<body>

    <!-- ===== Header ===== -->
    <div class="header">
        <div class="logo-wrap">
            <img class="logo" src="<?php echo e(asset('/images/20251021_105540__dYUBvT0O.png')); ?>" alt="Logo IESTP">
            
            <div class="titular">
                <div class="inst">INSTITUTO DE EDUCACI07N SUPERIOR TECNOL07GICO P03BLICO APARICIO POMARES</div>
                <div class="subinst">Direccin Acadmica  Programa de Estudios de <?php echo e($programa->nombre); ?></div>
            </div>
            
        </div>
        
        </div>
        
    </div>

    <!-- ===== Footer (solo nmero en crculo, derecha) ===== -->
    <div class="footer">
        <div class="page-badge"></div>
    </div>

    <!-- ===== Portada corta ===== -->
    <div class="cover">
        <div class="title-big">Malla Curricular</div>
        <div class="subtitle">
            <strong><?php echo e($programa->nombre); ?></strong>
            <?php if(optional($programa->info)->duracion): ?>  Duracin: <?php echo e($programa->info->duracion); ?> <?php endif; ?>
            <?php if(optional($programa->info)->modalidad): ?>  Modalidad: <?php echo e($programa->info->modalidad); ?> <?php endif; ?>
        </div>
    </div>

    <!-- ===== Resumen por semestre ===== -->
    <?php
        $hayCursos = collect($semestres)->some(fn($s) => !empty($s->cursos) && count($s->cursos) > 0);
    ?>
    <?php if($hayCursos): ?>
    <div class="summary-block">
        <caption><strong>Resumen por Periodo Acadmico</strong></caption>
        <table>
            <thead>
                <tr>
                    <th class="text-left">Periodo</th>
                    <th class="text-right">Total Crditos</th>
                    <th class="text-right">Total Horas</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $cursos = collect($sem->cursos ?? []);
                        $tCred  = $cursos->sum('creditos');
                        $tHoras = $cursos->sum('horas');
                    ?>
                    <tr>
                        <td><?php echo e(str_ireplace('ciclo', 'Periodo', $sem->nombre)); ?></td>
                        <td class="text-right"><?php echo e((int) $tCred); ?></td>
                        <td class="text-right"><?php echo e((int) $tHoras); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <p class="small muted" style="margin-top:4px;">Los totales se calculan sobre los cursos registrados por periodo.</p>
    </div>
    <div class="rule"></div>
    <?php endif; ?>

    <!-- ===== Tabla por semestre ===== -->
    <?php $__currentLoopData = $semestres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $cursos = collect($sem->cursos ?? []);
            $tCred  = $cursos->sum('creditos');
            $tHoras = $cursos->sum('horas');
            $nombrePeriodo = str_ireplace('ciclo', 'Periodo', $sem->nombre);
        ?>

        <div class="semester-block">
            <caption><?php echo e($nombrePeriodo); ?></caption>
            <?php if($cursos->isEmpty()): ?>
                <p class="muted">Sin cursos registrados.</p>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th class="w-num text-center">N</th>
                            <th class="w-name text-left">Asignatura / Unidad Didctica</th>
                            <th class="w-horas text-right">Horas</th>
                            <th class="w-cred text-right">Crditos</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $cursos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="text-center"><?php echo e($i + 1); ?></td>
                                <td><?php echo e($c->nombre); ?></td>
                                <td class="text-right"><?php echo e((int) ($c->horas ?? 0)); ?></td>
                                <td class="text-right"><?php echo e((int) ($c->creditos ?? 0)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="2" class="text-right">Totales del <?php echo e(strtolower($nombrePeriodo)); ?></td>
                            <td class="text-right"><?php echo e((int) $tHoras); ?></td>
                            <td class="text-right"><?php echo e((int) $tCred); ?></td>
                        </tr>
                    </tfoot>
                </table>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>
</html><?php /**PATH /home/istapidex/public_html/resources/views/programas/pdf/malla.blade.php ENDPATH**/ ?>