
<style>
    :root {
        --color-primario-p1: <?php echo e($colores['color-primario-p1'] ?? '#00264B'); ?>;
        --color-primario-p2: <?php echo e($colores['color-primario-p2'] ?? '#1A4FD3'); ?>;
        --color-primario-p3: <?php echo e($colores['color-primario-p3'] ?? '#4A84F7'); ?>;
        --color-secundario-s1: <?php echo e($colores['color-secundario-s1'] ?? '#E27227'); ?>;
        --color-neutral: <?php echo e($colores['color-neutral'] ?? '#DDE3E8'); ?>;
    }
</style>

<style>
    /* Hover botones de barra desktop con tu neutral */
    .hdr-btn {
        transition: background-color .2s ease, color .2s ease;
    }

    .hdr-btn:hover {
        background-color: var(--color-neutral);
    }

    /* Panel desplegable */
    .menu-panel {
        background-color: #ffffff;
        box-shadow: 0 10px 15px -3px rgba(0, 0, 0, .1), 0 4px 6px -2px rgba(0, 0, 0, .05);
        border-radius: .375rem;
    }

    /* Links del panel: base gris 700; hover naranja corporativo */
    .menu-link {
        color: #374151;
        transition: background-color .15s ease, color .15s ease;
    }

    .menu-link:hover {
        background-color: color-mix(in srgb, var(--color-secundario-s1) 10%, #ffffff);
        color: var(--color-secundario-s1);
    }
</style>

<style>
    .link-institucional {
        color: var(--color-neutral);
        transition: color 0.2s;
    }
    .link-institucional:hover {
        color: var(--color-secundario-s1);
    }

</style>



<!-- Header principal -->
<header id="site-header" class="fixed top-0 left-0 right-0 shadow-md z-40 md:pl-20" style="background-color:#ffffff;">
    <div class="container mx-auto">
        <div class="flex items-center justify-between h-16 px-4">
            <!-- Logo -->
            <div class="flex items-center space-x-2">
                <a href="<?php echo e(url('/')); ?>">
                    <img src="<?php echo e($siteLogoUrl); ?>" alt="Logo NOVA" class="h-14 w-auto">
                </a>
            </div>

            <!-- Botón menú móvil -->
            <button
              id="mobile-menu-button"
              class="p-2 md:hidden"
              onclick="toggleMobileMenu()"
              aria-controls="mobile-menu"
              aria-expanded="false"
              aria-label="Abrir menú de navegación"
            >
              <i data-lucide="menu" class="h-6 w-6" id="menu-icon"></i>
              <i data-lucide="x" class="h-6 w-6 hidden" id="close-icon"></i>
            </button>


            <!-- Navegación desktop -->
            <nav class="hidden md:flex items-center space-x-1 text-sm">

                
                <?php if(header_on('Inicio')): ?>
                    <a href="<?php echo e(url('/')); ?>">
                        <button class="px-3 py-2 rounded-md font-medium hdr-btn">Inicio</button>
                    </a>
                <?php endif; ?>

                
                <?php if(header_on('Nosotros')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Nosotros <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = submodulos_activos_de('Nosotros'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Nosotros', $s['nombre']);
                                        $blank = sub_blank('Nosotros', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Programas de estudio')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Programas de estudio <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = $programasMenu ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('programas.show.nombre', \Illuminate\Support\Str::slug($p->nombre, '_'))); ?>"
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($p->nombre); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php $__currentLoopData = submodulos_activos_de('Programas de estudio'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Programas de estudio', $s['nombre']);
                                        $blank = sub_blank('Programas de estudio', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Admisión y matrícula')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Admisión y matrícula <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = submodulos_activos_de('Admisión y matrícula'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Admisión y matrícula', $s['nombre']);
                                        $blank = sub_blank('Admisión y matrícula', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Transparencia')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Transparencia <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = submodulos_activos_de('Transparencia'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Transparencia', $s['nombre']);
                                        $blank = sub_blank('Transparencia', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Trámite')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Trámite <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = submodulos_activos_de('Trámite'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Trámite', $s['nombre']);
                                        $blank = sub_blank('Trámite', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Servicios')): ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Servicios <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                <?php $__currentLoopData = submodulos_activos_de('Servicios'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $href = sub_url('Servicios', $s['nombre']);
                                        $blank = sub_blank('Servicios', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Otras páginas')): ?>
                    <?php
                        $ya = [];
                        $norm = function ($s) {
                            return \Illuminate\Support\Str::of($s ?? '')
                                ->lower()
                                ->ascii()
                                ->squish()
                                ->__toString();
                        };
                    ?>
                    <div class="relative group">
                        <button class="px-3 py-2 rounded-md font-medium flex items-center hdr-btn">
                            Otras páginas <i data-lucide="chevron-down" class="ml-1 h-4 w-4"></i>
                        </button>
                        <div
                            class="absolute left-0 mt-1 w-64 rounded-md overflow-hidden z-50 opacity-0 invisible
                        group-hover:opacity-100 group-hover:visible transition-all duration-300 menu-panel">
                            <div class="py-2">
                                
                                <?php $__currentLoopData = submodulos_activos_de('Otras páginas'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $key = $norm($s['nombre']);
                                        if (isset($ya[$key])) {
                                            continue;
                                        }
                                        $ya[$key] = true;
                                        $href = sub_url('Otras páginas', $s['nombre']);
                                        $blank = sub_blank('Otras páginas', $s['nombre']);
                                    ?>
                                    <a href="<?php echo e($href); ?>"
                                        <?php if($blank): ?> target="_blank" <?php endif; ?>
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($s['nombre']); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <?php $__empty_1 = true; $__currentLoopData = ($linksInstitucionales ?? collect()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $key = $norm($link->nombre);
                                        if (isset($ya[$key])) {
                                            continue;
                                        }
                                        $ya[$key] = true;
                                    ?>
                                    <a href="<?php echo e($link->enlace); ?>" target="_blank" rel="noopener"
                                        class="block px-4 py-2 text-sm menu-link">
                                        <?php echo e($link->nombre); ?>

                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <span class="block px-4 py-2 text-sm" style="color:var(--color-neutral);">Sin enlaces</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(header_on('Contáctanos')): ?>
                    <a href="<?php echo e(url('/contacto')); ?>">
                        <button class="px-3 py-2 rounded-md font-medium hdr-btn">Contáctanos</button>
                    </a>
                <?php endif; ?>
            </nav>
        </div>
    </div>
</header>

<!-- Menú móvil -->
<div id="mobile-menu" class="fixed inset-0 z-30 pt-16 md:hidden overflow-y-auto hidden"
    style="background-color:#ffffff;">
    <div class="p-4">
        <nav class="flex flex-col">

            
            <?php if(header_on('Inicio')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button class="flex items-center justify-between w-full py-4 text-left">
                        <a href="<?php echo e(url('/')); ?>"><span class="font-medium">Inicio</span></a>
                    </button>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Nosotros')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('nosotros')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Nosotros</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform" id="nosotros-chevron"></i>
                    </button>
                    <div id="nosotros-submenu" class="pl-4 pb-2 hidden">
                        <?php $__currentLoopData = submodulos_activos_de('Nosotros'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = sub_url('Nosotros', $s['nombre']);
                                $blank = sub_blank('Nosotros', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Programas de estudio')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('programas')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Programas de estudio</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform"
                            id="programas-chevron"></i>
                    </button>
                    <div id="programas-submenu" class="pl-4 pb-2 hidden">
                        <?php $__currentLoopData = $programasMenu ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <a href="<?php echo e(route('programas.show.nombre', \Illuminate\Support\Str::slug($p->nombre, '_'))); ?>" class="block py-2 text-sm"
                                style="color:var(--color-primario-p1);"><?php echo e($p->nombre); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = submodulos_activos_de('Programas de estudio'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = sub_url('Programas de estudio', $s['nombre']);
                                $blank = sub_blank('Programas de estudio', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Admisión y matrícula')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('admision')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Admisión y matrícula</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform" id="admision-chevron"></i>
                    </button>
                    <div id="admision-submenu" class="pl-4 pb-2 hidden">
                        <?php $__currentLoopData = submodulos_activos_de('Admisión y matrícula'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = sub_url('Admisión y matrícula', $s['nombre']);
                                $blank = sub_blank('Admisión y matrícula', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Transparencia')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('transparencia')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Transparencia</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform"
                            id="transparencia-chevron"></i>
                    </button>
                    <div id="transparencia-submenu" class="pl-4 pb-2 hidden">
                        <?php $__currentLoopData = submodulos_activos_de('Transparencia'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = sub_url('Transparencia', $s['nombre']);
                                $blank = sub_blank('Transparencia', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Servicios')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('servicios')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Servicios</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform"
                            id="servicios-chevron"></i>
                    </button>
                    <div id="servicios-submenu" class="pl-4 pb-2 hidden">
                        <?php $__currentLoopData = submodulos_activos_de('Servicios'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $href = sub_url('Servicios', $s['nombre']);
                                $blank = sub_blank('Servicios', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Otras páginas')): ?>
                <?php
                    $ya = [];
                    $norm = function ($s) {
                        return \Illuminate\Support\Str::of($s ?? '')
                            ->lower()
                            ->ascii()
                            ->squish()
                            ->__toString();
                    };
                ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button onclick="toggleSubmenu('otras')"
                        class="flex items-center justify-between w-full py-4 text-left">
                        <span class="font-medium">Otras páginas</span>
                        <i data-lucide="chevron-down" class="h-5 w-5 transition-transform" id="otras-chevron"></i>
                    </button>
                    <div id="otras-submenu" class="pl-4 pb-2 hidden">
                        
                        <?php $__currentLoopData = submodulos_activos_de('Otras páginas'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $key = $norm($s['nombre']);
                                if (isset($ya[$key])) {
                                    continue;
                                }
                                $ya[$key] = true;
                                $href = sub_url('Otras páginas', $s['nombre']);
                                $blank = sub_blank('Otras páginas', $s['nombre']);
                            ?>
                            <a href="<?php echo e($href); ?>" <?php if($blank): ?> target="_blank" <?php endif; ?>
                                class="block py-2 text-sm" style="color:var(--color-primario-p1);"><?php echo e($s['nombre']); ?></a>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        
                        <?php $__empty_1 = true; $__currentLoopData = ($linksInstitucionales ?? collect()); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $key = $norm($link->nombre);
                                if (isset($ya[$key])) {
                                    continue;
                                }
                                $ya[$key] = true;
                            ?>

                            <a href="<?php echo e($link->enlace); ?>" target="_blank" rel="noopener"
                                class="block py-2 text-sm link-institucional" style="color:var(--color-primario-p1);">
                                <?php echo e($link->nombre); ?>

                            </a>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <span class="block py-2 text-sm" style="color:var(--color-primario-p1);">Sin enlaces</span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endif; ?>

            
            <?php if(header_on('Contáctanos')): ?>
                <div class="border-b" style="border-color: var(--color-neutral);">
                    <button class="flex items-center justify-between w-full py-4 text-left">
                        <a href="<?php echo e(url('/contacto')); ?>"><span class="font-medium">Contáctanos</span></a>
                    </button>
                </div>
            <?php endif; ?>

        </nav>

    </div>
</div>
<?php /**PATH /home/istapidex/public_html/resources/views/header.blade.php ENDPATH**/ ?>