
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Inversiones y Recursos</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <link rel="stylesheet" href="/css/web/inversiones.css">
</head>

<body class="min-h-screen bg-gradient-to-br from-[#DDE3E8] to-white text-gray-900 scroll-smooth"
      style="background-image: linear-gradient(to bottom right, var(--color-neutral), white);">

    
    <div class="fixed top-0 left-0 h-full w-20 bg-[#00264B] text-white z-50 hidden md:flex flex-col items-center py-8"
         style="background-color: var(--color-primario-p1);">
        <div class="mb-12">
            <div class="bg-[#E27227] p-2 rounded-full" style="background-color: var(--color-secundario-s1);">
                <i data-lucide="graduation-cap" class="h-6 w-6"></i>
            </div>
        </div>
        <nav class="flex flex-col items-center space-y-8 flex-grow" id="sidebar-nav">
            <?php $__currentLoopData = [
                ['hero', 'Inicio'],
                ['inversiones', 'Inversiones y reinversiones'],
                ['infraestructura', 'Obras de infraestructura'],
                ['donaciones', 'Donaciones y aportes']
            ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as [$id, $title]): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <button onclick="scrollToSection('<?php echo e($id); ?>')"
                        class="nav-dot relative w-12 h-12 flex items-center justify-center hover:bg-[#1A4FD3]/20 rounded-full transition-all"
                        title="<?php echo e($title); ?>">
                    <div class="h-3 w-3 rounded-full bg-white"></div>
                </button>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </nav>
    </div>

    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php
        $img = fn($path) => blank($path)
            ? asset('images/no-photo.jpg')
            : asset(ltrim(ltrim($path, '/'), './'));
        $pdf = fn($inv) => route('web.inversiones.file', $inv);
    ?>

    <main class="md:pl-20">
        
        <section id="hero"
                 class="py-20 bg-gradient-to-br from-[#00264B] via-[#1A4FD3] to-[#4A84F7] text-white"
                 style="background-image: linear-gradient(to bottom right, var(--color-primario-p1), var(--color-primario-p2), var(--color-primario-p3));">
            <div class="container mx-auto pr-4 pl-10 sm:pl-14 lg:pl-20">
                <div class="max-w-6xl mx-auto text-center">
                    <h1 class="text-5xl md:text-7xl font-black mb-6">Inversiones y Recursos</h1>
                    <p class="text-xl md:text-2xl text-white/85 max-w-4xl mx-auto">
                        Información transparente sobre nuestras inversiones, recursos y rendición de cuentas.
                    </p>
                </div>
            </div>
        </section>

        
        <?php $__currentLoopData = [
            1 => ['icon' => 'trending-up', 'color' => '#1A4FD3', 'title' => 'Inversiones y Reinversiones', 'bg' => 'white', 'id' => 'inversiones'],
            2 => ['icon' => 'building-2', 'color' => '#1A4FD3', 'title' => 'Obras de Infraestructura', 'bg' => 'var(--color-neutral)', 'id' => 'infraestructura'],
            3 => ['icon' => 'heart', 'color' => '#E27227', 'title' => 'Donaciones y Aportes', 'bg' => 'white', 'id' => 'donaciones']
        ]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo => $cfg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <section id="<?php echo e($cfg['id']); ?>" class="py-20" style="background-color: <?php echo e($cfg['bg']); ?>;">
                <div class="container mx-auto px-6 lg:pl-12">
                    
                    <div class="mb-12 flex items-center gap-4">
                        <div class="p-3 rounded-xl" style="background-color: <?php echo e($cfg['color']); ?>20;">
                            <i data-lucide="<?php echo e($cfg['icon']); ?>" class="h-8 w-8"
                               style="color: <?php echo e($cfg['color']); ?>"></i>
                        </div>
                        <h2 class="text-4xl font-black" style="color: var(--color-primario-p1);">
                            <?php echo e($cfg['title']); ?>

                        </h2>
                    </div>

                    <?php if($groups[$tipo]->isEmpty()): ?>
                        <div class="rounded-2xl border border-gray-200 bg-white p-8 text-center text-gray-600 ml-16 md:ml-28 lg:ml-40">
                            Aún no hay registros para esta sección.
                        </div>
                    <?php else: ?>
                        
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 ml-16 md:ml-28 lg:ml-40">
                            <?php $__currentLoopData = $groups[$tipo]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="card relative bg-white border border-gray-200 rounded-lg overflow-hidden hover:shadow-lg transition-all cursor-pointer"
                                     onclick="openCard(event, '<?php echo e($pdf($inv)); ?>')">

                                    <div class="aspect-video overflow-hidden">
                                        <img src="<?php echo e($img($inv->imagen)); ?>" alt="<?php echo e($inv->nombre); ?>"
                                             class="w-full h-full object-cover">
                                    </div>

                                    <div class="p-6 pb-16">
                                        <h3 class="text-xl font-bold mb-3" style="color: var(--color-primario-p1);">
                                            <?php echo e($inv->nombre); ?>

                                        </h3>

                                        <p class="text-gray-700 text-justify"
                                           style="display:-webkit-box;-webkit-line-clamp:6;-webkit-box-orient:vertical;overflow:hidden;">
                                            <?php echo e($inv->descripcion); ?>

                                        </p>
                                    </div>

                                    
                                    <?php if(!empty($inv->documento)): ?>
                                        <a href="<?php echo e($pdf($inv)); ?>" target="_blank" rel="noopener"
                                           class="absolute bottom-4 right-4 inline-flex items-center gap-2 px-4 py-2 rounded-xl border border-transparent
                                                  bg-[#1A4FD3] text-white font-semibold hover:opacity-95 focus:outline-none
                                                  focus:ring-2 focus:ring-offset-2 focus:ring-[#1A4FD3]"
                                           style="background-color: var(--color-primario-p2);"
                                           onclick="event.stopPropagation();">
                                            <i data-lucide='file-text' class='h-4 w-4'></i>
                                            Ver Documento
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </section>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </main>

    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        lucide.createIcons();

        function scrollToSection(id) {
            const el = document.getElementById(id);
            if (!el) return;
            const y = el.getBoundingClientRect().top + window.pageYOffset - 80;
            window.scrollTo({ top: y, behavior: "smooth" });
        }

        function openCard(e, url) {
            if (!e.target.closest('a')) window.open(url, '_blank');
        }
    </script>
</body>
</html>
<?php /**PATH /home/istapidex/public_html/resources/views/transparencia/inversiones.blade.php ENDPATH**/ ?>