
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Contáctanos</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Lucide para los pictogramas azules -->
    <script defer src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <!-- Font Awesome para Redes Sociales -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
    <link rel="stylesheet" href="/css/web/contacto.css">
</head>

<body class="min-h-screen font-sans scroll-smooth"
    style="background: var(--color-neutral); color: var(--color-primario-p1);">
    
    <div class="fixed top-0 left-0 h-full w-20 text-white z-50 hidden md:flex flex-col items-center py-8"
        style="background: var(--color-primario-p1);">
        <div class="mb-12">
            <a href="<?php echo e(url('/')); ?>">
                <div class="text-white p-2 rounded-full" style="background: var(--color-secundario-s1);">
                    <i data-lucide="graduation-cap" class="h-6 w-6"></i>
                </div>
            </a>
        </div>
        <nav class="flex flex-col items-center space-y-8 flex-grow">
            <button onclick="scrollToSection('contacto-principal')"
                class="w-12 h-12 flex items-center justify-center rounded-full"
                onmouseenter="this.style.background='var(--color-primario-p2)'"
                onmouseleave="this.style.background='transparent'">
                <div class="h-3 w-3 rounded-full bg-white"></div>
            </button>
            <button onclick="scrollToSection('formulario')"
                class="w-12 h-12 flex items-center justify-center rounded-full"
                onmouseenter="this.style.background='var(--color-primario-p2)'"
                onmouseleave="this.style.background='transparent'">
                <div class="h-3 w-3 rounded-full bg-white"></div>
            </button>
            <button onclick="scrollToSection('ubicacion')"
                class="w-12 h-12 flex items-center justify-center rounded-full"
                onmouseenter="this.style.background='var(--color-primario-p2)'"
                onmouseleave="this.style.background='transparent'">
                <div class="h-3 w-3 rounded-full bg-white"></div>
            </button>
        </nav>
    </div>

    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main class="md:pl-20 pt-16">
        
        <section class="py-20 relative overflow-hidden">
            <div class="absolute inset-0 z-0">
                <div class="absolute inset-0"
                    style="background-image: linear-gradient(135deg,
                        color-mix(in srgb, var(--color-primario-p2) 10%, transparent),
                        color-mix(in srgb, var(--color-primario-p3) 10%, transparent)
                    );">
                </div>
            </div>
            <div class="container mx-auto px-4 md:px-12 z-10 relative text-center">
                <h1 class="text-5xl md:text-7xl font-bold mb-6">
                    <span style="color: var(--color-primario-p2);">Contáctanos</span>
                </h1>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                    ¿Tienes preguntas sobre nuestros programas? Estamos aquí para ayudarte.
                </p>
            </div>
        </section>

        
        <section id="contacto-principal" class="py-20 bg-white">
            <div class="container mx-auto px-4 md:px-12">
                <div class="mb-16">
                    <h2 class="text-4xl md:text-5xl font-bold mt-2">Información de Contacto</h2>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
                    
                    <div class="contact-card rounded-3xl p-8 text-center shadow-lg"
                        style="background-image: linear-gradient(135deg, var(--color-neutral), #ffffff);">
                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6"
                            style="background: var(--color-primario-p2);">
                            <i data-lucide="phone" class="h-8 w-8 text-white"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-4">Teléfono</h3>
                        <p class="font-semibold text-lg" style="color: var(--color-primario-p2);">
                            <?php echo e($info->telefono_principal ?? '—'); ?>

                        </p>
                    </div>
                
                    
                    
                
                    
                    <div class="contact-card rounded-3xl p-8 text-center shadow-lg"
                        style="background-image: linear-gradient(135deg, var(--color-neutral), #ffffff);">
                        <div class="w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6"
                            style="background: var(--color-primario-p1);">
                            <i data-lucide="mail" class="h-8 w-8 text-white"></i>
                        </div>
                        <h3 class="text-xl font-bold text-gray-900 mb-4">Correo Electrónico</h3>
                        <p class="font-semibold text-sm">
                            <a href="mailto:<?php echo e($info->correo ?? ''); ?>" style="color: var(--color-primario-p2);">
                                <?php echo e($info->correo ?? '—'); ?>

                            </a>
                        </p>
                    </div>
                
                    
                    
                

                    
                    <div class="contact-card rounded-3xl p-8 text-center shadow-xl relative overflow-hidden"
                        style="background: linear-gradient(135deg, var(--color-primario-p2), var(--color-primario-p3)); color: white;">
                        
                        
                        <div class="absolute inset-0 opacity-20 bg-[radial-gradient(circle_at_center,white,transparent_70%)]"></div>
                    
                        <div class="relative z-10">
                            <div class="w-16 h-16 rounded-2xl flex items-center justify-center mx-auto mb-6 bg-white/20 backdrop-blur-sm">
                                <i class="fa-solid fa-bullhorn text-white text-3xl"></i>
                            </div>
                            <h3 class="text-2xl font-bold mb-4 drop-shadow-lg">Síguenos en Redes Sociales</h3>
                            <p class="text-white/80 text-sm mb-6 max-w-xs mx-auto">
                                Conéctate con nosotros en nuestras redes oficiales.
                            </p>
                    
                            <div class="flex flex-wrap justify-center gap-4">
                                <?php $__empty_1 = true; $__currentLoopData = $redes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <a href="<?php echo e($r->enlace); ?>" target="_blank" rel="noopener noreferrer"
                                        class="social-icon w-12 h-12 rounded-xl flex items-center justify-center text-white transition-all duration-300"
                                        style="background: white; color: var(--color-primario-p2);"
                                        onmouseenter="this.style.background='var(--color-primario-p1)'; this.style.color='white';"
                                        onmouseleave="this.style.background='white'; this.style.color='var(--color-primario-p2)';"
                                        title="<?php echo e($r->nombre); ?>">
                                        <i class="<?php echo e($r->icono); ?> text-2xl"></i>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <p class="text-white/70 text-sm">Pronto publicaremos nuestras redes.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                    
                </div>

                
            
                
                
                    

                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
            </div>
        </section>

        
        <section id="formulario" class="py-20" style="background: var(--color-neutral);">
            <div class="container mx-auto px-4 md:px-12">
                <div class="mb-12">
                    <h2 class="text-4xl md:text-5xl font-bold mt-2">Envíanos un Mensaje</h2>
                </div>

                <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
                    <div class="bg-white rounded-3xl p-8 md:p-12 shadow-lg">
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        
                    <!-------------------------------------------- FORMULARIO -------------------------------------------->   
                    <?php if($errors->any()): ?>
                      <div class="max-w-3xl mx-auto mb-6 rounded-xl p-4 bg-red-50 text-red-700 border border-red-200">
                        <div class="font-semibold mb-2">No se pudo enviar:</div>
                        <ul class="list-disc ps-5">
                          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($e); ?></li>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                      </div>
                    <?php endif; ?>
                    
                    <form class="space-y-6" method="POST" action="<?php echo e(route('mensajes_contacto.store_public')); ?>">
                      <?php echo csrf_field(); ?>
                    
                      
                      <input type="text" name="website" tabindex="-1" autocomplete="off" class="hidden" aria-hidden="true">
                    
                      <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                          <label class="block text-sm font-semibold text-gray-700 mb-2">Nombre *</label>
                          <input
                            type="text" name="nombre" value="<?php echo e(old('nombre')); ?>" required
                            class="w-full px-4 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2"
                            style="--tw-ring-color: var(--color-primario-p2);">
                          <?php $__errorArgs = ['nombre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    
                        <div>
                          <label class="block text-sm font-semibold text-gray-700 mb-2">Apellido *</label>
                          <input
                            type="text" name="apellido" value="<?php echo e(old('apellido')); ?>" required
                            class="w-full px-4 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2"
                            style="--tw-ring-color: var(--color-primario-p2);">
                          <?php $__errorArgs = ['apellido'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                      </div>
                    
                      <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Correo *</label>
                        <input
                          type="email" name="correo" value="<?php echo e(old('correo')); ?>" required
                          class="w-full px-4 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2"
                          style="--tw-ring-color: var(--color-primario-p2);">
                        <?php $__errorArgs = ['correo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      </div>
                    
                      <div>
                        <label class="block text-sm font-semibold text-gray-700 mb-2">Mensaje *</label>
                        <textarea
                          name="mensaje" rows="5" required
                          class="w-full px-4 py-3 border border-gray-200 rounded-xl focus:outline-none focus:ring-2 resize-none"
                          style="--tw-ring-color: var(--color-primario-p2);"><?php echo e(old('mensaje')); ?></textarea>
                        <?php $__errorArgs = ['mensaje'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <p class="mt-1 text-sm text-red-600"><?php echo e($message); ?></p> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      </div>
                    
                      <button type="submit"
                        class="w-full text-white font-semibold py-4 px-8 rounded-xl transition-colors"
                        style="background: var(--color-primario-p2);"
                        onmouseenter="this.style.background='var(--color-primario-p3)'"
                        onmouseleave="this.style.background='var(--color-primario-p2)'">
                        Enviar Mensaje
                      </button>
                    </form>
                    <!-------------------------------------------- FORMULARIO -------------------------------------------->   
                        
                        
                        
                        
                        
                        
                    </div>

                    
                    <div class="space-y-8">
                        <div class="bg-white rounded-3xl p-8 shadow-lg">
                            <h3 class="text-2xl font-bold text-gray-900 mb-6">¿Por qué elegirnos?</h3>
                            <ul class="space-y-4 text-gray-700">
                                <li class="flex items-start">
                                    <i data-lucide="award" class="h-5 w-5 mr-3"
                                        style="color: var(--color-primario-p2);"></i>
                                    Excelencia Académica
                                </li>
                                <li class="flex items-start">
                                    <i data-lucide="users" class="h-5 w-5 mr-3"
                                        style="color: var(--color-primario-p2);"></i>
                                    Atención Personalizada
                                </li>
                                <li class="flex items-start">
                                    <i data-lucide="globe" class="h-5 w-5 mr-3"
                                        style="color: var(--color-primario-p2);"></i>
                                    Proyección Internacional
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <!------------------------------------------------ FORMULARIO ------------------------------------------------>
    
    <?php if(session('success')): ?>
    <div id="contactSuccessModal"
         class="fixed inset-0 z-[100] flex items-center justify-center bg-black/40 backdrop-blur-sm px-4">
      <div class="relative w-full max-w-md rounded-2xl bg-white shadow-2xl overflow-hidden animate-fadeIn">
    
        
        <div class="flex items-center gap-3 px-6 py-4"
             style="background: var(--color-primario-p2); color: #fff;">
          <div class="flex h-10 w-10 items-center justify-center rounded-full bg-white/20">
            <i class="fa-solid fa-check text-white text-xl"></i>
          </div>
          <h3 class="text-lg font-bold">¡Mensaje enviado correctamente!</h3>
        </div>
    
        
        <div class="px-6 py-5 text-gray-700 leading-relaxed">
          <p><?php echo e(session('success')); ?></p>
          <p class="mt-2 text-sm text-gray-500">
            Nuestro equipo revisará tu mensaje y se comunicará contigo a la brevedad.
          </p>
        </div>
    
        
        <div class="flex flex-wrap justify-end gap-2 px-6 pb-6">
          <button type="button"
                  id="closeSuccessModal"
                  class="inline-flex items-center rounded-xl px-4 py-2 text-white font-medium transition-colors"
                  style="background: var(--color-primario-p2);"
                  onmouseenter="this.style.background='var(--color-primario-p3)'"
                  onmouseleave="this.style.background='var(--color-primario-p2)'">
            Cerrar
          </button>
        </div>
    
        
        <button id="closeModalX" aria-label="Cerrar"
                class="absolute right-3 top-3 text-gray-500 hover:text-gray-700">
          <i class="fa-solid fa-xmark text-lg"></i>
        </button>
      </div>
    </div>
    
    <style>
      @keyframes fadeIn {
        from { opacity: 0; transform: scale(0.95); }
        to { opacity: 1; transform: scale(1); }
      }
      .animate-fadeIn {
        animation: fadeIn 0.3s ease-out forwards;
      }
    </style>
    
    <script>
      // Controlar cierre del modal sin ocultar el formulario
      document.addEventListener('DOMContentLoaded', () => {
        const modal = document.getElementById('contactSuccessModal');
        const close = () => modal?.remove();
        document.getElementById('closeSuccessModal')?.addEventListener('click', close);
        document.getElementById('closeModalX')?.addEventListener('click', close);
        modal?.addEventListener('click', (e) => {
          if (e.target === modal) close();
        });
        // autocierre opcional en 5s
        setTimeout(close, 5000);
      });
    </script>
    <?php endif; ?>
    <!------------------------------------------------ FORMULARIO ------------------------------------------------>



    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css','resources/js/app.js']); ?>
    
    
    <script src="/js/web/main.js" defer></script>
</body>

</html>
<?php /**PATH /home/istapidex/public_html/resources/views/contacto/contactanos.blade.php ENDPATH**/ ?>