
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($noticia->titulo); ?></title>

    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&family=Playfair+Display:wght@400;600;700&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="/css/web/lectura.css">

    
    <style>
        /* WebKit */
        .nice-scroll::-webkit-scrollbar {
            width: 10px;
        }

        .nice-scroll::-webkit-scrollbar-track {
            background: #eef2f7;
            border-radius: 8px;
        }

        .nice-scroll::-webkit-scrollbar-thumb {
            background: #cfd8e3;
            border-radius: 8px;
        }

        .nice-scroll::-webkit-scrollbar-thumb:hover {
            background: #b8c4d6;
        }

        /* Firefox */
        .nice-scroll {
            scrollbar-width: thin;
            scrollbar-color: #cfd8e3 #eef2f7;
        }
    </style>
</head>

<body class="bg-[#DDE3E8] font-body">
    <!-- Navegación lateral -->
    <div class="fixed top-0 left-0 h-full w-20 bg-[#00264B] text-white z-50 hidden md:flex flex-col items-center py-8">
        <div class="mb-12">
            <a href="<?php echo e(url('/')); ?>">
                <div class="bg-[#1A4FD3] text-white p-2 rounded-full">
                    <i data-lucide="graduation-cap" class="w-6 h-6"></i>
                </div>
            </a>
        </div>
    </div>

    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php
        use Illuminate\Support\Str;
        use Illuminate\Support\Facades\Storage;

        $img = $noticia->imagen ?: 'images/no-photo.jpg';
        $img = asset(ltrim(str_starts_with($img, '/') ? $img : '/' . ltrim($img, '/'), '/'));

        $fecha = $noticia->fecha?->locale('es')->translatedFormat('j \\d\\e F, Y');
        $lead = Str::limit(strip_tags($noticia->descripcion ?? ''), 260);

        // Documento PDF
        $docRaw = $noticia->documento ?? null;
        $docUrl = null;
        if ($docRaw) {
            if (Str::startsWith($docRaw, ['http://', 'https://'])) {
                $docUrl = $docRaw;
            } elseif (Str::startsWith($docRaw, ['public/', 'storage/'])) {
                $docUrl = Str::startsWith($docRaw, 'storage/') ? asset($docRaw) : asset(Storage::url($docRaw));
            } else {
                $docUrl = asset(ltrim($docRaw, '/'));
            }
        }
        $docExists = true;
        if ($docUrl && !Str::startsWith($docUrl, ['http://', 'https://'])) {
            $localPath = public_path(parse_url($docUrl, PHP_URL_PATH));
            $docExists = file_exists($localPath);
        }
    ?>

    <main class="pl-20 pt-20 min-h-screen">
        <div class="max-w-7xl mx-auto px-6 py-8">
            <a href="<?php echo e(route('noticias.index')); ?>">
                <button
                    class="mb-8 text-[#1A4FD3] hover:text-[#4A84F7] flex items-center space-x-2 transition-all duration-200 hover:translate-x-1">
                    <i data-lucide="arrow-left" class="w-4 h-4"></i>
                    <span class="font-medium">Volver a noticias</span>
                </button>
            </a>

            <div class="grid lg:grid-cols-3 gap-12">
                <div class="lg:col-span-2">
                    <div class="mb-8">
                        <h1 class="text-5xl font-display font-bold text-gray-900 mb-6 leading-tight">
                            <?php echo e($noticia->titulo); ?>

                        </h1>

                        <?php if($lead): ?>
                            <p class="text-xl text-gray-600 leading-relaxed mb-8 font-medium text-justify">
                                <?php echo e($lead); ?>

                            </p>
                        <?php endif; ?>

                        <div class="flex items-center justify-between pb-8 border-b" style="border-color:#DDE3E8">
                            <div class="flex items-center space-x-6">
                                <div class="flex items-center space-x-4 text-sm text-gray-600">
                                    <?php if($fecha): ?>
                                        <div class="flex items-center space-x-1">
                                            <i data-lucide="calendar" class="w-4 h-4"></i>
                                            <span><?php echo e($fecha); ?></span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="w-full rounded-2xl shadow-2xl overflow-hidden bg-white">
                      <img
                        src="<?php echo e($img); ?>"
                        alt="<?php echo e($noticia->titulo); ?>"
                        class="w-full h-auto block" />
                    </div>



                    
                    <div class="mt-16 bg-white rounded-2xl shadow-lg overflow-hidden">
                        <div class="bg-gradient-to-r from-[#1A4FD3] to-[#4A84F7] text-white p-6">
                            <h3 class="text-xl font-bold flex items-center">
                                <i data-lucide="file-text" class="w-6 h-6 mr-3"></i>
                                Documento
                            </h3>
                        </div>

                        <div class="p-6">
                            <?php if($docUrl && $docExists): ?>
                                <div class="mb-6">
                                    <div class="bg-gray-50 rounded-lg p-4 border-2 border-dashed border-gray-300">
                                        <iframe src="<?php echo e($docUrl); ?>#toolbar=1&navpanes=1&scrollbar=1"
                                            class="w-full h-96 rounded-lg border border-gray-200"
                                            type="application/pdf"></iframe>
                                    </div>
                                </div>

                                <div class="flex flex-wrap items-center justify-center gap-3">
                                    <a href="<?php echo e($docUrl); ?>" target="_blank"
                                        class="inline-flex items-center px-6 py-3 bg-white border border-gray-300 text-gray-700 font-semibold rounded-xl hover:bg-gray-50 transition-all">
                                        <i data-lucide="eye" class="w-5 h-5 mr-2"></i>
                                        Ver en pestaña nueva
                                    </a>
                                    <a href="<?php echo e($docUrl); ?>" download
                                        class="inline-flex items-center px-8 py-4 bg-gradient-to-r from-[#1A4FD3] to-[#4A84F7] text-white font-semibold rounded-xl hover:from-[#0F1F3D] hover:to-[#1A4FD3] transition-all duration-300 transform hover:scale-105 shadow-lg hover:shadow-xl">
                                        <i data-lucide="download" class="w-5 h-5 mr-3"></i>
                                        Descargar PDF
                                    </a>
                                </div>
                            <?php else: ?>
                                <div
                                    class="bg-gray-50 rounded-lg p-12 border-2 border-dashed border-gray-300 text-center text-gray-600">
                                    <div class="flex items-center justify-center gap-2 mb-2">
                                        <i data-lucide="alert-circle" class="w-5 h-5"></i>
                                        <span class="font-semibold">404 | NO ENCONTRADO</span>
                                    </div>
                                    <p class="text-sm">No se pudo localizar el documento asociado a esta noticia.</p>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                
                <div class="lg:col-span-1">
                    <div class="sticky top-32">
                        <div class="bg-gradient-to-r from-[#1A4FD3] to-[#4A84F7] text-white p-4 rounded-t-2xl">
                            <h3 class="text-lg font-bold flex items-center">
                                <i data-lucide="newspaper" class="w-5 h-5 mr-2"></i>
                                Otras Noticias
                            </h3>
                        </div>

                        
                        <div
                            class="bg-white rounded-b-2xl shadow-lg p-4 space-y-6 overflow-y-auto nice-scroll max-h-[540px]">
                            <?php $__empty_1 = true; $__currentLoopData = $others; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $oImg = $item->imagen ?: 'images/no-photo.jpg';
                                    $oImg = asset(
                                        ltrim(str_starts_with($oImg, '/') ? $oImg : '/' . ltrim($oImg, '/'), '/'),
                                    );
                                    $oDate = $item->fecha?->locale('es')->translatedFormat('j \\d\\e F, Y');
                                ?>
                                <a href="<?php echo e(route('noticias.show', $item)); ?>" class="group block">
                                    <div class="bg-white rounded-lg p-4 shadow-sm border hover:shadow-md transition-shadow"
                                        style="border-color:#DDE3E8">
                                        <img src="<?php echo e($oImg); ?>" alt="<?php echo e($item->titulo); ?>"
                                            class="w-full h-24 object-cover rounded-lg mb-3" />
                                        <h4
                                            class="font-semibold text-gray-900 mb-2 group-hover:text-[#1A4FD3] transition-colors">
                                            <?php echo e($item->titulo); ?>

                                        </h4>
                                        <p class="text-gray-600 text-sm mb-3 line-clamp-2 text-justify">
                                            <?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->descripcion ?? ''), 120)); ?>

                                        </p>
                                        <div class="flex items-center justify-between text-xs text-gray-500">
                                            <span><?php echo e($oDate); ?></span>
                                        </div>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <div class="text-gray-500 text-sm">No hay más noticias.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </main>

    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <script>
        lucide.createIcons();
    </script>
    <script src="/js/web/main.js" defer></script>
</body>

</html>
<?php /**PATH /home/istapidex/public_html/resources/views/otros/lectura_noticias.blade.php ENDPATH**/ ?>