<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Documentos de Gestión</title>

    <!-- Tailwind -->
    <script src="https://cdn.tailwindcss.com"></script>

    <!-- Lucide Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/lucide/0.263.1/lucide.min.css" rel="stylesheet">
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js" defer></script>

    <link rel="stylesheet" href="/css/web/documentos.css">
</head>

<body
    class="min-h-screen bg-gradient-to-br from-[#DDE3E8] to-white text-[#212529] font-sans scroll-smooth overflow-x-hidden"
    style="background-image: linear-gradient(to bottom right, var(--color-neutral), white); color:#212529;">

    <!-- Sidebar minimal -->
    <div class="fixed top-0 left-0 h-full w-20 bg-[#00264B] text-white z-50 hidden md:flex flex-col items-center py-8"
        style="background-color: var(--color-primario-p1); color:#fff;">
        <div class="mb-12">
            <div class="bg-[#E27227] text-white p-2 rounded-full"
                style="background-color: var(--color-secundario-s1); color:#fff;">
                <i data-lucide="graduation-cap" class="h-6 w-6"></i>
            </div>
        </div>
        <nav class="flex flex-col items-center space-y-8 flex-grow" id="sidebar-nav">
            <button onclick="scrollToSection('lista')"
                class="nav-dot relative w-12 h-12 flex items-center justify-center transition-all hover:bg-[#1A4FD3]/20 rounded-full"
                title="Documentos" style="background-color: transparent;" data-section="hero">
                <div class="h-3 w-3 rounded-full bg-white"></div>
            </button>
        </nav>
    </div>

    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <main class="md:pl-20">
        <!-- HERO -->
        <section id="hero" class="py-20 bg-gradient-to-br from-[#00264B] via-[#1A4FD3] to-[#4A84F7] text-white"
            style="background-image: linear-gradient(to bottom right, var(--color-primario-p1), var(--color-primario-p2), var(--color-primario-p3)); color:#fff;">
            <div class="container mx-auto px-4">
                <div class="max-w-4xl mx-auto text-center">
                    <h1 class="text-5xl md:text-7xl font-black leading-tight mb-6">
                        Documentos
                        <span class="block md:inline">Institucionales</span>
                    </h1>
                    <!--<p class="text-xl md:text-2xl text-white/90 mb-12 max-w-3xl mx-auto">
                        Estatutos, reglamentos generales y documentos fundacionales
                    </p>-->
                </div>
            </div>
        </section>

        <!-- LISTA -->
        <section id="lista" class="py-16 bg-white">
            <div class="container mx-auto px-4">
                <div class="mb-8">
                    <div class="flex items-center gap-4 mb-4">
                        <div class="bg-[#DDE3E8] p-3 rounded-xl" style="background-color: var(--color-neutral);">
                            <i data-lucide="building" class="h-8 w-8 text-[#1A4FD3]"
                                style="color: var(--color-primario-p2);"></i>
                        </div>
                        <h2 class="text-4xl font-black">Documentos Institucionales</h2>
                    </div>

                    
                    <form method="GET" action="<?php echo e(route('web.documentos')); ?>">
                        <div class="flex flex-col sm:flex-row gap-3">
                            <div class="relative flex-1 min-w-0">
                                <input type="text" name="q" value="<?php echo e($q ?? ''); ?>"
                                    placeholder="Buscar documento por nombre o descripción…"
                                    class="w-full rounded-xl border border-gray-300 bg-white/90 px-4 py-3 pr-10 focus:outline-none focus:ring-2 focus:ring-[#1A4FD3] focus:border-transparent"
                                    style="--tw-ring-color: var(--color-primario-p2);">
                                <i data-lucide="search"
                                   class="pointer-events-none absolute right-3 top-1/2 -translate-y-1/2 h-5 w-5 text-gray-400"></i>
                            </div>

                            <button
                                class="rounded-xl bg-[#1A4FD3] hover:bg-[#00264B] text-white px-5 py-3 font-medium transition-colors"
                                style="background-color: var(--color-primario-p2);"
                                onmouseover="this.style.backgroundColor=getComputedStyle(document.documentElement).getPropertyValue('--color-primario-p1')"
                                onmouseout="this.style.backgroundColor=getComputedStyle(document.documentElement).getPropertyValue('--color-primario-p2')">
                                Buscar
                            </button>

                            <?php if(!empty($q)): ?>
                                <a href="<?php echo e(route('web.documentos')); ?>"
                                   class="rounded-xl bg-gray-100 hover:bg-gray-200 text-gray-700 px-5 py-3 font-medium transition-colors">
                                    Limpiar
                                </a>
                            <?php endif; ?>
                        </div>

                        <div class="mt-2 text-sm text-gray-600">
                            <?php if(!empty($q)): ?>
                                Mostrando <?php echo e($documentos->total()); ?> resultado(s) para
                                <span class="font-semibold">"<?php echo e($q); ?>"</span>.
                            <?php else: ?>
                                Total de documentos: <?php echo e($documentos->total()); ?>

                            <?php endif; ?>
                        </div>
                    </form>
                </div>

                
                <?php if($documentos->isEmpty()): ?>
                    <div class="rounded-2xl border border-gray-200 bg-white p-8 text-center text-gray-600">
                        <?php if(!empty($q)): ?>
                            No se encontraron documentos para “<?php echo e($q); ?>”.
                        <?php else: ?>
                            Aún no hay documentos publicados.
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <?php $__currentLoopData = $documentos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="document-card bg-white border border-gray-200 rounded-2xl p-6 hover:border-[#1A4FD3]"
                                style="border-color: #e5e7eb;"
                                onmouseover="this.style.borderColor=getComputedStyle(document.documentElement).getPropertyValue('--color-primario-p2')"
                                onmouseout="this.style.borderColor='#e5e7eb'">
                                <h3 class="text-xl font-bold mb-2 break-words"><?php echo e($doc->nombre); ?></h3>
                                <p class="text-gray-600 text-sm mb-5 text-justify break-words"><?php echo e($doc->descripcion); ?></p>

                                
                                <a href="javascript:void(0)"
                                   onclick="openPdfModal('<?php echo e(route('web.documentos.file', $doc)); ?>')"
                                   class="w-full bg-[#1A4FD3] hover:bg-[#00264B] text-white py-3 rounded-xl font-medium transition-colors flex items-center justify-center gap-2"
                                   style="background-color: var(--color-primario-p2);"
                                   onmouseover="this.style.backgroundColor=getComputedStyle(document.documentElement).getPropertyValue('--color-primario-p1')"
                                   onmouseout="this.style.backgroundColor=getComputedStyle(document.documentElement).getPropertyValue('--color-primario-p2')">
                                    <i data-lucide="eye" class="h-4 w-4"></i> Ver PDF
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    
                    <div class="mt-10 overflow-x-auto">
                        <?php echo e($documentos->onEachSide(1)->links()); ?>

                    </div>
                <?php endif; ?>
            </div>
        </section>
    </main>

    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Modal visor de PDF -->
    <div id="pdfModal"
         class="fixed inset-0 bg-black/60 backdrop-blur-sm flex items-center justify-center z-[999] hidden">
        <div class="bg-white w-[95%] h-[90%] max-w-7xl rounded-2xl shadow-xl overflow-hidden flex flex-col animate-[fadeIn_.2s_ease]">
            <!-- Header -->
            <div class="flex justify-between items-center px-6 py-4 bg-[#00264B] text-white">
                <h2 class="text-lg font-semibold">Visor de documento</h2>
                <button type="button" aria-label="Cerrar visor" onclick="closePdfModal()"
                        class="text-white/90 hover:text-white focus:outline-none text-2xl leading-none">
                    ✕
                </button>
            </div>
    
            <!-- Visor PDF -->
            <div class="relative flex-1 bg-gray-100">
                <iframe id="pdfFrame" src="" class="w-full h-full" title="Documento PDF"></iframe>
            </div>
    
            <!-- Footer -->
            <div class="flex justify-end gap-3 px-6 py-4 bg-gray-50 border-t">
                <a id="openPdfNewTab" href="#" target="_blank" rel="noopener"
                   class="bg-[#1A4FD3] text-white px-5 py-2 rounded-lg hover:bg-[#00264B] transition">
                   Abrir en otra pestaña
                </a>
                <button type="button" onclick="closePdfModal()"
                        class="bg-gray-200 px-5 py-2 rounded-lg hover:bg-gray-300 transition">
                    Cerrar
                </button>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="/js/web/main.js" defer></script>
    <script src="/js/web/documentos.js"></script>

</body>
</html>
<?php /**PATH /home/istapidex/public_html/resources/views/transparencia/documentos.blade.php ENDPATH**/ ?>