<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar viaticos</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">
        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        
        <?php $__env->startSection('titlenavbar'); ?>
            Gestionar viaticos
        <?php $__env->stopSection(); ?>
        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre viaticos</h4>
                                        </div>
                                        <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                            + Nuevo Viático
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Admin/Docente</th>
                                                                <th class="text-center">Descripcion</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Método de Pago</th>
                                                                <th class="text-center">Banco</th>
                                                                <th class="text-center">N° Operación</th>
                                                                <th class="text-center">Monto</th>
                                                                <th class="text-center">Comprobante</th>
                                                                <th class="text-center">Encargado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar Nuevo Viático</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-2">
                        <!-- ROW 1 -->
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idviatico" name="txt-idviatico" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-usuario_id" class="form-label text-primary">Docente / Administrador</label>
                                    <select id="txt-usuario_id" name="txt-usuario_id" class="default-select form-control form-control-sm" data-live-search="true" data-size="8" required>
                                        <!-- combobox -->
                                        <option selected disabled value="">Buscar usuario</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-descripcion" class="form-label text-primary">Descripción</label>
                                    <input id="txt-descripcion" name="txt-descripcion" type="text"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-monto" class="form-label text-primary">Monto</label>
                                    <input id="txt-monto" name="txt-monto" type="number"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-fecha" class="form-label text-primary">Fecha</label>
                                    <input id="txt-fecha" name="txt-fecha" type="date"
                                        class="form-control form-control-sm" placeholder="" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                        <option selected value="1">Pagado</option>
                                        <option value="2">Pendiente</option>
                                        <option value="0">Rechazado</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-metodo_pago_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-metodo_pago_id" class="form-label text-primary">Método de Pago</label>
                                    <select id="txt-metodo_pago_id" name="txt-metodo_pago_id" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-banco_id" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-banco_id" class="form-label text-primary">Banco</label>
                                    <select id="txt-banco_id" name="txt-banco_id" class="default-select form-control form-control-sm" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- data -->
                                <div id="div-txt-nro_operacion" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-nro_operacion" class="form-label text-primary">Número de Operación</label>
                                    <input id="txt-nro_operacion" name="txt-nro_operacion" type="number" class="form-control form-control-sm" placeholder="">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <!-- data -->
                                <div id="div-txt-documento" class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-documento" class="form-label text-primary">Boucher</label>
                                    <input id="txt-documento" name="txt-documento" type="file" class="form-control form-control-sm" placeholder="">
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light" data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>



    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/tesoreria/viaticos.js']); ?>;
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/registros_pagos/viaticos/index.blade.php ENDPATH**/ ?>