<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Horarios</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
</head>

<body>
    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Gestionar Horarios')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlplan">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-3 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Semestre Académico</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlperiod">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div role="toolbar" class="toolbar bg w-100">
                                            <div class="d-flex align-items-center justify-content-start w-100">
                                                <div class="row g-1 w-100" style="max-width: 40rem;">
                                                    <div class="col-12 col-md-3">
                                                        <input type="date" class="form-control form-control-sm"
                                                            id="data-fecha">
                                                    </div>

                                                    <div class="col-12 col-md-3">
                                                        <input type="number" class="form-control form-control-sm"
                                                            id="data-semanas" min="1" step="1"
                                                            placeholder="Semanas">
                                                    </div>

                                                    <div class="col-12 col-md-3">
                                                        <button id="btnGenerarClases"
                                                            class="btn btn-primary btn-sm w-100">
                                                            Generar Clases
                                                        </button>
                                                    </div>

                                                    <div class="col-12 col-md-3">
                                                        <button id="btnEliminarClases"
                                                            class="btn btn-outline-danger btn-sm w-100">
                                                            Eliminar clases
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Informacion</th>
                                                                <th class="text-center">curso</th>
                                                                <th class="text-center">Asignar</th>
                                                                <th class="text-center">Dia</th>
                                                                <th class="text-center">Hora Inicio</th>
                                                                <th class="text-center">Hora Fin</th>
                                                                <th class="text-center">Duracion</th>
                                                                <th class="text-center">Nro Aula</th>
                                                                <th class="text-center">Tipo</th>
                                                                <th class="text-center">Borrar</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>


    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idperiod" name="txt-idperiod">

        <!-- Modal Horario-->
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-md">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar Horario</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input id="txt_idasignatura" name="txt_idasignatura" type="hidden">
                                <!-- data -->
                                <input id="txt_idhorario" name="txt_idhorario" type="hidden">
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_dia" class="form-label text-primary">Dia</label>
                                    <select id="txt_dia" name="txt_dia" type="text"
                                        class="form-control form-control-sm">
                                        <option disabled selected value="0">Seleccione dia</option>
                                        <option value="Lunes">Lunes</option>
                                        <option value="Martes">Martes</option>
                                        <option value="Miercoles">Miercoles</option>
                                        <option value="Jueves">Jueves</option>
                                        <option value="Viernes">Viernes</option>
                                        <option value="Sabado">Sabado</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_horaini" class="form-label text-primary">Hora Inicio</label>
                                    
                                    <select id="txt_horaini" name="txt_horaini" type="text"
                                        class="form-control form-control-sm">
                                        <option disabled selected value="0">Seleccione hora</option>
                                        <option value="07:30">07:30 am</option>
                                        <option value="07:45">07:45 am</option>
                                        <option value="08:00">08:00 am</option>
                                        <option value="08:15">08:15 am</option>
                                        <option value="08:30">08:30 am</option>
                                        <option value="08:45">08:45 am</option>
                                        <option value="09:00">09:00 am</option>
                                        <option value="09:15">09:15 am</option>
                                        <option value="09:30">09:30 am</option>
                                        <option value="09:45">09:45 am</option>
                                        <option value="10:00">10:00 am</option>
                                        <option value="10:15">10:15 am</option>
                                        <option value="10:30">10:30 am</option>
                                        <option value="10:45">10:45 am</option>
                                        <option value="11:00">11:00 am</option>
                                        <option value="11:15">11:15 am</option>
                                        <option value="11:30">11:30 am</option>
                                        <option value="11:45">11:45 am</option>
                                        <option value="12:00">12:00 pm</option>
                                        <option value="12:15">12:15 pm</option>
                                        <option value="12:30">12:30 pm</option>
                                        <option value="12:45">12:45 pm</option>
                                        <option value="13:00">01:00 pm</option>
                                        <option value="13:15">01:15 pm</option>
                                        <option value="13:30">01:30 pm</option>
                                        <option value="13:45">01:45 pm</option>
                                        <option value="14:00">02:00 pm</option>
                                        <option value="14:15">02:15 pm</option>
                                        <option value="14:30">02:30 pm</option>
                                        <option value="14:45">02:45 pm</option>
                                        <option value="15:00">03:00 pm</option>
                                        <option value="15:15">03:15 pm</option>
                                        <option value="15:30">03:30 pm</option>
                                        <option value="15:45">03:45 pm</option>
                                        <option value="16:00">04:00 pm</option>
                                        <option value="16:15">04:15 pm</option>
                                        <option value="16:30">04:30 pm</option>
                                        <option value="16:45">04:45 pm</option>
                                        <option value="17:00">05:00 pm</option>
                                        <option value="17:15">05:15 pm</option>
                                        <option value="17:30">05:30 pm</option>
                                        <option value="17:45">05:45 pm</option>
                                        <option value="18:00">06:00 pm</option>
                                        <option value="18:15">06:15 pm</option>
                                        <option value="18:30">06:30 pm</option>
                                        <option value="18:45">06:45 pm</option>
                                        <option value="19:00">07:00 pm</option>
                                        <option value="19:15">07:15 pm</option>
                                        <option value="19:30">07:30 pm</option>
                                        <option value="19:45">07:45 pm</option>
                                        <option value="20:00">08:00 pm</option>
                                        <option value="20:15">08:15 pm</option>
                                        <option value="20:30">08:30 pm</option>
                                        <option value="20:45">08:45 pm</option>
                                        <option value="21:00">09:00 pm</option>
                                        <option value="21:15">09:15 pm</option>
                                        <option value="21:30">09:30 pm</option>
                                        <option value="21:45">09:45 pm</option>
                                        <option value="22:00">10:00 pm</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_horafin" class="form-label text-primary">Hora Fin</label>
                                    
                                    <select id="txt_horafin" name="txt_horafin" type="text"
                                        class="form-control form-control-sm">
                                        <option disabled selected value="0">Seleccione hora</option>
                                        <option value="07:30">07:30 am</option>
                                        <option value="07:45">07:45 am</option>
                                        <option value="08:00">08:00 am</option>
                                        <option value="08:15">08:15 am</option>
                                        <option value="08:30">08:30 am</option>
                                        <option value="08:45">08:45 am</option>
                                        <option value="09:00">09:00 am</option>
                                        <option value="09:15">09:15 am</option>
                                        <option value="09:30">09:30 am</option>
                                        <option value="09:45">09:45 am</option>
                                        <option value="10:00">10:00 am</option>
                                        <option value="10:15">10:15 am</option>
                                        <option value="10:30">10:30 am</option>
                                        <option value="10:45">10:45 am</option>
                                        <option value="11:00">11:00 am</option>
                                        <option value="11:15">11:15 am</option>
                                        <option value="11:30">11:30 am</option>
                                        <option value="11:45">11:45 am</option>
                                        <option value="12:00">12:00 pm</option>
                                        <option value="12:15">12:15 pm</option>
                                        <option value="12:30">12:30 pm</option>
                                        <option value="12:45">12:45 pm</option>
                                        <option value="13:00">01:00 pm</option>
                                        <option value="13:15">01:15 pm</option>
                                        <option value="13:30">01:30 pm</option>
                                        <option value="13:45">01:45 pm</option>
                                        <option value="14:00">02:00 pm</option>
                                        <option value="14:15">02:15 pm</option>
                                        <option value="14:30">02:30 pm</option>
                                        <option value="14:45">02:45 pm</option>
                                        <option value="15:00">03:00 pm</option>
                                        <option value="15:15">03:15 pm</option>
                                        <option value="15:30">03:30 pm</option>
                                        <option value="15:45">03:45 pm</option>
                                        <option value="16:00">04:00 pm</option>
                                        <option value="16:15">04:15 pm</option>
                                        <option value="16:30">04:30 pm</option>
                                        <option value="16:45">04:45 pm</option>
                                        <option value="17:00">05:00 pm</option>
                                        <option value="17:15">05:15 pm</option>
                                        <option value="17:30">05:30 pm</option>
                                        <option value="17:45">05:45 pm</option>
                                        <option value="18:00">06:00 pm</option>
                                        <option value="18:15">06:15 pm</option>
                                        <option value="18:30">06:30 pm</option>
                                        <option value="18:45">06:45 pm</option>
                                        <option value="19:00">07:00 pm</option>
                                        <option value="19:15">07:15 pm</option>
                                        <option value="19:30">07:30 pm</option>
                                        <option value="19:45">07:45 pm</option>
                                        <option value="20:00">08:00 pm</option>
                                        <option value="20:15">08:15 pm</option>
                                        <option value="20:30">08:30 pm</option>
                                        <option value="20:45">08:45 pm</option>
                                        <option value="21:00">09:00 pm</option>
                                        <option value="21:15">09:15 pm</option>
                                        <option value="21:30">09:30 pm</option>
                                        <option value="21:45">09:45 pm</option>
                                        <option value="22:00">10:00 pm</option>
                                    </select>
                                </div>
                                <!-- data -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt_idaula" class="form-label text-primary">Aula</label>
                                    <select id="txt_idaula" name="txt_idaula" type="text"
                                        class="form-control form-control-sm">
                                        <option disabled selected value="0">Seleccione aula</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/horarios/horarios.js']); ?>


    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/horarios/asignar_horario/index.blade.php ENDPATH**/ ?>