<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Inicio docente</title>
    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

    <style>
        /* Scroll de cursos para el resumen */
        .sga-resumen-cursos-scroll {
            max-height: 260px;
            overflow-y: auto;
        }

        .sga-item-curso-resumen {
            cursor: pointer;
            transition: background-color 0.15s ease-in-out;
        }

        .sga-item-curso-resumen:hover {
            background-color: #f5f7fb;
        }

        .sga-item-curso-resumen.sga-active {
            background-color: #e4ecff;
        }
    </style>
</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Inicio')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <?php echo csrf_field(); ?>

                    
                    <div class="col-xl-8">
                        <div class="card h-auto">
                            <div class="card-header p-0">
                                <div class="user-bg w-100">
                                    <div class="user-svg">
                                        <svg width="264" height="109" viewBox="0 0 264 109" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect x="0.0107422" y="0.6521" width="263.592" height="275.13"
                                                rx="20" fill="#FCC43E" />
                                        </svg>
                                    </div>
                                    <div class="user-svg-1">
                                        <svg width="264" height="59" viewBox="0 0 264 59" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect y="0.564056" width="263.592" height="275.13" rx="20"
                                                fill="#FB7D5B" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="user">
                                        <div class="user-media">
                                            <?php if(Auth::User()->genre_id == 1): ?>
                                                <img class="img_user avatar avatar-xxl"
                                                    src="<?php echo e(asset('/images/avatar/male.jpg')); ?>" alt="">
                                            <?php elseif(Auth::User()->genre_id == 2): ?>
                                                <img class="img_user avatar avatar-xxl"
                                                    src="<?php echo e(asset('/images/avatar/female.jpg')); ?>" alt="">
                                            <?php else: ?>
                                                <img class="img_user avatar avatar-xxl"
                                                    src="<?php echo e(asset('/images/avatar/other.jpg')); ?>" alt="">
                                            <?php endif; ?>
                                        </div>
                                        <div>
                                            <h2 class="mb-0"><?php echo e(Auth::User()->nombres); ?></h2>
                                            <p class="text-primary font-w600">Docente</p>
                                        </div>
                                    </div>

                                    <?php
                                        $user = Auth::user();
                                        $teacherData = $user->teachers;
                                    ?>

                                    <div class="row m-0 justify-content-center align-items-center">
                                        <?php if($teacherData): ?>
                                            <p class="text-primary p-0">
                                                <a class="timeline-panel text-muted text-left" href="#">
                                                    <h4 class="mb-0">Detalle</h4>
                                                    <p class="mb-0">Tipo contrato: <?php echo e($teacherData[0]->tipocontrato); ?>

                                                    </p>
                                                    <h6 class="mb-0">Código:
                                                        <strong class="text-primary"></strong>
                                                    </h6>
                                                    <span><strong class="text-primary">
                                                            Horas lectivas: <?php echo e($teacherData[0]->horas_lectivas); ?>

                                                        </strong></span><br>
                                                    <span><strong class="text-primary">
                                                            Horas no lectivas: <?php echo e($teacherData[0]->horas_nolectivas); ?>

                                                        </strong></span>
                                                </a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="row mt-2">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="<?php echo e(asset('/images/profile.svg')); ?>" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Apellidos:</span>
                                                <h5 class="mb-0"><?php echo e(Auth::User()->nombres); ?>

                                                    <?php echo e(Auth::User()->apellido_pa); ?> - <?php echo e(Auth::User()->apellido_ma); ?>

                                                </h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="<?php echo e(asset('/images/svg/location.svg')); ?>" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Dirección:</span>
                                                <h5 class="mb-0"><?php echo e(Auth::User()->direccion); ?></h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="<?php echo e(asset('/images/svg/phone.svg')); ?>" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Celular:</span>
                                                <h5 class="mb-0"><?php echo e(Auth::User()->celular); ?> -
                                                    <?php echo e(Auth::User()->telefono); ?></h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="<?php echo e(asset('/images/svg/email.svg')); ?>" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Correo:</span>
                                                <h5 class="mb-0"><?php echo e(Auth::User()->correo); ?></h5>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-xl-4">
                        <div class="card">
                            <div class="card-header border-0 pb-2 justify-content-center bg-primary text-center">
                                <h4 class="card-title text-light mb-0">
                                    Cursos Total: <span id="total_asign"></span>
                                </h4>
                                <small class="text-light d-block mt-1" id="label_semestre"></small>
                            </div>
                            <div class="card-body p-0">
                                <div id="DZ_W_TimeLine11"
                                    class="widget-timeline dlab-scroll height500 style-1 my-4 px-2">
                                    <ul class="timeline" id="list_asignaturas">
                                        
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-12 col-sm-12">
                        <div class="card">
                            <div class="card-header px-3">
                                <h4 class="card-title mb-0">Resumen de notas por curso</h4>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    
                                    <div class="col-md-4 mb-3">
                                        <div class="border rounded sga-resumen-cursos-scroll p-2">
                                            <ul class="list-unstyled mb-0" id="sga-lista-resumen-cursos">
                                                
                                            </ul>
                                        </div>
                                    </div>

                                    
                                    <div class="col-md-8 d-flex align-items-center justify-content-center">
                                        <div class="w-100 text-center">
                                            <h5 id="sga-resumen-curso-titulo" class="text-primary mb-4 fw-semibold">
                                                Seleccione un curso
                                            </h5>
                                            <div class="row text-center">
                                                <div class="col-sm-6 mb-3">
                                                    <h2 id="sga-total-sin-nota" class="mb-0 fw-bold">0</h2>
                                                    <small class="text-muted d-block">
                                                        Estudiantes sin nota asignada
                                                    </small>
                                                </div>
                                                <div class="col-sm-6 mb-3">
                                                    <h2 id="sga-total-con-nota" class="mb-0 fw-bold">0</h2>
                                                    <small class="text-muted d-block">
                                                        Estudiantes con nota asignada
                                                    </small>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-xl-12 col-lg-12 col-md-12 col-12 col-sm-12">
                        <div class="card" id="accordion-three">
                            <div class="card-header flex-wrap px-3">
                                <div>
                                    <h4 class="card-title">
                                        Registro de información de los estudiantes matriculado por curso
                                    </h4>
                                </div>
                            </div>
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                    aria-labelledby="home-tab-2">
                                    <div class="card-body p-4">
                                        <div class="table-responsive">
                                            <table id="datatableGeneral"
                                                class="table table-hover table-bordered table-sm display rounded-3"
                                                style="min-width:100%">
                                                <thead class="thead-primary">
                                                    <tr>
                                                        <th class="text-center">Ud. Didáctica</th>
                                                        <th class="text-center">N° documento</th>
                                                        <th class="text-center">Estudiante</th>
                                                        <th class="text-center">Apellido Paterno</th>
                                                        <th class="text-center">Apellido Materno</th>
                                                        <th class="text-center">Correo</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div> 
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->

        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idcourse" name="txt-idcourse">
    </form>

    <!--**********************************
        Scripts
    ***********************************-->
    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.modal-versiones', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/docente/home_docentes.js']); ?>

    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/home/docente/index.blade.php ENDPATH**/ ?>