<!DOCTYPE html>

<html lang="es">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Gestionar Instrumentos de Evaluación</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
</head>

<body>
    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Gestionar Instrumentos de Evaluación')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlprogram">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">cursos</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul class="timeline" id="tlsubject">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de Indicadores, Actividades y Ponderaciones
                                            </h4>
                                        </div>
                                        <button id="btnCreateIndicador" type="button" class="btn btn-primary btn-sm"
                                            data-bs-toggle="modal" data-bs-target="#modalCU_Indicador">
                                            + Nuevo Indicador
                                        </button>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Indicador</th>
                                                                <th class="text-center">Actividad</th>
                                                                <th class="text-center">Nota</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>

    <!-- Modal C/U Indicador -->
    <form class="needs-validation" id="formModalIndicador">
        <?php echo csrf_field(); ?>
        <div id="modalCU_Indicador" class="modal fade" tabindex="-1" aria-labelledby="modalCU_IndicadorLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCU_IndicadorLabel">Editar nota</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-idsubject" name="txt-idsubject" type="hidden">
                                <!-- data -->
                                <input id="txt-idindicator" name="txt-idindicator" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-i_nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-i_nombre" name="txt-i_nombre" type="text"
                                        class="form-control form-control-sm">
                                </div>
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3" style="display:none">
                                    <label for="txt-i_descripcion" class="form-label text-primary">Descripcion</label>
                                    <input id="txt-i_descripcion" name="txt-i_descripcion" type="text"
                                        class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCU_Indicador" type="button"
                            class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- Modal C/U Actividad -->
    <form class="needs-validation" id="formModalActividad">
        <?php echo csrf_field(); ?>
        <div id="modalCU_Actividad" class="modal fade" tabindex="-1" aria-labelledby="modalCU_ActividadLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCU_ActividadLabel">Editar nota</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data -->
                                <input id="txt-a_idindicator" name="txt-a_idindicator" type="hidden">
                                <!-- data -->
                                <input id="txt-a_idactivity" name="txt-a_idactivity" type="hidden">
                                <!-- data -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-a_nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-a_nombre" name="txt-a_nombre" type="text"
                                        class="form-control form-control-sm">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCU_Actividad" type="button"
                            class="btn btn-primary btn-sm ">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!-- Modal C/U Nota -->
    <form class="needs-validation" id="formModalNota">
        <?php echo csrf_field(); ?>
        <div id="modalCU_Nota" class="modal fade" tabindex="-1" aria-labelledby="modalCU_NotaLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-ls">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCU_NotaLabel">Editar nota</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-1 py-1">
                        <div class="row">
                            <div class="row col-xl-12 m-0">
                                <!-- data hidden -->
                                <input id="txt-g_idactivity" name="txt-g_idactivity" type="hidden">
                                <input id="txt-g_idgrade" name="txt-g_idgrade" type="hidden">

                                <!-- Nombre -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-g_nombre" class="form-label text-primary">Nombre</label>
                                    <input id="txt-g_nombre" name="txt-g_nombre" type="text"
                                        class="form-control form-control-sm" required>
                                </div>

                                <!-- Porcentaje -->
                                <div class="col-xl-12 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-g_porcentaje" class="form-label text-primary">Porcentaje
                                        (%)</label>
                                    <select id="txt-g_porcentaje" name="txt-g_porcentaje"
                                        class="form-control form-control-sm" required>
                                        <option disabled selected value="0">Seleccione porcentaje</option>
                                        <option value="0.05">5%</option>
                                        <option value="0.10">10%</option>
                                        <option value="0.15">15%</option>
                                        <option value="0.20">20%</option>
                                        <option value="0.25">25%</option>
                                        <option value="0.30">30%</option>
                                        <option value="0.35">35%</option>
                                        <option value="0.40">40%</option>
                                        <option value="0.45">45%</option>
                                        <option value="0.50">50%</option>
                                        <option value="0.55">55%</option>
                                        <option value="0.60">60%</option>
                                        <option value="0.65">65%</option>
                                        <option value="0.70">70%</option>
                                        <option value="0.75">75%</option>
                                        <option value="0.80">80%</option>
                                        <option value="0.85">85%</option>
                                        <option value="0.90">90%</option>
                                        <option value="0.95">95%</option>
                                        <option value="1.00">100%</option>
                                    </select>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>

                                <!-- Fecha Límite -->
                                <div class="col-xl-12 mb-3">
                                    <label for="txt-g_fecha_limite" class="form-label text-primary">Fecha y Hora
                                        Límite (Opcional)</label>
                                    <input id="txt-g_fecha_limite" name="txt-g_fecha_limite" type="datetime-local"
                                        class="form-control form-control-sm">
                                </div>

                                <!-- Checkbox Tipo Nota -->
                                <div class="col-xl-12 mb-3">
                                    <div class="form-check">
                                        <!-- El value="1" se envía si está marcado -->
                                        <input class="form-check-input" type="checkbox" id="chk-g_tipo_nota"
                                            name="chk-g_tipo_nota" value="1">
                                        <label class="form-check-label text-dark" for="chk-g_tipo_nota">
                                            ¿Requiere que el estudiante suba un archivo/evidencia?
                                        </label>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCU_Nota" type="button" class="btn btn-primary btn-sm">Actualizar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <!--**********************************
                    Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/notas/indicador.js']); ?>;

    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/notas/indicadores/index.blade.php ENDPATH**/ ?>