<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Evaluación Curricular</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

    
    <style>
        .chart-pie-small {
            max-width: 320px;
            /* o 280px si lo quieres más chico */
            max-height: 320px;
            width: 100%;
            height: auto;
        }

        .deudores-counter-wrapper {
            display: flex;
            justify-content: center;
        }

        .deudores-counter {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 60px;
            /* ancho del bloque */
            height: 90px;
            /* alto del bloque */
            background-color: #262626;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
        }

        .deudores-counter__value {
            color: #ffffff;
            font-weight: 700;
            font-size: 2.4rem;
            line-height: 1;
        }

        /* Scroll para la lista */
        .deudores-list {
            max-height: 260px;
            /* ajusta a gusto */
            overflow-y: auto;
        }

        .deudores-list::-webkit-scrollbar {
            width: 6px;
        }

        .deudores-list::-webkit-scrollbar-thumb {
            background-color: rgba(0, 0, 0, 0.15);
            border-radius: 3px;
        }

        .chart-radar {
            max-width: 670px;
            max-height: 450px;
            width: 100%;
            height: auto;
        }

        .chart-line-semestre {
            max-width: 100%;
            height: 320px;
            /* o 280px/350px según te guste */
        }

        .chart-bar-plan {
            height: 320px;
            /* súbelo a 360/400 si quieres más alto */
        }
    </style>
</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Evaluación Curricular
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <div class="row col-xl-12 m-0 p-0">
                                <!-- FILTRO -->
                                <div class="col-xl-4 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-programs" class="form-label text-primary">
                                        <b>
                                            <h4 class="m-0">Programa de Estudio</h4>
                                        </b>
                                    </label>

                                    <select id="txt-programs" name="txt-programs" class="form-control form-control-sm">
                                        <option value="" selected disabled>Seleccione programa</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-6 col-lg-6 col-md-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 p-static pb-2">
                                        <div>
                                            <h6 class="text-center">Número De Estudiantes De Un Plan</h6>
                                        </div>
                                    </div>
                                    <canvas id="grafico-1" class="p-2"></canvas>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-6 col-lg-6 col-md-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 p-static pb-2">
                                        <div>
                                            <h6 class="text-center">Número De Egresados De Un Plan</h6>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <canvas id="grafico-2" class="w-100 chart-bar-plan"></canvas>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-8 col-lg-8 col-md-8 col-12">
                                <div class="card">
                                    <div class="card-header border-1 p-static pb-2">
                                        <div>
                                            <h6 class="text-center">Número De Matriculados por Semestre</h6>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <canvas id="grafico-3" class="p-2 chart-line-semestre"></canvas>
                                    </div>
                                </div>
                            </div>
                            <!-- Column starts -->
                            <div class="col-xl-4 col-lg-4 col-md-4 col-12">
                                <div class="card">
                                    <div class="card-header border-1 p-static pb-2">
                                        <div>
                                            <h6 class="text-center">Número De Ingresantes por Año</h6>
                                        </div>
                                    </div>
                                    <div class="card-body d-flex justify-content-center">
                                        <canvas id="grafico-4" class="p-2 chart-pie-small"></canvas>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--**********************************
            Content body end
        ***********************************-->
            <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
        <!--**********************************
        Main wrapper end
    ***********************************-->

        <!--**********************************
        Scripts
    ***********************************-->

        <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Template JS -->
        <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
        <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


        <!-- Logout JS -->
        <script>
            var logoutRoute = '<?php echo e(route('logout')); ?>';
        </script>
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

        <!--  Page JS -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/students.js']); ?>;
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/programs.js']); ?>;
        <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/planes_de_estudio/graficos.js']); ?>;
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/planes_estudio/evaluacion/index.blade.php ENDPATH**/ ?>