<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>SGA - IESTP</title>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-image:
                url('<?php echo e(asset('images/institucion/fondo_login.png')); ?>'),
                linear-gradient(180deg, #552f19, #b8b8b8);
            background-size: cover;
            /* Asegura que la imagen cubra todo el fondo */
            background-position: center;
            /* Centra la imagen */
            background-repeat: no-repeat;
            /* Evita que la imagen se repita */
        }

        #btn-login {
            background-color: #050c58;
        }

        #btn-login:hover {
            background-color: rgb(19, 16, 196);
        }
    </style>
</head>

<body class="d-flex justify-content-center align-items-center vh-100">
    <form class="" id="form" name="form" novalidate>
        <?php echo csrf_field(); ?>
        <div class="bg-white p-4 rounded-5 text-secondary shadow" style="width: 25rem">
            <div class="text-center">
                <img class="img1 move-1 mb-4" src="<?php echo e(asset('images/institucion/logo.png')); ?>" alt=""
                    width="100px">
                <h3 class="text-center mb-2 text-black">SISTEMA DE GESTIÓN ACADÉMICA</h3>
            </div>
            <div class="mb-3">
                <label for="nroidenti" class="form-label mb-2 fs-13 label-color font-w500"
                    id="titulo_tipo">Código</label>
                <div class="input-group">
                    <span class="input-group-text"> <i class="fa fa-user"></i> </span>
                    <input type="text" class="form-control" id="nroidenti" name="nroidenti" autocomplete="off"
                        placeholder="Ingrese su nombre de usuario" required="">
                    <div class="invalid-feedback">Ingrese un código.</div>
                </div>
            </div>

            <div class="mb-3">
                <label for="text_input_codigo" class="form-label mb-2 fs-13 label-color font-w500"
                    id="titulo_tipo">Contraseña
                </label>
                <div class="input-group transparent-append">
                    <span class="input-group-text"> <i class="fa fa-lock"></i> </span>
                    <input type="password" class="form-control" id="password" name="password" autocomplete="off"
                        placeholder="Ingrese su contraseña" required="">
                    <span class="input-group-text show-pass active" id="btn_view_password">
                        <i class="fa fa-eye-slash"></i>
                        <i class="fa fa-eye"></i>
                    </span>
                    <div class="invalid-feedback">
                        Ingrese contraseña
                    </div>
                </div>
            </div>

            <a href="<?php echo e(route('password.request')); ?>" class="text-primary float-end mb-4">¿Olvidaste tu contraseña?</a>

            <button class="btn btn-block btn-primary" id="btn_button_login">Iniciar Sesión</button>
            <div class=" mt-4 col-xl-12">
                <a href="/login-google" class="btn btn-outline-light d-block social-bx">
                    <svg width="16" height="16" viewBox="0 0 28 28" fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path
                            d="M27.9851 14.2618C27.9851 13.1146 27.8899 12.2775 27.6837 11.4094H14.2788V16.5871H22.1472C21.9886 17.8738 21.132 19.8116 19.2283 21.1137L19.2016 21.287L23.44 24.4956L23.7336 24.5242C26.4304 22.0904 27.9851 18.5093 27.9851 14.2618Z"
                            fill="#4285F4" />
                        <path
                            d="M14.279 27.904C18.1338 27.904 21.37 26.6637 23.7338 24.5245L19.2285 21.114C18.0228 21.9356 16.4047 22.5092 14.279 22.5092C10.5034 22.5092 7.29894 20.0754 6.15663 16.7114L5.9892 16.7253L1.58205 20.0583L1.52441 20.2149C3.87224 24.7725 8.69486 27.904 14.279 27.904Z"
                            fill="#34A853" />
                        <path
                            d="M6.15656 16.7113C5.85516 15.8432 5.68072 14.913 5.68072 13.9519C5.68072 12.9907 5.85516 12.0606 6.14071 11.1925L6.13272 11.0076L1.67035 7.62109L1.52435 7.68896C0.556704 9.58024 0.00146484 11.7041 0.00146484 13.9519C0.00146484 16.1997 0.556704 18.3234 1.52435 20.2147L6.15656 16.7113Z"
                            fill="#FBBC05" />
                        <path
                            d="M14.279 5.3947C16.9599 5.3947 18.7683 6.52635 19.7995 7.47204L23.8289 3.6275C21.3542 1.37969 18.1338 0 14.279 0C8.69485 0 3.87223 3.1314 1.52441 7.68899L6.14077 11.1925C7.29893 7.82856 10.5034 5.3947 14.279 5.3947Z"
                            fill="#EB4335" />
                    </svg>
                    <span class="ms-1 font-w600 label-color">Iniciar Sesión con Google</span></a>
            </div>
            <div class=" mt-4 col-xl-12">
                <a href="/login-microsoft" class="btn btn-outline-light d-block social-bx">
                    <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="16" height="16"
                        viewBox="0 0 48 48">
                        <path fill="#ff5722" d="M6 6H22V22H6z" transform="rotate(-180 14 14)"></path>
                        <path fill="#4caf50" d="M26 6H42V22H26z" transform="rotate(-180 34 14)"></path>
                        <path fill="#ffc107" d="M26 26H42V42H26z" transform="rotate(-180 34 34)"></path>
                        <path fill="#03a9f4" d="M6 26H22V42H6z" transform="rotate(-180 14 34)"></path>
                    </svg>
                    <span class="ms-1 font-w600 label-color">Iniciar sesión con Microsoft</span></a>
            </div>
        </div>
    </form>
</body>

<!--**********************************
        Scripts
    ***********************************-->
<?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<?php echo $__env->make('pick_profile_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- Template JS -->
<script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/dlabnav-init.js')); ?>"></script>


<script>
    var authenticateRoute = "<?php echo e(route('login.authenticate')); ?>";
</script>
<?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/login.js']); ?>

</html>
<?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/welcome.blade.php ENDPATH**/ ?>