<!DOCTYPE html>
<html lang="en" class="h-100">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title>Recuperar contraseña</title>

    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
            background-image:
                url('<?php echo e(asset('images/institucion/fondo_login.png')); ?>'),
                linear-gradient(180deg, #552f19, #b8b8b8);
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
        }

        #btn-recover {
            background-color: #050c58;
        }

        #btn-recover:hover {
            background-color: rgb(19, 16, 196);
        }
    </style>
</head>

<body class="d-flex justify-content-center align-items-center vh-100">
    <form method="POST" action="<?php echo e(route('forgot-password')); ?>" id="recover-form">
        <?php echo csrf_field(); ?>
        <div class="bg-white p-4 rounded-5 text-secondary shadow" style="width: 25rem">
            <div class="text-center">
                <img class="img1 move-1 mb-4" src="<?php echo e(asset('images/institucion/logo.png')); ?>" alt=""
                    width="100px">
                <h3 class="text-center mb-2 text-black">Recuperar contraseña</h3>
                <p class="text-muted fs-6">Ingresa tu correo y te enviaremos un enlace para restablecer tu contraseña.
                </p>
            </div>

            <div class="mb-3">
                <label for="email" class="form-label mb-2 fs-13 label-color font-w500">Correo electrónico</label>
                <div class="input-group">
                    <span class="input-group-text"><i class="fa fa-envelope"></i></span>
                    <input type="email" class="form-control" id="email" name="email" autocomplete="off"
                        placeholder="Ej: usuario@correo.com" required>
                    <div class="invalid-feedback">Ingrese un correo válido.</div>
                </div>
            </div>

            <button class="btn btn-block btn-primary w-100" id="btn-recover">Enviar enlace</button>

            <div class="text-center mt-3">
                <a href="<?php echo e(url('/login')); ?>" class="text-primary">← Volver al inicio de sesión</a>
            </div>
        </div>
    </form>
</body>

<?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/dlabnav-init.js')); ?>"></script>

<?php echo app('Illuminate\Foundation\Vite')(['resources/js/auth/forgot-password.js']); ?>;

</html>
<?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>