<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Documentos de Titulación</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Documentación de Titulación
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- Column starts -->


                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Programas de Estudios</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlprogram" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Planes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height200 my-2 px-2">
                                            <ul id="tlplan" class="timeline">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- card -->
                            <div class="col-xl-4 col-lg-6 col-sm-6 col-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Estudiantes</h2>
                                    </div>

                                    <div class="card-body p-0">
                                        <!--  -->
                                        <div class="my-2 px-2">
                                            <select id="txt-students" class="form-control" data-size="5"
                                                data-show-subtext="true" data-live-search="true" required>
                                                <option disabled selected value="0">Buscar Estudiante</option>
                                            </select>
                                        </div>
                                        <div class="my-1 px-3">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>Nombres</strong>
                                                    <span id="txt-info-nombres" class="mb-0">--</span>
                                                </li>
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>ID</strong>
                                                    <span id="txt-info-id" class="mb-0">--</span>
                                                </li>
                                                <li class="list-group-item d-flex px-0 justify-content-between">
                                                    <strong>Año Egreso</strong>
                                                    <span id="txt-info-fec_egreso" class="mb-0">--</span>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>



                            <!-- column datatable -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">


                                    <div class="card-body p-4">
                                        <div class="d-flex justify-content-center">
                                            <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                                data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                                + Nuevo Item de Titulación Académica
                                            </button>
                                        </div>
                                    </div>

                                    
                                    

                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Item Titulacion</th>
                                                                <th class="text-center">Archivo</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Permiso de Observación</th>
                                                                <th class="text-center">Es Visible</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->



                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->



    <!-- Modal -->
    <form class="needs-validation" id="formModal">
        <?php echo csrf_field(); ?>
        <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nuevo Documento de Titulación
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">


                        <div class="row">
                            <input id="txt-id" name="txt-id" type="hidden">
                        
                            <!-- Ítem de Titulación -->
                            <div class="col-md-6" id="group-item-titulacion">
                                <div class="mb-3">
                                    <label for="txt-item_titulacion" class="form-label text-primary">Ítem de Titulación</label>
                                    <select id="txt-item_titulacion" name="txt-item_titulacion"
                                        class="form-control form-control-sm" required>
                                        <option selected disabled value="">Seleccione ítem</option>
                                        
                                    </select>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        
                            <!-- Archivo -->
                            <div class="col-md-6" id="group-archivo">
                                <div class="mb-3">
                                    <label for="txt-archivo" class="form-label text-primary">Archivo de Titulación</label>
                                    <input id="txt-archivo"
                                        name="txt-archivo"
                                        type="file"
                                        class="form-control form-control-sm"
                                        accept=".pdf,.jpg,.jpeg,.png"
                                        required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        
                            <!-- Estado Documento Titulación -->
                            <div class="col-md-6" id="group-estado">
                                <div class="mb-3">
                                    <label for="txt-estado" class="form-label text-primary">Estado</label>
                                    <select id="txt-estado" name="txt-estado" class="form-control form-control-sm">
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="0">Pendiente</option>
                                        <option value="1">Aprobado</option>
                                        <option value="2">Rechazado</option>
                                        <option value="3">Observado</option>
                                    </select>
                                    <small class="text-muted">
                                        Si el estado es 0 = <strong>Pendiente</strong><br>
                                        Si el estado es 1 = <strong>Aprobado</strong><br>
                                        Si el estado es 2 = <strong>Rechazado</strong><br>
                                        Si el estado es 3 = <strong>Observado</strong>
                                    </small>
                                </div>
                            </div>
                        
                            <!-- Permiso de Observación -->
                            <div class="col-md-6" id="group-permiso">
                                <div class="mb-3">
                                    <label for="txt-permiso_observacion" class="form-label text-primary">Permiso de Observación</label>
                                    <select id="txt-permiso_observacion" name="txt-permiso_observacion"
                                        class="form-control form-control-sm">
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="0">Sin Permiso</option>
                                        <option value="1">Permitido Subsanar</option>
                                    </select>
                                    <small class="text-muted">
                                        Si el permiso de observación es 0 = <strong>Sin Permiso</strong><br>
                                        Si el permiso de observación es 1 = <strong>Permitido Subsanar</strong>
                                    </small>
                                </div>
                            </div>
                        
                            <!-- Es Visible -->
                            <div class="col-md-6" id="group-visible">
                                <div class="mb-3">
                                    <label for="txt-es_visible" class="form-label text-primary">Es Visible</label>
                                    <select id="txt-es_visible" name="txt-es_visible" class="form-control form-control-sm">
                                        <option selected disabled value="">Seleccione opción</option>
                                        <option value="0">Oculto</option>
                                        <option value="1">Visible</option>
                                    </select>
                                    <small class="text-muted">
                                        Si es 0 = <strong>Oculto</strong><br>
                                        Si es 1 = <strong>Visible</strong>
                                    </small>
                                </div>
                            </div>
                        </div>
                        


                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm">Guardar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>




    <form class="needs-validation" id="formEstado">
        <?php echo csrf_field(); ?>
        <div id="modalUpdateEstado" class="modal fade" tabindex="-1"
            aria-labelledby="modalUpdateEstadoLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdateEstadoLabel">
                            Actualizar estado del Documento de Titulación
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <input id="txt-id-estado" name="txt-id-estado" type="hidden">
    
                        <div class="mb-3">
                            <label class="form-label text-primary">Estado del documento</label>
                            <select id="estado-documento" name="estado"
                                class="form-control form-control-sm" required>
                                <option selected disabled value="">Seleccione opción</option>
                                <option value="0">Pendiente</option>
                                <option value="1">Aprobado</option>
                                <option value="2">Rechazado</option>
                                <option value="3">Observado</option>
                            </select>
                        </div>
    
                        <small class="text-muted d-block">
                            <strong>Pendiente (0):</strong> El documento está registrado pero aún no ha sido revisado.<br>
                            <strong>Aprobado (1):</strong> El documento cumple con los requisitos de titulación.<br>
                            <strong>Rechazado (2):</strong> El documento no cumple los requisitos y debe ser reemplazado.<br>
                            <strong>Observado (3):</strong> El documento presenta observaciones que pueden ser subsanadas,
                            según el permiso otorgado.
                        </small>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdateEstado" type="button"
                            class="btn btn-primary btn-sm">Actualizar estado</button>
                    </div>
                </div>
            </div>
        </div>
    </form>





    <form class="needs-validation" id="formPermiso">
        <?php echo csrf_field(); ?>
        <div id="modalUpdatePermiso" class="modal fade" tabindex="-1"
            aria-labelledby="modalUpdatePermisoLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalUpdatePermisoLabel">
                            Actualizar permiso de subsanación del documento
                        </h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body px-3 py-2">
                        <input id="txt-id-permiso" name="txt-id-permiso" type="hidden">
    
                        <div class="mb-3">
                            <label class="form-label text-primary">Permiso de observación / subsanación</label>
                            <select id="permiso-documento" name="permiso_observacion"
                                class="form-control form-control-sm" required>
                                <option selected disabled value="">Seleccione opción</option>
                                <option value="0">Sin permiso de subsanación</option>
                                <option value="1">Permitido subsanar</option>
                            </select>
                        </div>
    
                        <small class="text-muted d-block">
                            <strong>Sin permiso (0):</strong> El estudiante <u>no</u> puede subir un nuevo archivo en base
                            a observaciones.<br>
                            <strong>Permitido subsanar (1):</strong> El estudiante está autorizado a subsanar el documento
                            observado, según las indicaciones de la comisión.
                        </small>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnUpdatePermiso" type="button"
                            class="btn btn-primary btn-sm">Actualizar permiso</button>
                    </div>
                </div>
            </div>
        </div>
    </form>
    
    





    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/seguimiento_egresado/documentos_titulacion.js']); ?>;

    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/seguimiento_egresado/documentos_titulacion/index.blade.php ENDPATH**/ ?>