<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Auditorías</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">

    <style>
        .audit-summary-label {
            font-size: 0.75rem;
            text-transform: uppercase;
            letter-spacing: .04em;
            color: #6c757d;
        }

        .audit-summary-value {
            font-size: 0.85rem;
            font-weight: 600;
            color: #212529;
        }

        .audit-url {
            font-size: 0.8rem;
            word-break: break-all;
        }

        .audit-json-block {
            background-color: #f5f6ff;
            border-radius: 0.75rem;
            max-height: 420px;
            overflow: auto;
            font-size: 0.8rem;
            font-family: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;
            color: #1f2937;
        }

        .audit-json-block::-webkit-scrollbar {
            height: 6px;
            width: 6px;
        }

        .audit-json-block::-webkit-scrollbar-thumb {
            background-color: rgba(148, 163, 184, 0.8);
            border-radius: 999px;
        }
    </style>

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            Auditorías
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Supervisión de actividad y auditorías</h4>
                                            <span class="text-muted small">
                                                Registro de acciones realizadas en el sistema
                                                (creación, actualización y eliminación de datos).
                                            </span>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <form id="filtersForm" class="row g-2 mb-3">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Evento</label>
                                                        <select id="filter-event" class="form-control form-control-sm">
                                                            <option value="">Todos</option>
                                                            <option value="created">CREATED</option>
                                                            <option value="updated">UPDATED</option>
                                                            <option value="deleted">DELETED</option>
                                                        </select>
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">ID Usuario</label>
                                                        <input id="filter-user-id" type="number"
                                                            class="form-control form-control-sm" placeholder="ID">
                                                    </div>

                                                    <div class="col-12 col-md-3">
                                                        <label class="form-label small mb-1">Nombre usuario</label>
                                                        <input id="filter-user-name" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="Nombre o apellidos">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Rol</label>
                                                        <input id="filter-user-type" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="Administrador">
                                                    </div>

                                                    <div class="col-6 col-md-3">
                                                        <label class="form-label small mb-1">Modelo</label>
                                                        <input id="filter-auditable-type" type="text"
                                                            class="form-control form-control-sm"
                                                            placeholder="Usuarios">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">IP</label>
                                                        <input id="filter-ip" type="text"
                                                            class="form-control form-control-sm" placeholder="IP">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Desde</label>
                                                        <input id="filter-date-from" type="date"
                                                            class="form-control form-control-sm">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Hasta</label>
                                                        <input id="filter-date-to" type="date"
                                                            class="form-control form-control-sm">
                                                    </div>

                                                    <div class="col-6 col-md-2">
                                                        <label class="form-label small mb-1">Máx. registros</label>
                                                        <input id="filter-max-records" type="number" min="1"
                                                            class="form-control form-control-sm" placeholder="500">
                                                    </div>

                                                    <div
                                                        class="col-12 col-md-3 d-flex align-items-end justify-content-start gap-2 mt-2 mt-md-0">
                                                        <button type="button" id="btnFilter"
                                                            class="btn btn-primary btn-sm">
                                                            <i class="fas fa-search"></i> Buscar
                                                        </button>
                                                        <button type="button" id="btnClearFilters"
                                                            class="btn btn-secondary btn-sm">
                                                            Limpiar
                                                        </button>
                                                    </div>
                                                </form>

                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Fecha</th>
                                                                <th class="text-center">Evento</th>
                                                                <th class="text-center">Usuario</th>
                                                                <th class="text-center">Rol</th>
                                                                <th class="text-center">Modelo / Tabla</th>
                                                                <th class="text-center">IP</th>
                                                                <th class="text-center">Detalles</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!-- DataTables llenará el contenido -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>

    <div class="modal fade" id="modalAuditDetail" tabindex="-1" aria-labelledby="modalAuditDetailLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content border-0 shadow-lg">
                <div class="modal-header border-0">
                    <div class="d-flex flex-column">
                        <span class="card-title text-uppercase mb-1">Detalle de auditoría</span>
                        <h5 class="modal-title fw-bold d-flex align-items-center gap-2" id="modalAuditDetailLabel">
                            <i class="fas fa-clipboard-list text-primary"></i>
                            <span id="auditDetail-event"></span>
                        </h5>
                    </div>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Cerrar"></button>
                </div>
                <div class="modal-body pt-2">
                    <div class="bg-light rounded-3 border px-3 py-3 mb-3">
                        <div class="row g-2">
                            <div class="col-12 col-md-4">
                                <div class="mb-1 audit-summary-label">Fecha y hora</div>
                                <div class="audit-summary-value" id="auditDetail-datetime">--</div>
                            </div>
                            <div class="col-12 col-md-4">
                                <div class="mb-1 audit-summary-label">Usuario</div>
                                <div class="audit-summary-value" id="auditDetail-user">--</div>
                            </div>
                            <div class="col-12 col-md-4">
                                <div class="mb-1 audit-summary-label">Modelo</div>
                                <div class="audit-summary-value" id="auditDetail-model">--</div>
                            </div>
                            <div class="col-12 col-md-4">
                                <div class="mb-1 audit-summary-label">IP</div>
                                <div class="audit-summary-value" id="auditDetail-ip">--</div>
                            </div>
                            <div class="col-12 col-md-8">
                                <div class="mb-1 audit-summary-label">URL</div>
                                <div class="audit-url" id="auditDetail-url">--</div>
                            </div>
                        </div>
                    </div>

                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <h6 class="card-title mb-0 text-muted small">
                                Valores anteriores
                            </h6>
                            <div class="pt-2">
                                <pre id="pre-old-values" class="audit-json-block p-3 mb-0">[]</pre>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <h6 class="card-title mb-0 text-muted small">
                                Valores nuevos
                            </h6>
                            <div class="pt-2">
                                <pre id="pre-new-values" class="audit-json-block p-3 mb-0">[]</pre>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer border-0 pt-0">
                    <button type="button" class="btn btn-secondary btn-sm px-3"
                        data-bs-dismiss="modal">Cerrar</button>
                </div>
            </div>
        </div>
    </div>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/seguridad/auditoria.js']); ?>

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/seguridad/auditoria/index.blade.php ENDPATH**/ ?>