<!DOCTYPE html>
<html lang="es">

<head>
    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Horario x Docente</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
</head>

<body>
    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            <?php echo e(__('Horario por Docente')); ?>

        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">

                            <!-- card -->
                            <div class="col-xl-2 col-lg-12 col-sm-12"></div>
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Periodo Lectivo</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <!--  -->
                                        <select id="txt-semesters" class="form-control" data-show-subtext="true"
                                            data-live-search="true" required>
                                            <option disabled selected value="0">Buscar Periodo</option>
                                        </select>
                                        <!--  -->
                                        <input type="hidden" id="txt-idteacher" name="txt-idteacher">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlsemester">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- card -->
                            <div class="col-xl-4 col-lg-12 col-sm-12">
                                <div class="card">
                                    <div class="card-header border-1 bg-primary pb-2 pt-2 justify-content-center">
                                        <h2 class="card-title text-light">Docentes</h2>
                                    </div>
                                    <div class="card-body p-0">
                                        <!--  -->
                                        <select id="txt-teachers" class="form-control" data-show-subtext="true"
                                            data-live-search="true" required>
                                            <option disabled selected value="0">Buscar Docente</option>
                                        </select>
                                        <!--  -->
                                        <input type="hidden" id="txt-idteacher" name="txt-idteacher">
                                        <div id="DZ_W_TimeLine" class="widget-timeline dlab-scroll height300 my-2 px-2">
                                            <ul class="timeline" id="tlteacher">
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-2 col-lg-12 col-sm-12"></div>
                            <!-- Modal Buscar Docente -->
                            <!--
                            primary
                            info
                            danger
                            success
                            warning
                            dark
                            -->

                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <!--  -->
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display table"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">Programa</th>
                                                                <th class="text-center">Plan</th>
                                                                
                                                                <th class="text-center">curso</th>
                                                                
                                                                <th class="text-center">Seccion</th>
                                                                
                                                                <th class="text-center">Periodo</th>
                                                                <th class="text-center">Lunes</th>
                                                                <th class="text-center">Martes</th>
                                                                <th class="text-center">Miercoles</th>
                                                                <th class="text-center">Jueves</th>
                                                                <th class="text-center">Viernes</th>
                                                                <th class="text-center">Sabado</th>
                                                                <th class="text-center">Aula</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="text-primary">
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>


    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <input type="hidden" id="txt-idsemester" name="txt-idsemester">
        <input type="hidden" id="txt-idteacher" name="txt-idteacher">
    </form>

    <!--**********************************
        Main wrapper end
    ***********************************-->


    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;


    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/semesters.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/teachers.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/horarios/horario_docente.js']); ?>;

    
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>
</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/horarios/horario_docente/index.blade.php ENDPATH**/ ?>