<!DOCTYPE html>
<html lang="es">

<head>

    <?php echo $__env->make('include.meta-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.plugins-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Page Title Here -->
    <title>Informe de Postulaciones</title>

    <?php echo $__env->make('include.datatable-styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="<?php echo e(asset('/css/style.css')); ?>" rel="stylesheet">
    

</head>

<body>

    <?php echo $__env->make('include.preloader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        <?php echo $__env->make('include.nav_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        
        <?php $__env->startSection('titlenavbar'); ?>
            informe de Postulaciones
        <?php $__env->stopSection(); ?>

        <?php echo $__env->make('include.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            
                            <div class="row col-xl-12">
                                <!-- FILTRO -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-companies" class="form-label text-primary"><b><h4>Seleccione una empresa</h4></b></label>
                                    <select id="txt-companies" name="txt-companies" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-categories" class="form-label text-primary"><b><h4>Seleccione una categoria</h4></b></label>
                                    <select id="txt-categories" name="txt-categories"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre postulaciones</h4>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Empresa</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Postulante</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Celular</th>
                                                                <th class="text-center">Fecha Postulación</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        <?php echo $__env->make('include.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        <?php echo csrf_field(); ?>
        <div id="modalFeedback" class="modal fade" tabindex="-1" aria-labelledby="modalFeedbackLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalFeedbackLabel">Feedback</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idjobapplication" name="txt-idjobapplication">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-feedback" class="form-label text-primary">Comentario</label>
                                    <input id="txt-feedback" name="txt-feedback" type="text"
                                        class="form-control form-control-sm" required>
                                    <?php echo $__env->make('include.div.invalid-feedback', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-feedback" class="form-label text-primary">Comentarios
                                        Predeterminados</label>
                                    <div id="div-feedback-aprobar">
                                        <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                            value="¡Tu CV es de nuestro agrado, nos pondremos en contacto!">
                                        <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                            value="¡Requerimos una entrevista presencial, nos pondremos en contacto!">
                                    </div>
                                    <div id="div-feedback-rechazar">
                                    <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                        value="¡Apreciamos tu interés, pero tu CV no ha sido seleccionado en esta ocasión!">
                                    <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                        value="¡Agradecemos tu participación y te animamos a seguir buscando oportunidades!">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnAprobarRechazar" type="button" class="btn btn-primary btn-sm ">Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    <?php echo $__env->make('include.plugins-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->make('include.datatable-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Template JS -->
    <script src="<?php echo e(asset('/js/custom.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/dlabnav-init.js')); ?>"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '<?php echo e(route('logout')); ?>';
    </script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/login/logout.js']); ?>;

    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/jpcompanies.js']); ?>;
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/common/combobox/jpcategories.js']); ?>;

    <!--  Page JS -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/admin/bolsa_laboral/postulaciones.js']); ?>;

</body>

</html>

<?php echo $__env->make('include.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/istapidex/public_html/sga.istap.edu.pe/resources/views/admin/bolsa_laboral/postulaciones/index.blade.php ENDPATH**/ ?>